# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{amqp}
  s.version = "0.6.7"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Aman Gupta"]
  s.date = %q{2009-12-29}
  s.description = %q{An implementation of the AMQP protocol in Ruby/EventMachine for writing clients to the RabbitMQ message broker}
  s.email = %q{amqp@tmm1.net}
  s.extra_rdoc_files = ["README", "doc/EXAMPLE_01_PINGPONG", "doc/EXAMPLE_02_CLOCK", "doc/EXAMPLE_03_STOCKS", "doc/EXAMPLE_04_MULTICLOCK", "doc/EXAMPLE_05_ACK", "doc/EXAMPLE_05_POP", "doc/EXAMPLE_06_HASHTABLE"]
  s.files = ["README", "Rakefile", "amqp.gemspec", "amqp.todo", "doc/EXAMPLE_01_PINGPONG", "doc/EXAMPLE_02_CLOCK", "doc/EXAMPLE_03_STOCKS", "doc/EXAMPLE_04_MULTICLOCK", "doc/EXAMPLE_05_ACK", "doc/EXAMPLE_05_POP", "doc/EXAMPLE_06_HASHTABLE", "examples/amqp/simple.rb", "examples/mq/ack.rb", "examples/mq/clock.rb", "examples/mq/pop.rb", "examples/mq/hashtable.rb", "examples/mq/internal.rb", "examples/mq/logger.rb", "examples/mq/multiclock.rb", "examples/mq/pingpong.rb", "examples/mq/primes-simple.rb", "examples/mq/primes.rb", "examples/mq/stocks.rb", "lib/amqp.rb", "lib/amqp/version.rb", "lib/amqp/buffer.rb", "lib/amqp/client.rb", "lib/amqp/frame.rb", "lib/amqp/protocol.rb", "lib/amqp/server.rb", "lib/amqp/spec.rb", "lib/ext/blankslate.rb", "lib/ext/em.rb", "lib/ext/emfork.rb", "lib/mq.rb", "lib/mq/exchange.rb", "lib/mq/header.rb", "lib/mq/logger.rb", "lib/mq/queue.rb", "lib/mq/rpc.rb", "old/README", "old/Rakefile", "old/amqp-0.8.json", "old/amqp_spec.rb", "old/amqpc.rb", "old/codegen.rb", "protocol/amqp-0.8.json", "protocol/amqp-0.8.xml", "protocol/codegen.rb", "protocol/doc.txt", "research/api.rb", "research/primes-forked.rb", "research/primes-processes.rb", "research/primes-threaded.rb"]
  s.homepage = %q{http://amqp.rubyforge.org/}
  s.rdoc_options = ["--include=examples"]
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{amqp}
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{AMQP client implementation in Ruby/EventMachine}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<eventmachine>, [">= 0.12.4"])
    else
      s.add_dependency(%q<eventmachine>, [">= 0.12.4"])
    end
  else
    s.add_dependency(%q<eventmachine>, [">= 0.12.4"])
  end
end
