/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalTabbedPaneUI
extends BasicTabbedPaneUI {
    protected int minTabWidth;
    protected Color selectColor;
    protected Color selectHighlight;
    protected Color tabAreaBackground;
    private Graphics hg;
    private boolean tabsOpaque;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new TabbedPaneLayout(this);
        }
        return super.createLayoutManager();
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n4 + n6 - 1;
        int n8 = n3 + n5 - 1;
        switch (n) {
            case 2: {
                this.paintLeftTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            case 3: {
                this.paintBottomTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            case 4: {
                this.paintRightTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            default: {
                this.paintTopTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
            }
        }
    }

    protected void paintTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.tabPane.getTabCount();
        int n9 = this.getRunForTab(n8, n);
        int n10 = n4 - 1;
        int n11 = n5 - 1;
        if (this.shouldFillGap(n9, n, n2, n3)) {
            graphics.translate(n2, n3);
            graphics.setColor(this.getColorForGap(n9, n2, n3 + 1));
            graphics.fillRect(1, 0, 5, 3);
            graphics.fillRect(1, 3, 2, 2);
            graphics.translate(-n2, -n3);
        }
        graphics.translate(n2, n3);
        boolean bl2 = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (bl2 && bl) {
            graphics.setColor(color);
        } else {
            graphics.setColor(this.darkShadow);
        }
        graphics.drawLine(1, 5, 6, 0);
        graphics.drawLine(6, 0, n10, 0);
        int n12 = this.lastTabInRun(n8, n9);
        if (n == n12) {
            graphics.drawLine(n10, 1, n10, n11);
        }
        int n13 = this.tabPane.getSelectedIndex();
        if (bl2 && n - 1 == n13 && n9 == this.getRunForTab(n8, n13)) {
            graphics.setColor(color);
        }
        if (n != this.tabRuns[this.runCount - 1]) {
            if (bl2 && bl) {
                graphics.drawLine(0, 6, 0, n11);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(0, 0, 0, 5);
            } else {
                graphics.drawLine(0, 0, 0, n11);
            }
        } else {
            graphics.drawLine(0, 6, 0, n11);
        }
        graphics.setColor(bl ? this.selectHighlight : this.highlight);
        graphics.drawLine(1, 6, 6, 1);
        graphics.drawLine(6, 1, n10, 1);
        graphics.drawLine(1, 6, 1, n11);
        int n14 = this.tabRuns[n9];
        if (n == n14 && n != this.tabRuns[this.runCount - 1]) {
            if (this.tabPane.getSelectedIndex() == this.tabRuns[n9 + 1]) {
                graphics.setColor(this.selectHighlight);
            } else {
                graphics.setColor(this.highlight);
            }
            graphics.drawLine(1, 0, 1, 4);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintLeftTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2;
        graphics.translate(n2, n3);
        int n8 = n5 - 1;
        int n9 = n4 - 1;
        int n10 = this.tabPane.getTabCount();
        int n11 = this.getRunForTab(n10, n);
        int n12 = this.tabRuns[n11];
        if (n != n12 && n > 0 && this.tabsOpaque) {
            Color color = this.tabPane.getSelectedIndex() == n - 1 ? this.selectColor : this.getUnselectedBackground(n - 1);
            graphics.setColor(color);
            graphics.fillRect(2, 0, 4, 3);
            graphics.drawLine(2, 3, 2, 3);
        }
        if (bl2 = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
            graphics.setColor(bl ? this.selectHighlight : MetalLookAndFeel.getWhite());
        } else {
            graphics.setColor(bl ? this.selectHighlight : this.highlight);
        }
        graphics.drawLine(1, 6, 6, 1);
        graphics.drawLine(1, 6, 1, n8);
        graphics.drawLine(6, 1, n9, 1);
        if (n != n12) {
            if (bl2) {
                graphics.setColor(MetalLookAndFeel.getWhite());
            }
            graphics.drawLine(1, 0, 1, 4);
        }
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (bl2 && bl) {
            graphics.setColor(color);
        } else {
            graphics.setColor(this.darkShadow);
        }
        graphics.drawLine(1, 5, 6, 0);
        graphics.drawLine(6, 0, n9, 0);
        int n13 = this.lastTabInRun(n10, n11);
        if (n == n13) {
            graphics.drawLine(0, n8, n9, n8);
        }
        if (bl2) {
            if (this.tabPane.getSelectedIndex() == n - 1) {
                graphics.drawLine(0, 6, 0, n8);
                if (n != n12) {
                    graphics.setColor(color);
                    graphics.drawLine(0, 0, 0, 5);
                }
            } else if (bl) {
                graphics.drawLine(0, 5, 0, n8);
                if (n != n12) {
                    graphics.setColor(this.darkShadow);
                    graphics.drawLine(0, 0, 0, 5);
                }
            } else if (n != n12) {
                graphics.drawLine(0, 0, 0, n8);
            } else {
                graphics.drawLine(0, 6, 0, n8);
            }
        } else if (n != n12) {
            graphics.drawLine(0, 0, 0, n8);
        } else {
            graphics.drawLine(0, 6, 0, n8);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintRightTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        graphics.translate(n2, n3);
        int n8 = n5 - 1;
        int n9 = n4 - 1;
        int n10 = this.tabPane.getTabCount();
        int n11 = this.getRunForTab(n10, n);
        int n12 = this.tabRuns[n11];
        if (n != n12 && n > 0 && this.tabsOpaque) {
            Color color = this.tabPane.getSelectedIndex() == n - 1 ? this.selectColor : this.getUnselectedBackground(n - 1);
            graphics.setColor(color);
            graphics.fillRect(n9 - 5, 0, 5, 3);
            graphics.fillRect(n9 - 2, 3, 2, 2);
        }
        graphics.setColor(bl ? this.selectHighlight : this.highlight);
        graphics.drawLine(n9 - 6, 1, n9 - 1, 6);
        graphics.drawLine(0, 1, n9 - 6, 1);
        if (!bl) {
            graphics.drawLine(0, 1, 0, n8);
        }
        boolean bl2 = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (bl2 && bl) {
            graphics.setColor(color);
        } else {
            graphics.setColor(this.darkShadow);
        }
        int n13 = this.lastTabInRun(n10, n11);
        if (n == n13) {
            graphics.drawLine(0, n8, n9, n8);
        }
        if (bl2 && this.tabPane.getSelectedIndex() == n - 1) {
            graphics.setColor(color);
        }
        graphics.drawLine(n9 - 6, 0, n9, 6);
        graphics.drawLine(0, 0, n9 - 6, 0);
        if (bl2 && bl) {
            graphics.drawLine(n9, 6, n9, n8);
            if (n != n12) {
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n9, 0, n9, 5);
            }
        } else if (bl2 && this.tabPane.getSelectedIndex() == n - 1) {
            if (n != n12) {
                graphics.setColor(color);
                graphics.drawLine(n9, 0, n9, 6);
            }
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n9, 7, n9, n8);
        } else if (n != n12) {
            graphics.drawLine(n9, 0, n9, n8);
        } else {
            graphics.drawLine(n9, 6, n9, n8);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintBottomTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = n5 - 1;
        int n9 = n4 - 1;
        int n10 = this.tabPane.getTabCount();
        int n11 = this.getRunForTab(n10, n);
        if (this.shouldFillGap(n11, n, n2, n3)) {
            graphics.translate(n2, n3);
            graphics.setColor(this.getColorForGap(n11, n2, n3));
            graphics.fillRect(1, n8 - 4, 3, 5);
            graphics.fillRect(4, n8 - 1, 2, 2);
            graphics.translate(-n2, -n3);
        }
        graphics.translate(n2, n3);
        boolean bl2 = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (bl2 && bl) {
            graphics.setColor(color);
        } else {
            graphics.setColor(this.darkShadow);
        }
        graphics.drawLine(1, n8 - 5, 6, n8);
        graphics.drawLine(6, n8, n9, n8);
        int n12 = this.lastTabInRun(n10, n11);
        if (n == n12) {
            graphics.drawLine(n9, 0, n9, n8);
        }
        if (bl2 && bl) {
            graphics.drawLine(0, 0, 0, n8 - 5);
            if (n != this.tabRuns[this.runCount - 1]) {
                graphics.setColor(this.darkShadow);
                graphics.drawLine(0, n8 - 5, 0, n8);
            }
        } else {
            if (bl2 && n == this.tabPane.getSelectedIndex() + 1) {
                graphics.setColor(color);
            }
            if (n != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(0, 0, 0, n8);
            } else {
                graphics.drawLine(0, 0, 0, n8 - 6);
            }
        }
        graphics.setColor(bl ? this.selectHighlight : this.highlight);
        graphics.drawLine(1, n8 - 6, 6, n8 - 1);
        graphics.drawLine(1, 0, 1, n8 - 6);
        int n13 = this.tabRuns[n11];
        if (n == n13 && n != this.tabRuns[this.runCount - 1]) {
            if (this.tabPane.getSelectedIndex() == this.tabRuns[n11 + 1]) {
                graphics.setColor(this.selectHighlight);
            } else {
                graphics.setColor(this.highlight);
            }
            graphics.drawLine(1, n8 - 4, 1, n8);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            graphics.setColor(this.selectColor);
        } else {
            graphics.setColor(this.getUnselectedBackground(n2));
        }
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 5, n4 + 1, n5 - 5, n6 - 1);
                graphics.fillRect(n3 + 2, n4 + 4, 3, n6 - 4);
                break;
            }
            case 3: {
                graphics.fillRect(n3 + 2, n4, n5 - 2, n6 - 3);
                graphics.fillRect(n3 + 5, n4 + n6 - 4, n5 - 5, 3);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 4, n6 - 1);
                graphics.fillRect(n3 + n5 - 4, n4 + 5, 3, n6 - 5);
                break;
            }
            default: {
                graphics.fillRect(n3 + 4, n4 + 2, n5 - 4, n6 - 2);
                graphics.fillRect(n3 + 2, n4 + 5, 2, n6 - 5);
            }
        }
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.tabPane.hasFocus() && bl) {
            Rectangle rectangle3 = rectangleArray[n2];
            graphics.setColor(this.focus);
            graphics.translate(rectangle3.x, rectangle3.y);
            switch (n) {
                case 2: {
                    graphics.drawLine(7, 2, rectangle3.width - 2, 2);
                    graphics.drawLine(rectangle3.width - 1, 2, rectangle3.width - 1, rectangle3.height - 3);
                    graphics.drawLine(rectangle3.width - 2, rectangle3.height - 2, 3, rectangle3.height - 2);
                    graphics.drawLine(2, rectangle3.height - 3, 2, 7);
                    graphics.drawLine(2, 6, 6, 2);
                    break;
                }
                case 4: {
                    graphics.drawLine(1, 2, rectangle3.width - 8, 2);
                    graphics.drawLine(rectangle3.width - 7, 2, rectangle3.width - 3, 6);
                    graphics.drawLine(rectangle3.width - 3, 7, rectangle3.width - 3, rectangle3.height - 3);
                    graphics.drawLine(rectangle3.width - 3, rectangle3.height - 2, 2, rectangle3.height - 2);
                    graphics.drawLine(1, rectangle3.height - 2, 1, 2);
                    break;
                }
                case 3: {
                    graphics.drawLine(2, 1, rectangle3.width - 2, 1);
                    graphics.drawLine(rectangle3.width - 1, 2, rectangle3.width - 1, rectangle3.height - 3);
                    graphics.drawLine(7, rectangle3.height - 3, rectangle3.width - 2, rectangle3.height - 3);
                    graphics.drawLine(6, rectangle3.height - 3, 2, rectangle3.height - 7);
                    graphics.drawLine(2, rectangle3.height - 8, 2, 2);
                    break;
                }
                default: {
                    graphics.drawLine(6, 2, rectangle3.width - 2, 2);
                    graphics.drawLine(rectangle3.width - 1, 2, rectangle3.width - 1, rectangle3.height - 3);
                    graphics.drawLine(3, rectangle3.height - 3, rectangle3.width - 2, rectangle3.height - 3);
                    graphics.drawLine(2, rectangle3.height - 3, 2, 7);
                    graphics.drawLine(2, 6, 6, 2);
                }
            }
            graphics.translate(-rectangle3.x, -rectangle3.y);
        }
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount - 1 > n2;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.minTabWidth = 0;
    }

    protected Color getColorForGap(int n, int n2, int n3) {
        int n4 = this.tabForCoordinate(this.tabPane, n2, n3);
        int n5 = this.tabPane.getSelectedIndex();
        if (n5 == n4) {
            return this.selectColor;
        }
        return this.tabAreaBackground;
    }

    protected boolean shouldFillGap(int n, int n2, int n3, int n4) {
        return false;
    }

    protected void paintHighlightBelowTab() {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        Rectangle rectangle = this.getTabBounds(this.tabPane, n);
        this.hg.setColor(this.selectColor);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (n2 == 1) {
            this.hg.fillRect(n3, n4 + n6 - 2, n5, 30);
        } else if (n2 == 2) {
            this.hg.fillRect(n3 + n5 - 1, n4, 20, n6);
        } else if (n2 == 3) {
            this.hg.fillRect(n3, n4 - n6 + 2, n5, 30);
        } else if (n2 == 4) {
            this.hg.fillRect(n3 - 18, n4, 20, n6);
        } else {
            throw new AssertionError((Object)"Unrecognised 'tabPlacement' argument.");
        }
        this.hg = null;
    }

    protected boolean shouldRotateTabRuns(int n, int n2) {
        return false;
    }

    protected int calculateMaxTabHeight(int n) {
        return super.calculateMaxTabHeight(n);
    }

    protected int getTabRunOverlay(int n) {
        int n2 = 0;
        if (n == 2 || n == 4) {
            int n3 = this.calculateMaxTabHeight(n);
            n2 = this.maxTabHeight / 2;
        }
        return n2;
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        boolean bl = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        if (bl) {
            graphics.setColor(color);
        } else {
            graphics.setColor(this.selectHighlight);
        }
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        if (n != 1 || n2 < 0 || rectangle.y + rectangle.height + 1 < n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
            if (bl && n == 1) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                graphics.drawLine(n3, n4 + 1, n3 + n5 - 2, n4 + 1);
            }
        } else {
            boolean bl2 = this.isLastTabInRun(n2);
            if (bl2) {
                graphics.drawLine(n3, n4, rectangle.x + 1, n4);
            } else {
                graphics.drawLine(n3, n4, rectangle.x, n4);
            }
            int n7 = n3 + n5 - 1;
            if (rectangle.x + rectangle.width < n7 - 1) {
                if (bl2) {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n4, n7 - 1, n4);
                } else {
                    graphics.drawLine(rectangle.x + rectangle.width, n4, n7 - 1, n4);
                }
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
            }
            if (bl) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                if (bl2) {
                    graphics.drawLine(n3, n4 + 1, rectangle.x + 1, n4 + 1);
                } else {
                    graphics.drawLine(n3, n4 + 1, rectangle.x, n4 + 1);
                }
                if (rectangle.x + rectangle.width < n7 - 1) {
                    if (bl2) {
                        graphics.drawLine(rectangle.x + rectangle.width - 1, n4 + 1, n7 - 1, n4 + 1);
                    } else {
                        graphics.drawLine(rectangle.x + rectangle.width, n4 + 1, n7 - 1, n4 + 1);
                    }
                } else {
                    graphics.setColor(this.shadow);
                    graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                }
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.darkShadow);
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        boolean bl = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (n != 3 || n2 < 0 || rectangle.y - 1 > n6 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            if (bl && n == 3) {
                graphics.setColor(color);
            }
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            boolean bl2 = this.isLastTabInRun(n2);
            if (bl) {
                graphics.setColor(color);
            }
            int n7 = n4 + n6 - 1;
            int n8 = n3 + n5 - 1;
            if (bl2) {
                graphics.drawLine(n3, n7, rectangle.x, n7);
            } else {
                graphics.drawLine(n3, n7, rectangle.x - 1, n7);
            }
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                if (bl2) {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n7, n8, n7);
                } else {
                    graphics.drawLine(rectangle.x + rectangle.width, n7, n8, n7);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        boolean bl = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        if (bl) {
            graphics.setColor(color);
        } else {
            graphics.setColor(this.selectHighlight);
        }
        if (n != 2 || n2 < 0 || rectangle.x + rectangle.width + 1 < n3 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3, n4 + 1, n3, n4 + n6 - 2);
            if (bl && n == 2) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                graphics.drawLine(n3, n4 + 1, n3, n4 + n6 - 2);
            }
        } else {
            graphics.drawLine(n3, n4, n3, rectangle.y + 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.drawLine(n3, rectangle.y + rectangle.height + 1, n3, n4 + n6 + 2);
            }
            if (bl) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, rectangle.y + 1);
                if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                    graphics.drawLine(n3 + n4, rectangle.y + rectangle.height + 1, n3 + 1, n4 + n6 + 2);
                }
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.darkShadow);
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        boolean bl = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color color = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (n != 4 || n2 < 0 || rectangle.x - 1 > n5 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            if (bl && n == 4) {
                graphics.setColor(color);
            }
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            if (bl) {
                graphics.setColor(color);
            }
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, rectangle.y);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
            }
        }
    }

    private boolean isLastTabInRun(int n) {
        int n2;
        int n3 = this.tabPane.getTabCount();
        int n4 = this.lastTabInRun(n3, n2 = this.getRunForTab(n3, n));
        return n == n4;
    }

    private Color getUnselectedBackground(int n) {
        Color color = this.tabPane.getBackgroundAt(n);
        Color color2 = UIManager.getColor("TabbedPane.unselectedBackground");
        if (color instanceof UIResource && color2 != null) {
            color = color2;
        }
        return color;
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private /* synthetic */ MetalTabbedPaneUI this$0;

        public TabbedPaneLayout(MetalTabbedPaneUI metalTabbedPaneUI) {
            this.this$0 = metalTabbedPaneUI;
            super(metalTabbedPaneUI);
        }

        protected void rotateTabRuns(int n, int n2) {
        }

        protected void padSelectedTab(int n, int n2) {
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                super.normalizeTabRuns(n, n2, n3, n4);
            }
        }
    }
}

