/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarInputStream
extends ZipInputStream {
    private Manifest manifest;
    private JarEntry firstEntry;

    public JarInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public JarInputStream(InputStream inputStream, boolean bl) throws IOException {
        super(inputStream);
        this.readManifest(bl);
    }

    private void readManifest(boolean bl) throws IOException {
        this.firstEntry = (JarEntry)super.getNextEntry();
        while (this.firstEntry != null && this.firstEntry.getName().startsWith("META-INF/")) {
            if (this.firstEntry.getName().equals("META-INF/MANIFEST.MF")) {
                this.manifest = new Manifest(this);
            }
            this.firstEntry = (JarEntry)super.getNextEntry();
        }
        if (bl) {
            // empty if block
        }
    }

    protected ZipEntry createZipEntry(String string) {
        ZipEntry zipEntry = super.createZipEntry(string);
        JarEntry jarEntry = new JarEntry(zipEntry);
        if (this.manifest != null) {
            jarEntry.attr = this.manifest.getAttributes(string);
        }
        return jarEntry;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public ZipEntry getNextEntry() throws IOException {
        ZipEntry zipEntry;
        if (this.firstEntry != null) {
            zipEntry = this.firstEntry;
            this.firstEntry = null;
        } else {
            zipEntry = super.getNextEntry();
        }
        return zipEntry;
    }

    public JarEntry getNextJarEntry() throws IOException {
        return (JarEntry)this.getNextEntry();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }
}

