/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.Serializable;

public final class MathContext
implements Serializable {
    private static final long serialVersionUID = 5579720004786848255L;
    private int precision;

    public MathContext(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Precision cannot be less than zero.");
        }
        this.precision = n;
    }

    public MathContext(String string) {
        try {
            int n = string.indexOf("roundingMode", 10);
            this.precision = Integer.parseInt(string.substring(10, n - 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("String not in correct format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("String not in correct format");
        }
        if (this.precision < 0) {
            throw new IllegalArgumentException("Precision cannot be less than 0.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MathContext)) {
            return false;
        }
        MathContext mathContext = (MathContext)object;
        return mathContext.precision == this.precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String toString() {
        return "precision=" + this.precision;
    }

    public int hashCode() {
        return this.precision;
    }
}

