/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDocumentBuilder;
import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSParser;

public class DomDocumentBuilderFactory
extends DocumentBuilderFactory {
    final DOMImplementation impl;
    final DOMImplementationLS ls;
    private boolean secureProcessing;

    public DomDocumentBuilderFactory() {
        try {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            this.impl = dOMImplementationRegistry.getDOMImplementation("LS 3.0");
            if (this.impl == null) {
                throw new FactoryConfigurationError("no LS implementations found");
            }
            this.ls = (DOMImplementationLS)((Object)this.impl);
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError(exception);
        }
    }

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        LSParser lSParser = this.ls.createLSParser((short)2, "http://www.w3.org/TR/REC-xml");
        DOMConfiguration dOMConfiguration = lSParser.getDomConfig();
        this.setParameter(dOMConfiguration, "namespaces", this.isNamespaceAware() ? Boolean.TRUE : Boolean.FALSE);
        this.setParameter(dOMConfiguration, "element-content-whitespace", this.isIgnoringElementContentWhitespace() ? Boolean.FALSE : Boolean.TRUE);
        this.setParameter(dOMConfiguration, "comments", this.isIgnoringComments() ? Boolean.FALSE : Boolean.TRUE);
        this.setParameter(dOMConfiguration, "expand-entity-references", this.isExpandEntityReferences() ? Boolean.TRUE : Boolean.FALSE);
        this.setParameter(dOMConfiguration, "coalescing", this.isCoalescing() ? Boolean.TRUE : Boolean.FALSE);
        this.setParameter(dOMConfiguration, "validating", this.isValidating() ? Boolean.TRUE : Boolean.FALSE);
        this.setParameter(dOMConfiguration, "xinclude-aware", this.isXIncludeAware() ? Boolean.TRUE : Boolean.FALSE);
        return new DomDocumentBuilder(this.impl, this.ls, lSParser);
    }

    void setParameter(DOMConfiguration dOMConfiguration, String string, Object object) throws ParserConfigurationException {
        if (!dOMConfiguration.canSetParameter(string, object)) {
            throw new ParserConfigurationException(string);
        }
        dOMConfiguration.setParameter(string, object);
    }

    public Object getAttribute(String string) {
        return null;
    }

    public void setAttribute(String string, Object object) {
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (XMLConstants.FEATURE_SECURE_PROCESSING.equals(string)) {
            this.secureProcessing = true;
            return;
        }
        throw new ParserConfigurationException(string);
    }

    public boolean getFeature(String string) throws ParserConfigurationException {
        if (XMLConstants.FEATURE_SECURE_PROCESSING.equals(string)) {
            return this.secureProcessing;
        }
        throw new ParserConfigurationException(string);
    }
}

