/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;

public class PNGICCProfile
extends PNGChunk {
    private String name;
    private ICC_Profile profile;
    private static final byte[] genericName = new byte[]{73, 67, 67, 32, 80, 114, 111, 102, 105, 108, 101};

    protected PNGICCProfile(int n, byte[] byArray, int n2) throws PNGException {
        super(n, byArray, n2);
        int n3 = 0;
        while (byArray[n3++] != 0) {
        }
        try {
            this.name = new String(byArray, 0, n3, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.name = "";
        }
        if (byArray[n3++] != 0) {
            throw new PNGException("Can't handle nonzero compression types with iCCP chunks.");
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n3, byArray.length - n3);
            this.profile = ICC_Profile.getInstance(new InflaterInputStream(byteArrayInputStream));
        }
        catch (IOException iOException) {
            throw new PNGException("Couldn't read iCCP profile chunk.");
        }
        System.out.println("Got profile:" + this.profile);
    }

    public PNGICCProfile(ICC_Profile iCC_Profile) {
        super(1766015824);
        this.profile = iCC_Profile;
        byte[] byArray = iCC_Profile.getData();
        byte[] byArray2 = new byte[byArray.length * 2];
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        this.data = new byte[n + 11 + 2];
        System.arraycopy(genericName, 0, this.data, 0, 11);
        this.data[12] = 0;
        this.data[11] = 0;
        System.arraycopy(byArray2, 0, this.data, 13, n);
    }

    public ColorSpace getColorSpace() {
        return new ICC_ColorSpace(this.profile);
    }

    public String toString() {
        return "PNG ICC Profile, name: " + this.name;
    }
}

