#!/usr/bin/perl

# This script analyses two distributions from tab-separated input 
# and outputs some basic statistcs.
#
# It was used to analyse the distribution of the number of moves in
# the solutions generated by http://fc-solve.berlios.de/ .

use strict;
use warnings;

use Statistics::Descriptive;

my $num_fields = 2;

my @stats = 
    (map 
        { Statistics::Descriptive::Full->new(); } 
        (1 .. $num_fields)
    );

while(my $line = <ARGV>)
{
    chomp($line);
    my @vals = split(/\t/, $line);
    foreach my $f (0 .. $num_fields-1)
    {
        $stats[$f]->add_data($vals[$f]);
    }
}

foreach my $f (0 .. $num_fields-1)
{
    my $s = $stats[$f];
    print "Field No. $f\n";
    print "---------------------------\n";
    print "Min: " , $s->min(), "\n";
    print "Max: " , $s->max(), "\n";
    print "Average: " , $s->mean(), "\n";
    print "StdDev: " , $s->standard_deviation(), "\n";
    print "Median: " , $s->median(), "\n";
    print "\n";
}

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2009 Shlomi Fish

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

=cut

