/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TextAreaEditingTool;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.TextOverflowHandle;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;

public class SVGTextAreaFigure
extends SVGAttributedFigure
implements SVGFigure,
TextHolderFigure {
    private Rectangle2D.Double bounds = new Rectangle2D.Double();
    private boolean editable = true;
    private static final BasicStroke dashes = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private Boolean isTextOverflow;
    private transient Rectangle2D.Double cachedDrawingArea;
    private transient Shape cachedTextShape;

    public SVGTextAreaFigure() {
        this("Text");
    }

    public SVGTextAreaFigure(String string) {
        this.setText(string);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawText(Graphics2D graphics2D) {
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        graphics2D.fill(this.getTextShape());
        graphics2D.draw(new Rectangle2D.Double(this.getBounds().x, this.getBounds().y, this.getPreferredTextSize((double)((double)this.changingDepth)).width, this.getPreferredTextSize((double)((double)this.changingDepth)).height));
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        graphics2D.draw(this.getTextShape());
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D.Double double_ = this.getBounds();
            Rectangle2D.Double double_2 = double_ instanceof Rectangle2D.Double ? double_ : new Rectangle2D.Double(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY(), ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
            double d = SVGAttributeKeys.getPerpendicularHitGrowth(this);
            Geom.grow(double_2, d, d);
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.cachedDrawingArea = double_2;
            } else {
                this.cachedDrawingArea = new Rectangle2D.Double();
                this.cachedDrawingArea.setRect(((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(double_2).getBounds2D());
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        Rectangle2D rectangle2D;
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                double_ = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, new Point2D.Double());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        return (rectangle2D = this.getTextShape().getBounds2D()).isEmpty() ? this.getBounds().contains(double_) : rectangle2D.contains(double_);
    }

    private Shape getTextShape() {
        if (this.cachedTextShape == null) {
            GeneralPath generalPath = new GeneralPath();
            this.cachedTextShape = generalPath;
            if (this.getText() != null || this.isEditable()) {
                Font font = this.getFont();
                boolean bl = (Boolean)this.get(SVGAttributeKeys.FONT_UNDERLINE);
                Insets2D.Double double_ = this.getInsets();
                Rectangle2D.Double double_2 = new Rectangle2D.Double(this.bounds.x + double_.left, this.bounds.y + double_.top, this.bounds.width - double_.left - double_.right, this.bounds.height - double_.top - double_.bottom);
                float f = (float)double_2.x;
                float f2 = (float)Math.max((double)(f + 1.0f), double_2.x + double_2.width);
                float f3 = (float)double_2.y;
                float f4 = (float)(double_2.y + double_2.height);
                if (f < f2) {
                    float f5 = (float)((double)this.getTabSize() * font.getStringBounds("m", this.getFontRenderContext()).getWidth());
                    float[] fArray = new float[(int)(double_2.width / (double)f5)];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = (float)(double_2.x + (double)((int)(f5 * (float)(i + 1))));
                    }
                    if (this.getText() != null) {
                        String[] stringArray = this.getText().split("\n");
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].length() == 0) {
                                stringArray[i] = " ";
                            }
                            AttributedString attributedString = new AttributedString(stringArray[i]);
                            attributedString.addAttribute(TextAttribute.FONT, font);
                            if (bl) {
                                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                            }
                            int n = stringArray[i].split("\t").length - 1;
                            Rectangle2D.Double double_3 = this.appendParagraph(generalPath, attributedString.getIterator(), f3, f4, f, f2, fArray, n);
                            f3 = (float)(double_3.y + double_3.height);
                            if ((double)f3 > double_2.y + double_2.height) break;
                        }
                    }
                }
            }
        }
        return this.cachedTextShape;
    }

    private Rectangle2D.Double appendParagraph(GeneralPath generalPath, AttributedCharacterIterator attributedCharacterIterator, float f, float f2, float f3, float f4, float[] fArray, int n) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(f3, f, 0.0, 0.0);
        int[] nArray = new int[n + 1];
        int n2 = 0;
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            if (c == '\t') {
                nArray[n2++] = attributedCharacterIterator.getIndex();
            }
            c = attributedCharacterIterator.next();
        }
        nArray[n] = attributedCharacterIterator.getEndIndex() - 1;
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.getFontRenderContext());
        int n3 = 0;
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = f3;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            LinkedList<Float> linkedList2 = new LinkedList<Float>();
            while (!bl2) {
                float f8 = f4 - f7;
                object = null;
                object = lineBreakMeasurer.nextLayout(f8, nArray[n3] + 1, bl);
                if (object != null) {
                    linkedList.add(object);
                    linkedList2.add(Float.valueOf(f7));
                    f7 += ((TextLayout)object).getAdvance();
                    f5 = Math.max(f5, ((TextLayout)object).getAscent());
                    f6 = Math.max(f6, ((TextLayout)object).getDescent() + ((TextLayout)object).getLeading());
                } else {
                    bl2 = true;
                }
                bl = true;
                if (lineBreakMeasurer.getPosition() == nArray[n3] + 1) {
                    ++n3;
                }
                if (lineBreakMeasurer.getPosition() == attributedCharacterIterator.getEndIndex()) {
                    bl2 = true;
                } else if (fArray.length == 0 || f7 >= fArray[fArray.length - 1]) {
                    bl2 = true;
                }
                if (bl2) continue;
                int n4 = 0;
                while (f7 >= fArray[n4]) {
                    ++n4;
                }
                f7 = fArray[n4];
            }
            if ((f += f5) > f2) break;
            Iterator iterator = linkedList.iterator();
            object = linkedList2.iterator();
            while (iterator.hasNext()) {
                Shape shape;
                TextLayout textLayout = (TextLayout)iterator.next();
                float f9 = ((Float)object.next()).floatValue();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(f9, f);
                if (generalPath != null) {
                    shape = textLayout.getOutline(affineTransform);
                    generalPath.append(shape, false);
                }
                shape = textLayout.getBounds();
                double_.add(new Rectangle2D.Double(((RectangularShape)shape).getX() + (double)f9, ((RectangularShape)shape).getY() + (double)f, ((RectangularShape)shape).getWidth(), ((RectangularShape)shape).getHeight()));
            }
            f += f6;
        }
        return double_;
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.bounds.x = Math.min(double_.x, double_2.x);
        this.bounds.y = Math.min(double_.y, double_2.y);
        this.bounds.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.bounds.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
        this.invalidate();
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (affineTransform.getType() & 1) != affineTransform.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)affineTransform.clone());
            } else {
                AffineTransform affineTransform2 = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                affineTransform2.preConcatenate(affineTransform);
                this.set(SVGAttributeKeys.TRANSFORM, affineTransform2);
            }
        } else {
            Gradient gradient;
            Point2D.Double double_ = this.getStartPoint();
            Point2D.Double double_2 = this.getEndPoint();
            this.setBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                gradient = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.FILL_GRADIENT, gradient);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                gradient = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, gradient);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object object) {
        Object[] objectArray = (Object[])object;
        this.bounds = (Rectangle2D.Double)((Rectangle2D.Double)objectArray[0]).clone();
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)objectArray[1]);
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)objectArray[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)objectArray[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.bounds.clone(), SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public String getText() {
        return (String)this.get(SVGAttributeKeys.TEXT);
    }

    @Override
    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        if (attributeKey.equals(SVGAttributeKeys.TRANSFORM) || attributeKey.equals(SVGAttributeKeys.FONT_FACE) || attributeKey.equals(SVGAttributeKeys.FONT_BOLD) || attributeKey.equals(SVGAttributeKeys.FONT_ITALIC) || attributeKey.equals(SVGAttributeKeys.FONT_SIZE) || attributeKey.equals(SVGAttributeKeys.STROKE_WIDTH) || attributeKey.equals(SVGAttributeKeys.STROKE_COLOR) || attributeKey.equals(SVGAttributeKeys.STROKE_GRADIENT)) {
            this.invalidate();
        }
        super.set(attributeKey, t);
    }

    @Override
    public void setText(String string) {
        this.set(SVGAttributeKeys.TEXT, string);
    }

    @Override
    public Insets2D.Double getInsets() {
        double d = this.get(SVGAttributeKeys.STROKE_COLOR) == null ? 0.0 : Math.ceil((Double)this.get(SVGAttributeKeys.STROKE_WIDTH) / 2.0);
        Insets2D.Double double_ = new Insets2D.Double(0.0, 0.0, 0.0, 0.0);
        return new Insets2D.Double(double_.top + d, double_.left + d, double_.bottom + d, double_.right + d);
    }

    @Override
    public double getBaseline() {
        return (double)this.getFont().getLineMetrics(this.getText(), this.getFontRenderContext()).getAscent() + this.getInsets().top;
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Font getFont() {
        return SVGAttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return (Color)this.get(SVGAttributeKeys.FILL_COLOR);
    }

    @Override
    public Color getFillColor() {
        return ((Color)this.get(SVGAttributeKeys.FILL_COLOR)).equals(Color.white) ? Color.black : Color.WHITE;
    }

    @Override
    public void setFontSize(float f) {
        Point2D.Double double_ = new Point2D.Double(0.0, f);
        AffineTransform affineTransform = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (affineTransform != null) {
            try {
                affineTransform.inverseTransform(double_, double_);
                Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
                affineTransform.inverseTransform(double_2, double_2);
                double_.y -= double_2.y;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        this.set(SVGAttributeKeys.FONT_SIZE, Math.abs(double_.y));
    }

    @Override
    public float getFontSize() {
        Point2D.Double double_ = new Point2D.Double(0.0, (Double)this.get(SVGAttributeKeys.FONT_SIZE));
        AffineTransform affineTransform = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (affineTransform != null) {
            affineTransform.transform(double_, double_);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            affineTransform.transform(double_2, double_2);
            double_.y -= double_2.y;
        }
        return (float)Math.abs(double_.y);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case -1: {
                linkedList.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, linkedList);
                linkedList.add(new FontSizeHandle(this));
                linkedList.add(new TextOverflowHandle(this));
                linkedList.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
                break;
            }
        }
        return linkedList;
    }

    @Override
    public Tool getTool(Point2D.Double double_) {
        if (this.isEditable() && this.contains(double_)) {
            TextAreaEditingTool textAreaEditingTool = new TextAreaEditingTool(this);
            return textAreaEditingTool;
        }
        return null;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getText() == null || this.getText().length() == 0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedDrawingArea = null;
        this.cachedTextShape = null;
        this.isTextOverflow = null;
    }

    @Override
    public boolean isTextOverflow() {
        if (this.isTextOverflow == null) {
            Insets2D.Double double_ = this.getInsets();
            this.isTextOverflow = this.getPreferredTextSize((double)(this.getBounds().width - double_.left - double_.right)).height > this.getBounds().height - double_.top - double_.bottom;
        }
        return this.isTextOverflow;
    }

    public Dimension2DDouble getPreferredTextSize(double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.getText() != null) {
            Font font = this.getFont();
            boolean bl = (Boolean)this.get(SVGAttributeKeys.FONT_UNDERLINE);
            float f = 0.0f;
            float f2 = (float)d - 1.0f;
            float f3 = 0.0f;
            float f4 = Float.MAX_VALUE;
            if (f < f2) {
                float f5 = (float)((double)this.getTabSize() * font.getStringBounds("m", this.getFontRenderContext()).getWidth());
                float[] fArray = new float[(int)(double_.width / (double)f5)];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)(double_.x + (double)((int)(f5 * (float)(i + 1))));
                }
                if (this.getText() != null) {
                    String[] stringArray = this.getText().split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].length() == 0) {
                            stringArray[i] = " ";
                        }
                        AttributedString attributedString = new AttributedString(stringArray[i]);
                        attributedString.addAttribute(TextAttribute.FONT, font);
                        if (bl) {
                            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                        }
                        int n = stringArray[i].split("\t").length - 1;
                        Rectangle2D.Double double_2 = this.appendParagraph(null, attributedString.getIterator(), f3, f4, f, f2, fArray, n);
                        f3 = (float)(double_2.y + double_2.height);
                        double_.add(double_2);
                    }
                }
            }
        }
        return new Dimension2DDouble(Math.abs(double_.x) + double_.width, Math.abs(double_.y) + double_.height);
    }

    @Override
    public SVGTextAreaFigure clone() {
        SVGTextAreaFigure sVGTextAreaFigure = (SVGTextAreaFigure)super.clone();
        sVGTextAreaFigure.bounds = (Rectangle2D.Double)this.bounds.clone();
        return sVGTextAreaFigure;
    }
}

