/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    static EditorKit kit = new DefaultEditorKit();
    RootView rootView;
    JTextComponent textComponent;
    private PropertyChangeHandler updateHandler;
    DocumentHandler documentHandler;
    Color background;
    Color inactiveBackground;
    private FocusListener focuslistener;

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.textComponent = (JTextComponent)jComponent;
        Document document = this.textComponent.getDocument();
        if (document == null) {
            document = this.getEditorKit(this.textComponent).createDefaultDocument();
            this.textComponent.setDocument(document);
        }
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.modelChanged();
    }

    protected void installDefaults() {
        Highlighter highlighter;
        Caret caret = this.textComponent.getCaret();
        if (caret == null) {
            caret = this.createCaret();
            this.textComponent.setCaret(caret);
        }
        if ((highlighter = this.textComponent.getHighlighter()) == null) {
            this.textComponent.setHighlighter(this.createHighlighter());
        }
        String string = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.textComponent, string + ".background", string + ".foreground", string + ".font");
        LookAndFeel.installBorder(this.textComponent, string + ".border");
        this.textComponent.setMargin(UIManager.getInsets(string + ".margin"));
        caret.setBlinkRate(UIManager.getInt(string + ".caretBlinkRate"));
        this.background = UIManager.getColor(string + ".background");
        this.inactiveBackground = UIManager.getColor(string + ".inactiveBackground");
        this.textComponent.setDisabledTextColor(UIManager.getColor(string + ".inactiveForeground"));
        this.textComponent.setSelectedTextColor(UIManager.getColor(string + ".selectionForeground"));
        this.textComponent.setSelectionColor(UIManager.getColor(string + ".selectionBackground"));
    }

    protected void installListeners() {
        this.textComponent.addFocusListener(this.focuslistener);
        this.textComponent.addPropertyChangeListener(this.updateHandler);
        this.installDocumentListeners();
    }

    private final void installDocumentListeners() {
        Document document = this.textComponent.getDocument();
        if (document != null) {
            document.addDocumentListener(this.documentHandler);
        }
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    protected Keymap createKeymap() {
        Object object;
        JTextComponent.KeyBinding[] keyBindingArray = null;
        String string = this.getPropertyPrefix();
        InputMapUIResource inputMapUIResource = (InputMapUIResource)UIManager.get(string + ".focusInputMap");
        if (inputMapUIResource != null) {
            object = inputMapUIResource.keys();
            int n = ((KeyStroke[])object).length;
            keyBindingArray = new JTextComponent.KeyBinding[n];
            int n2 = 0;
            while (n2 < n) {
                KeyStroke keyStroke = object[n2];
                keyBindingArray[n2] = new JTextComponent.KeyBinding(keyStroke, (String)inputMapUIResource.get(keyStroke));
                ++n2;
            }
        }
        if (keyBindingArray == null) {
            keyBindingArray = new JTextComponent.KeyBinding[]{};
        }
        object = JTextComponent.addKeymap(this.getKeymapName(), JTextComponent.getKeymap("default"));
        JTextComponent.loadKeymap((Keymap)object, keyBindingArray, this.textComponent.getActions());
        return object;
    }

    protected void installKeyboardActions() {
        Keymap keymap = JTextComponent.getKeymap(this.getKeymapName());
        if (keymap == null) {
            keymap = this.createKeymap();
        }
        this.textComponent.setKeymap(keymap);
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, this.getInputMap(0));
        SwingUtilities.replaceUIActionMap(this.textComponent, this.createActionMap());
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        Action[] actionArray = this.textComponent.getActions();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            actionMapUIResource.put(action.getValue("Name"), action);
            ++n;
        }
        SwingUtilities.replaceUIActionMap(this.textComponent, actionMapUIResource);
    }

    ActionMap createActionMap() {
        Action[] actionArray = this.textComponent.getActions();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        int n = 0;
        while (n < actionArray.length) {
            String string = (String)actionArray[n].getValue("Name");
            if (string != null) {
                actionMapUIResource.put(string, actionArray[n]);
            }
            ++n;
        }
        return actionMapUIResource;
    }

    InputMap getInputMap(int n) {
        String string = this.getPropertyPrefix();
        switch (n) {
            case 2: {
                return (InputMap)UIManager.get(string + ".windowInputMap");
            }
            case 1: {
                return (InputMap)UIManager.get(string + ".ancestorInputMap");
            }
        }
        return (InputMap)UIManager.get(string + ".focusInputMap");
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.rootView.setView(null);
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.textComponent = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.textComponent.removePropertyChangeListener(this.updateHandler);
        this.textComponent.removeFocusListener(this.focuslistener);
        this.textComponent.getDocument().removeDocumentListener(this.documentHandler);
    }

    protected void uninstallKeyboardActions() {
    }

    protected abstract String getPropertyPrefix();

    public Dimension getPreferredSize(JComponent jComponent) {
        View view = this.getRootView(this.textComponent);
        float f = view.getPreferredSpan(0);
        float f2 = view.getPreferredSpan(1);
        Insets insets = jComponent.getInsets();
        return new Dimension((int)f + insets.left + insets.right, (int)f2 + insets.top + insets.bottom);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void paint(Graphics graphics, JComponent jComponent) {
        Document document;
        try {
            Document document2 = this.textComponent.getDocument();
            if (document2 instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document2;
                abstractDocument.readLock();
            }
            this.paintSafely(graphics);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Document document3 = this.textComponent.getDocument();
            if (!(document3 instanceof AbstractDocument)) throw throwable;
            AbstractDocument abstractDocument = (AbstractDocument)document3;
            abstractDocument.readUnlock();
            throw throwable;
        }
        {
            Object var4_7 = null;
            document = this.textComponent.getDocument();
        }
        if (!(document instanceof AbstractDocument)) return;
        AbstractDocument abstractDocument = (AbstractDocument)document;
        abstractDocument.readUnlock();
    }

    protected void paintSafely(Graphics graphics) {
        Caret caret = this.textComponent.getCaret();
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (this.textComponent.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            Color color = graphics.getColor();
            highlighter.paint(graphics);
            graphics.setColor(color);
        }
        this.rootView.paint(graphics, this.getVisibleEditorRect());
        if (caret != null && this.textComponent.hasFocus()) {
            caret.paint(graphics);
        }
    }

    protected void paintBackground(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.textComponent.getBackground());
        graphics.fillRect(0, 0, this.textComponent.getWidth(), this.textComponent.getHeight());
        graphics.setColor(color);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, null, null);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        try {
            n = Math.min(n, jTextComponent.getDocument().getLength());
            n2 = Math.min(n2, jTextComponent.getDocument().getLength());
            Rectangle rectangle = this.modelToView(jTextComponent, n, bias);
            Rectangle rectangle2 = this.modelToView(jTextComponent, n2, bias2);
            if (rectangle.y == rectangle2.y) {
                jTextComponent.repaint(rectangle.union(rectangle2));
            } else {
                Insets insets = jTextComponent.getInsets();
                rectangle.width = insets.right + jTextComponent.getWidth() - rectangle.x;
                jTextComponent.repaint(rectangle);
                int n3 = Utilities.getPositionBelow(jTextComponent, n, rectangle.x);
                int n4 = Utilities.getRowStart(jTextComponent, n2);
                if (n3 != -1 && n3 != n && Utilities.getRowStart(jTextComponent, n3) != n4) {
                    Rectangle rectangle3 = this.modelToView(jTextComponent, n3);
                    rectangle3.x = insets.left;
                    rectangle3.width = jTextComponent.getWidth() + insets.right;
                    int n5 = n3;
                    while (n5 != -1 && n3 != n5 && Utilities.getRowStart(jTextComponent, n5) != n4) {
                        n3 = n5;
                        if (n3 == (n5 = Utilities.getPositionBelow(jTextComponent, n3, rectangle.x))) break;
                    }
                    Rectangle rectangle4 = this.modelToView(jTextComponent, n3);
                    rectangle3.height = rectangle4.y + rectangle4.height - rectangle3.y;
                    jTextComponent.repaint(rectangle3);
                }
                rectangle2.width += rectangle2.x;
                rectangle2.x = insets.left;
                jTextComponent.repaint(rectangle2);
            }
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return kit;
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return 0;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        return this.rootView.modelToView(n, this.getVisibleEditorRect(), bias).getBounds();
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, null);
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        return this.rootView.viewToModel(point.x, point.y, this.getVisibleEditorRect(), biasArray);
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        int n = this.textComponent.getWidth();
        int n2 = this.textComponent.getHeight();
        if (n <= 0 || n2 <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Insets insets = this.textComponent.getInsets();
        return new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        this.textComponent.revalidate();
        this.textComponent.repaint();
    }

    protected void modelChanged() {
        if (this.textComponent == null || this.rootView == null) {
            return;
        }
        ViewFactory viewFactory = this.rootView.getViewFactory();
        if (viewFactory == null) {
            return;
        }
        Document document = this.textComponent.getDocument();
        if (document == null) {
            return;
        }
        this.installDocumentListeners();
        Element element = document.getDefaultRootElement();
        if (element == null) {
            return;
        }
        View view = viewFactory.create(element);
        this.setView(view);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private final /* synthetic */ void this() {
        this.rootView = new RootView();
        this.updateHandler = new PropertyChangeHandler();
        this.documentHandler = new DocumentHandler();
        this.focuslistener = new FocusListener(){

            public final void focusGained(FocusEvent focusEvent) {
                BasicTextUI.this.textComponent.repaint();
            }

            public final void focusLost(FocusEvent focusEvent) {
                BasicTextUI.this.textComponent.repaint();
            }
        };
    }

    public BasicTextUI() {
        this.this();
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RootView
    extends View {
        private View view;

        public ViewFactory getViewFactory() {
            ViewFactory viewFactory = null;
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.getComponent());
            viewFactory = editorKit.getViewFactory();
            if (viewFactory == null) {
                viewFactory = BasicTextUI.this;
            }
            return viewFactory;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            BasicTextUI.this.textComponent.revalidate();
        }

        public void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (view != null) {
                view.setParent(this);
            }
            this.view = view;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            int n = 0;
            if (this.view != null) {
                n = 1;
            }
            return n;
        }

        public Container getContainer() {
            return BasicTextUI.this.textComponent;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 2.1474836E9f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.insertUpdate(documentEvent, shape, viewFactory);
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.removeUpdate(documentEvent, shape, viewFactory);
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.changedUpdate(documentEvent, shape, viewFactory);
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            return this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.getDocument().getLength();
        }

        public Document getDocument() {
            return BasicTextUI.this.textComponent.getDocument();
        }

        public RootView() {
            super(null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(propertyChangeEvent);
        }

        private PropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DocumentHandler
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            BasicTextUI.this.rootView.changedUpdate(documentEvent, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BasicTextUI.this.rootView.insertUpdate(documentEvent, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BasicTextUI.this.rootView.removeUpdate(documentEvent, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        DocumentHandler() {
        }
    }
}

