/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ComponentInputMap
extends InputMap {
    private JComponent component;

    public void put(KeyStroke keyStroke, Object object) {
        super.put(keyStroke, object);
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public void clear() {
        super.clear();
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public void remove(KeyStroke keyStroke) {
        super.remove(keyStroke);
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public void setParent(InputMap inputMap) {
        if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
            throw new IllegalArgumentException("ComponentInputMaps can only have ComponentInputMaps for parents");
        }
        if (inputMap != null && ((ComponentInputMap)inputMap).getComponent() != this.component) {
            throw new IllegalArgumentException("ComponentInputMaps' parents must be associated with the same JComponents");
        }
        super.setParent(inputMap);
        if (this.component != null) {
            this.component.updateComponentInputMap(this);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public ComponentInputMap(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException();
        }
        this.component = jComponent;
    }
}

