/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;

public class ICC_ProfileRGB
extends ICC_Profile {
    private static final long serialVersionUID = 8505067385152579334L;
    public static final int REDCOMPONENT = 0;
    public static final int GREENCOMPONENT = 1;
    public static final int BLUECOMPONENT = 2;
    private transient float[][] matrix = this.createMatrix();
    private transient float[] gamma;
    private transient float[] whitePoint = this.getXYZData(0x77747074);

    public float[] getMediaWhitePoint() {
        float[] fArray = new float[]{this.whitePoint[0], this.whitePoint[1], this.whitePoint[2]};
        return fArray;
    }

    public float[][] getMatrix() {
        float[][] fArray = new float[3][3];
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                fArray[n][n2] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return fArray;
    }

    public float getGamma(int n) {
        short[] sArray;
        switch (n) {
            case 0: {
                sArray = this.getCurve(1918128707);
                break;
            }
            case 1: {
                sArray = this.getCurve(1733579331);
                break;
            }
            case 2: {
                sArray = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (sArray == null) {
            throw new IllegalArgumentException("Error reading TRC");
        }
        if (sArray.length != 1) {
            throw new ProfileDataException("Not a single-gamma TRC");
        }
        float f = (sArray[0] & 0xFF00) >> 8;
        double d = (double)(sArray[0] & 0xFF) / 256.0;
        return f += (float)d;
    }

    public short[] getTRC(int n) {
        short[] sArray;
        switch (n) {
            case 0: {
                sArray = this.getCurve(1918128707);
                break;
            }
            case 1: {
                sArray = this.getCurve(1733579331);
                break;
            }
            case 2: {
                sArray = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (sArray == null) {
            throw new IllegalArgumentException("Error reading TRC");
        }
        if (sArray.length <= 1) {
            throw new ProfileDataException("Gamma value, not a TRC table.");
        }
        return sArray;
    }

    private final float[][] createMatrix() throws IllegalArgumentException {
        float[][] fArray = new float[3][3];
        float[] fArray2 = this.getXYZData(1918392666);
        float[] fArray3 = this.getXYZData(1733843290);
        float[] fArray4 = this.getXYZData(1649957210);
        if (fArray2 == null || fArray3 == null || fArray4 == null) {
            throw new IllegalArgumentException("Error reading colorant tags!");
        }
        int n = 0;
        while (n < 3) {
            fArray[n][0] = fArray2[n];
            fArray[n][1] = fArray3[n];
            fArray[n][2] = fArray4[n];
            ++n;
        }
        return fArray;
    }

    ICC_ProfileRGB(int n) {
        super(n);
    }

    ICC_ProfileRGB(byte[] byArray) {
        super(byArray);
    }
}

