/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public final class DomIterator
implements NodeIterator,
EventListener {
    private Node reference;
    private boolean right;
    private boolean done;
    private final Node root;
    private final int whatToShow;
    private final NodeFilter filter;
    private final boolean expandEntityReferences;

    public final void detach() {
        EventTarget eventTarget = (EventTarget)((Object)this.root);
        eventTarget.removeEventListener("DOMNodeRemoved", this, false);
        this.done = true;
    }

    public final boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public final NodeFilter getFilter() {
        return this.filter;
    }

    public final Node getRoot() {
        return this.root;
    }

    public final int getWhatToShow() {
        return this.whatToShow;
    }

    public final Node nextNode() {
        if (this.done) {
            throw new DomDOMException(11);
        }
        this.right = true;
        return this.walk(true);
    }

    public final Node previousNode() {
        if (this.done) {
            throw new DomDOMException(11);
        }
        Node node2 = this.reference;
        this.right = false;
        this.walk(false);
        return node2;
    }

    private final boolean shouldShow(Node node2) {
        if ((this.whatToShow & 1 << node2.getNodeType() - 1) == 0) {
            return false;
        }
        if (this.filter == null) {
            return true;
        }
        boolean bl = false;
        if (this.filter.acceptNode(node2) == 1) {
            bl = true;
        }
        return bl;
    }

    private final Node walk(boolean bl) {
        Node node2 = this.reference;
        while ((node2 = this.successor(node2, bl)) != null && !this.shouldShow(node2)) {
        }
        if (node2 != null || !bl) {
            this.reference = node2;
        }
        return node2;
    }

    private final boolean isLeaf(Node node2) {
        boolean bl = node2.hasChildNodes() ^ true;
        if (!bl && !this.expandEntityReferences) {
            boolean bl2 = false;
            if (node2.getNodeType() == 5) {
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    private final Node successor(Node node2, boolean bl) {
        Node node3;
        if (node2 == null) {
            return bl ? this.root : null;
        }
        if (bl && !this.isLeaf(node2)) {
            return node2.getFirstChild();
        }
        if (bl) {
            node3 = node2.getNextSibling();
            if (node3 != null) {
                return node3;
            }
        } else {
            node3 = node2.getPreviousSibling();
            if (node3 != null) {
                if (this.isLeaf(node3)) {
                    return node3;
                }
                node3 = node3.getLastChild();
                while (!this.isLeaf(node3)) {
                    node3 = node3.getLastChild();
                }
                return node3;
            }
        }
        node3 = node2.getParentNode();
        if (!bl) {
            return node3;
        }
        Node node4 = null;
        while (node3 != null && node3 != this.root && (node4 = node3.getNextSibling()) == null) {
            node3 = node3.getParentNode();
        }
        if (node3 == this.root) {
            return null;
        }
        return node4;
    }

    /*
     * Unable to fully structure code
     */
    public final void handleEvent(Event var1_1) {
        if (this.reference == null || !"DOMNodeRemoved".equals(var1_1.getType()) || var1_1.getEventPhase() != 3) {
            return;
        }
        var2_2 = (MutationEvent)var1_1;
        var4_3 = (Node)var2_2.getTarget();
        var3_4 = this.reference;
        while (var3_4 != null && var3_4 != this.root) {
            if (var3_4 == var4_3) break;
            var3_4 = var3_4.getParentNode();
        }
        if (var3_4 == var4_3) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            var3_4 = var5_5;
            while (var3_4 != null && var3_4 != this.root) {
                if (var3_4 == var4_3) continue block1;
                var3_4 = var3_4.getParentNode();
            }
            return;
lbl18:
            // 2 sources

            ** while ((var5_5 = this.walk((boolean)(this.right ^ true))) != null)
        }
lbl19:
        // 1 sources

    }

    protected DomIterator(Node node2, int n, NodeFilter nodeFilter, boolean bl) {
        if (!node2.isSupported("MutationEvents", "2.0")) {
            throw new DomDOMException(9, "Iterator needs mutation events", node2, 0);
        }
        this.root = node2;
        this.whatToShow = n;
        this.filter = nodeFilter;
        this.expandEntityReferences = bl;
        this.reference = null;
        this.right = true;
        EventTarget eventTarget = (EventTarget)((Object)node2);
        eventTarget.addEventListener("DOMNodeRemoved", this, false);
    }
}

