/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.DatagramChannelImpl;
import gnu.java.nio.DatagramChannelSelectionKey;
import gnu.java.nio.SelectionKeyImpl;
import gnu.java.nio.ServerSocketChannelImpl;
import gnu.java.nio.ServerSocketChannelSelectionKey;
import gnu.java.nio.SocketChannelImpl;
import gnu.java.nio.SocketChannelSelectionKey;
import gnu.java.nio.SocketChannelSelectionKeyImpl;
import gnu.java.nio.VMSelector;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SelectorImpl
extends AbstractSelector {
    private Set keys;
    private Set selected;
    private Object selectThreadMutex;
    private Thread selectThread;
    private boolean unhandledWakeup;

    private /* synthetic */ void finit$() {
        this.selectThreadMutex = new Object();
    }

    public SelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.finit$();
        this.keys = new HashSet();
        this.selected = new HashSet();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected final void implCloseSelector() throws IOException {
        this.wakeup();
        Set set = this.keys;
        // MONITORENTER : set
        try {
            Set set2;
            Set set3 = this.selected;
            // MONITORENTER : set3
            try {
                set2 = this.cancelledKeys();
                // MONITORENTER : set2
                // MONITOREXIT : set2
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                // MONITOREXIT : set3
                throw throwable;
            }
            set2 = null;
            // MONITOREXIT : set3
            set2 = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            // MONITOREXIT : set
            throw throwable;
        }
    }

    public final Set keys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return Collections.unmodifiableSet(this.keys);
    }

    public final int selectNow() throws IOException {
        return this.select(1L);
    }

    public final int select() throws IOException {
        return this.select(0L);
    }

    private final int[] getFDsAsArray(int n) {
        SelectionKeyImpl selectionKeyImpl;
        int n2 = 0;
        Iterator iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            selectionKeyImpl = (SelectionKeyImpl)iterator.next();
            if ((selectionKeyImpl.interestOps() & n) == 0) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            selectionKeyImpl = (SelectionKeyImpl)iterator.next();
            if ((selectionKeyImpl.interestOps() & n) == 0) continue;
            nArray[n2] = selectionKeyImpl.getNativeFD();
            ++n2;
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int select(long l) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        Set set = this.keys;
        synchronized (set) {
            try {
                Set set2 = this.selected;
                synchronized (set2) {
                    try {
                        Object object;
                        this.deregisterCancelledKeys();
                        int[] nArray = this.getFDsAsArray(17);
                        int[] nArray2 = this.getFDsAsArray(12);
                        int[] nArray3 = new int[]{};
                        Object object2 = this.selectThreadMutex;
                        synchronized (object2) {
                            try {
                                if (this.unhandledWakeup) {
                                    this.unhandledWakeup = false;
                                    return 0;
                                }
                                this.selectThread = Thread.currentThread();
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                throw throwable;
                            }
                            Object var10_11 = null;
                        }
                        int n = 0;
                        try {
                            this.begin();
                            n = VMSelector.select(nArray, nArray2, nArray3, l);
                        }
                        finally {
                            object = null;
                            this.end();
                        }
                        object = this.selectThreadMutex;
                        synchronized (object) {
                            Iterator iterator;
                            try {
                                if (this.unhandledWakeup) {
                                    this.unhandledWakeup = false;
                                    Thread.interrupted();
                                }
                                this.selectThread = null;
                            }
                            finally {
                                iterator = null;
                            }
                            iterator = this.keys.iterator();
                            while (iterator.hasNext()) {
                                int n2;
                                int n3 = 0;
                                SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                                if (this.selected.contains(selectionKeyImpl)) {
                                    n3 = selectionKeyImpl.readyOps();
                                }
                                for (n2 = 0; n2 < nArray.length; ++n2) {
                                    if (selectionKeyImpl.getNativeFD() != nArray[n2]) continue;
                                    if (selectionKeyImpl.channel() instanceof ServerSocketChannelImpl) {
                                        n3 |= 0x10;
                                        continue;
                                    }
                                    n3 |= 1;
                                }
                                for (n2 = 0; n2 < nArray2.length; ++n2) {
                                    if (selectionKeyImpl.getNativeFD() != nArray2[n2]) continue;
                                    if (selectionKeyImpl.channel() instanceof SocketChannel) {
                                        if (((SocketChannel)selectionKeyImpl.channel()).isConnected()) {
                                            n3 |= 4;
                                            continue;
                                        }
                                        n3 |= 8;
                                        continue;
                                    }
                                    n3 |= 4;
                                }
                                if (!this.selected.contains(selectionKeyImpl)) {
                                    this.selected.add(selectionKeyImpl);
                                }
                                selectionKeyImpl.readyOps(selectionKeyImpl.interestOps() & n3);
                            }
                            this.deregisterCancelledKeys();
                            return n;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_18 = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                throw throwable;
            }
        }
    }

    public final Set selectedKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.selected;
    }

    public final Selector wakeup() {
        SelectorImpl selectorImpl;
        Object object = this.selectThreadMutex;
        synchronized (object) {
            block3: {
                try {
                    this.unhandledWakeup = true;
                    if (this.selectThread == null) break block3;
                    this.selectThread.interrupt();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            selectorImpl = null;
        }
        selectorImpl = this;
        return selectorImpl;
    }

    private final void deregisterCancelledKeys() {
        Set set;
        Set set2 = set = this.cancelledKeys();
        synchronized (set2) {
            try {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.keys.remove((SelectionKeyImpl)iterator.next());
                    iterator.remove();
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    protected SelectionKey register(SelectableChannel selectableChannel, int n, Object object) {
        return this.register((AbstractSelectableChannel)selectableChannel, n, object);
    }

    protected final SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        SelectionKeyImpl selectionKeyImpl;
        if (abstractSelectableChannel instanceof SocketChannelImpl) {
            selectionKeyImpl = new SocketChannelSelectionKey(abstractSelectableChannel, this);
        } else if (abstractSelectableChannel instanceof DatagramChannelImpl) {
            selectionKeyImpl = new DatagramChannelSelectionKey(abstractSelectableChannel, this);
        } else if (abstractSelectableChannel instanceof ServerSocketChannelImpl) {
            selectionKeyImpl = new ServerSocketChannelSelectionKey(abstractSelectableChannel, this);
        } else if (abstractSelectableChannel instanceof SocketChannelImpl) {
            selectionKeyImpl = new SocketChannelSelectionKeyImpl((SocketChannelImpl)abstractSelectableChannel, this);
        } else {
            throw new InternalError("No known channel type");
        }
        Set set = this.keys;
        synchronized (set) {
            SelectionKeyImpl selectionKeyImpl2;
            try {
                this.keys.add(selectionKeyImpl);
                selectionKeyImpl.interestOps(n);
                selectionKeyImpl.attach(object);
            }
            finally {
                selectionKeyImpl2 = null;
            }
            selectionKeyImpl2 = selectionKeyImpl;
            return selectionKeyImpl2;
        }
    }
}

