/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;

public final class ChannelInputStream
extends InputStream {
    private ReadableByteChannel ch;

    public ChannelInputStream(ReadableByteChannel readableByteChannel) {
        this.ch = readableByteChannel;
    }

    public int read() throws IOException {
        if (this.ch instanceof SelectableChannel && !((SelectableChannel)((Object)this.ch)).isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        int n = this.ch.read(byteBuffer);
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            throw new IOException("Could not read from channel");
        }
        return byteBuffer.get(0);
    }
}

