/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringBufferInputStream;
import java.net.URLEncoder;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Applet
extends JApplet
implements ActionListener,
EventStreamReader.EventStreamReaderI {
    protected JTextField textField;
    protected JTextArea textArea;
    protected JComboBox channelBox;
    protected JScrollPane scrollPane;
    protected EventStreamReader streamReader;
    protected StringBuffer data = new StringBuffer();
    protected DocumentBuilder builder;

    public void init() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = documentBuilderFactory.newDocumentBuilder();
            System.err.println("CreateDOC" + documentBuilderFactory.getClass().getName());
        }
        catch (Exception exception) {
            System.err.println("CreateDOC" + exception.getMessage());
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Applet.this.createGUI();
                    Applet.this.startSteam();
                }
            });
        }
        catch (Exception exception) {
            System.err.println("CreateGUI" + exception.getMessage());
        }
    }

    public void destroy() {
        if (this.streamReader != null) {
            this.streamReader.close();
        }
    }

    private void createGUI() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.textField = new JTextField(30);
        this.textField.addActionListener(this);
        this.textArea = new JTextArea(5, 30);
        this.textArea.setEditable(false);
        this.channelBox = new JComboBox();
        this.scrollPane = new JScrollPane(this.textArea, 22, 31);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.textField, "Center");
        panel.add((Component)this.channelBox, "After");
        container.add((Component)this.scrollPane, "Center");
        container.add((Component)panel, "Last");
    }

    private void startSteam() {
        String string = this.getParameter("sid");
        if (string == null) {
            return;
        }
        String string2 = this.getDocumentBase().getHost();
        int n = this.getDocumentBase().getPort();
        String string3 = "/appletstream?sid=" + string;
        this.streamReader = new EventStreamReader(this, string2, n, string3);
        this.streamReader.start();
    }

    public void handleData(String string) {
        int n;
        this.data.append(string);
        while ((n = this.data.indexOf("\n")) != -1) {
            String string2 = this.data.substring(0, n);
            this.handleXML(string2);
            this.data.delete(0, n + 1);
        }
    }

    private String getXMLString(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            stringBuffer.append(node2.getNodeValue());
            ++n;
        }
        return stringBuffer.toString();
    }

    private void handleXML(String string) {
        try {
            Document document = this.builder.parse(new StringBufferInputStream(string));
            NodeList nodeList = document.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeName().equals("chat")) {
                    this.addText(this.getXMLString(node) + "\n");
                } else if (node.getNodeName().equals("addchannel")) {
                    this.addChannel(this.getXMLString(node));
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    private void addText(String string) {
        final String string2 = string;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JScrollBar jScrollBar = Applet.this.scrollPane.getVerticalScrollBar();
                    boolean bl = jScrollBar.getMaximum() == jScrollBar.getValue();
                    Applet.this.textArea.append(string2);
                    if (bl) {
                        jScrollBar.setValue(jScrollBar.getMaximum());
                    }
                }
            });
        }
        catch (Exception exception) {
            System.err.println("addText" + exception.getMessage());
        }
    }

    private void addChannel(String string) {
        final String string2 = string;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Applet.this.channelBox.addItem(string2);
                    Applet.this.channelBox.setSelectedItem("general");
                }
            });
        }
        catch (Exception exception) {
            System.err.println("addText" + exception.getMessage());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.textField.getText();
        this.textField.setText("");
        String string2 = this.getParameter("sid");
        if (string2 == null) {
            return;
        }
        String string3 = this.getDocumentBase().getHost();
        int n = this.getDocumentBase().getPort();
        String string4 = this.channelBox.getSelectedItem().toString();
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string5 = "/action?sid=" + string2 + "&action=chat&text=" + string + "&channel=" + string4;
        new EventStreamReader(this, string3, n, string5).start();
    }
}

