/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.jython;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.python.pydev.jython.JythonPlugin;
import org.python.pydev.jython.ui.JyScriptingPreferencesPage;

public class ScriptOutput
extends OutputStream {
    private boolean writeToConsole;
    private IOConsoleOutputStream out;
    private Color color;
    private IOConsole fConsole;

    public ScriptOutput(Color color, IOConsole console, boolean writeToConsole) {
        this.color = color;
        this.fConsole = console;
        this.writeToConsole = writeToConsole;
    }

    public ScriptOutput(Color color, MessageConsole console) {
        this(color, (IOConsole)console, JyScriptingPreferencesPage.getShowScriptingOutput());
        Preferences.IPropertyChangeListener listener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                ScriptOutput.this.writeToConsole = JyScriptingPreferencesPage.getShowScriptingOutput();
            }
        };
        JythonPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(listener);
    }

    public void write(int b) throws IOException {
        if (this.writeToConsole) {
            IOConsoleOutputStream out = this.getOutputStream();
            out.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOConsoleOutputStream getOutputStream() throws MalformedURLException {
        if (this.out == null) {
            this.out = this.fConsole.newOutputStream();
            Display display = Display.getDefault();
            synchronized (display) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ScriptOutput.this.out.setColor(ScriptOutput.this.color);
                    }
                });
            }
        }
        return this.out;
    }
}

