/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.awt.Color;
import java.util.regex.Pattern;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class GlobalOutputProcessor
implements OutputProcessor {
    private static final String SECTION_PROJECT = "project-execute";
    static final Pattern DOWNLOAD = Pattern.compile("^((\\d+)/(\\d*)[MKb\\?](\\s*))+$");
    private static final Pattern LOW_MVN = Pattern.compile("(.*)Error resolving version for (.*): Plugin requires Maven version (.*)");

    @Override
    public String[] getRegisteredOutputSequences() {
        return new String[]{SECTION_PROJECT};
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        if (DOWNLOAD.matcher(line).matches()) {
            visitor.skipLine();
            return;
        }
        if ("BUILD SUCCESSFUL".equals(line)) {
            visitor.setColor(Color.GREEN.darker().darker());
            return;
        }
        if (LOW_MVN.matcher(line).matches()) {
            visitor.setLine(line + NbBundle.getMessage(GlobalOutputProcessor.class, (String)"TXT_ChangeSettings"));
            visitor.setColor(Color.RED);
            visitor.setOutputListener(new OutputListener(){

                public void outputLineSelected(OutputEvent ev) {
                }

                public void outputLineAction(OutputEvent ev) {
                    OptionsDisplayer.getDefault().open("Advanced/Maven");
                }

                public void outputLineCleared(OutputEvent ev) {
                }
            });
            return;
        }
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        if (!sequenceId.startsWith(SECTION_PROJECT)) {
            visitor.setLine("[" + sequenceId.substring("mojo-execute#".length()) + "]");
            visitor.setColor(Color.GRAY);
        }
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }
}

