/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.FileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.CVS;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsLiteAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteFileHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteGzippedFileHandler;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVisibilityQuery;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.netbeans.modules.versioning.system.cvss.FilesystemHandler;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.CvsSynchronizeTopComponent;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class CvsVersioningSystem {
    private static CvsVersioningSystem instance;
    public static final String FILENAME_CVSIGNORE = ".cvsignore";
    public static final String FILENAME_CVS = "CVS";
    public static final Object EVENT_PARAM_CHANGED;
    public static final Object PARAM_BATCH_REFRESH_RUNNING;
    public static final Object EVENT_VERSIONED_FILES_CHANGED;
    public static final Object EVENT_REFRESH_ANNOTATIONS;
    public static final String FILENAME_CVS_REPOSITORY = "CVS/Repository";
    public static final String FILENAME_CVS_ENTRIES = "CVS/Entries";
    private static final Set textExtensions;
    public static Logger LOG;
    private final Map<String, ClientRuntime> clientsCache = new HashMap<String, ClientRuntime>();
    private final Map params = new HashMap();
    private GlobalOptions defaultGlobalOptions;
    private FileStatusCache fileStatusCache;
    private CvsLiteAdminHandler sah;
    private CvsLiteFileHandler workdirFileHandler;
    private CvsLiteGzippedFileHandler workdirGzippedFileHandler;
    private FilesystemHandler filesystemHandler;
    private VCSAnnotator fileStatusProvider;
    private Annotator annotator;
    private final Set<Pattern> userIgnorePatterns = new HashSet<Pattern>();
    private boolean userIgnorePatternsReset;
    private long userIgnorePatternsTimestamp;
    private final Set<File> unignoreOverride = new HashSet<File>(1);
    private final Set<File> alreadyGeneratedFiles = new HashSet<File>(5);
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private RequestProcessor parallelRP;
    private RequestProcessor serialRP;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private static final int STATUS_DIFFABLE = 1272;

    public static synchronized CvsVersioningSystem getInstance() {
        if (instance == null) {
            instance = new CvsVersioningSystem();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.defaultGlobalOptions = CvsVersioningSystem.createGlobalOptions();
        this.sah = new CvsLiteAdminHandler();
        this.workdirFileHandler = new CvsLiteFileHandler();
        FileUtils.setFileReadOnlyHandler((FileReadOnlyHandler)this.workdirFileHandler);
        this.workdirGzippedFileHandler = new CvsLiteGzippedFileHandler();
        this.fileStatusCache = new FileStatusCache(this);
        this.filesystemHandler = new FilesystemHandler(this);
        this.annotator = new Annotator(this);
        this.fileStatusProvider = new FileStatusProvider();
    }

    void shutdown() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CvsSynchronizeTopComponent.getInstance().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private CvsVersioningSystem() {
    }

    public CvsFileTableModel getFileTableModel(Context context, int displayStatuses) {
        return new CvsFileTableModel(context, displayStatuses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRuntime getClientRuntime(String cvsRoot) {
        ClientRuntime clientRuntime;
        cvsRoot.length();
        Map<String, ClientRuntime> map = this.clientsCache;
        synchronized (map) {
            clientRuntime = this.clientsCache.get(cvsRoot);
            if (clientRuntime == null) {
                clientRuntime = new ClientRuntime(cvsRoot);
                this.clientsCache.put(cvsRoot, clientRuntime);
            }
        }
        return clientRuntime;
    }

    String detectCvsRoot(Command cmd) throws NotVersionedException {
        File[] files;
        AddCommand c;
        if (cmd instanceof AddCommand) {
            c = (AddCommand)cmd;
            files = c.getFiles();
        } else if (cmd instanceof BasicCommand) {
            c = (BasicCommand)cmd;
            files = c.getFiles();
        } else {
            throw new NotVersionedException("Cannot determine CVSRoot for command: " + cmd);
        }
        File oneFile = files[0];
        try {
            return Utils.getCVSRootFor(oneFile);
        }
        catch (IOException e) {
            throw new NotVersionedException("Cannot determine CVSRoot for: " + oneFile);
        }
    }

    public RequestProcessor.Task post(Command cmd, ExecutorSupport mgr) throws CommandException, AuthenticationException, NotVersionedException, IllegalCommandException, IOException {
        return this.post(cmd, this.defaultGlobalOptions, mgr);
    }

    public RequestProcessor.Task post(Command cmd, GlobalOptions options, ExecutorSupport mgr) throws IllegalCommandException {
        ClientRuntime clientRuntime = this.getClientRuntime(cmd, options);
        RequestProcessor.Task task = clientRuntime.createTask(cmd, options != null ? options : this.defaultGlobalOptions, mgr);
        task.schedule(0);
        return task;
    }

    public ClientRuntime getClientRuntime(Command cmd, GlobalOptions options) {
        String root;
        if (options != null && options.getCVSRoot() != null) {
            root = options.getCVSRoot();
        } else {
            try {
                root = this.detectCvsRoot(cmd);
            }
            catch (NotVersionedException e) {
                if (options == null) {
                    return null;
                }
                root = options.getCVSRoot();
            }
        }
        return this.getClientRuntime(root);
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    boolean isUnignored(File file) {
        return this.unignoreOverride.contains(file);
    }

    boolean isIgnored(File file) {
        File cvsRepository;
        if (file.isDirectory() && (cvsRepository = new File(file, FILENAME_CVS_REPOSITORY)).canRead()) {
            return false;
        }
        String name = file.getName();
        if (".nbintdb".equals(name)) {
            return true;
        }
        if (this.isUnignored(file)) {
            return false;
        }
        HashSet<Pattern> patterns = new HashSet<Pattern>(Arrays.asList(CvsModuleConfig.getDefault().getIgnoredFilePatterns()));
        this.addUserPatterns(patterns);
        this.addCvsIgnorePatterns(patterns, file.getParentFile());
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        if (FILENAME_CVSIGNORE.equals(name)) {
            return false;
        }
        int sharability = SharabilityQuery.getSharability((File)file);
        if (sharability == 2) {
            if (CvsVisibilityQuery.isHiddenFolder(file)) {
                return false;
            }
            File cvsIgnoreFile = new File(file.getParentFile(), FILENAME_CVSIGNORE);
            if (file.exists() && !cvsIgnoreFile.exists() && !this.alreadyGeneratedFiles.add(cvsIgnoreFile)) {
                return true;
            }
            try {
                this.setIgnored(file);
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void addUserPatterns(Set<Pattern> patterns) {
        File userIgnores = new File(System.getProperty("user.home"), FILENAME_CVSIGNORE);
        long lm = userIgnores.lastModified();
        if (lm > this.userIgnorePatternsTimestamp || lm == 0L && this.userIgnorePatternsTimestamp > 0L) {
            this.userIgnorePatternsTimestamp = lm;
            this.parseUserPatterns(userIgnores);
        }
        if (this.userIgnorePatternsReset) {
            patterns.clear();
        }
        patterns.addAll(this.userIgnorePatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUserPatterns(File userIgnores) {
        this.userIgnorePatternsReset = false;
        this.userIgnorePatterns.clear();
        BufferedReader r = null;
        try {
            String s;
            r = new BufferedReader(new FileReader(userIgnores));
            while ((s = r.readLine()) != null) {
                if ("!".equals(s)) {
                    this.userIgnorePatternsReset = true;
                    this.userIgnorePatterns.clear();
                    continue;
                }
                try {
                    this.userIgnorePatterns.add(CvsVersioningSystem.sh2regex(s));
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Pattern sh2regex(String s) throws IOException {
        s = s.replaceAll("\\.", "\\\\.");
        s = s.replaceAll("\\*", ".*");
        s = s.replaceAll("\\?", ".");
        try {
            return Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof CVS && !Utils.isPartOfCVSMetadata(file);
    }

    public void versionedFilesChanged() {
        this.unversionedParents.clear();
        this.listenerSupport.fireVersioningEvent(EVENT_VERSIONED_FILES_CHANGED);
    }

    File getTopmostManagedParent(File file) {
        long t = System.currentTimeMillis();
        LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        if (Utils.isPartOfCVSMetadata(file)) {
            LOG.fine(" part of metaddata");
            while (file != null) {
                if (file.getName().equals(FILENAME_CVS) && (file.isDirectory() || !file.exists())) {
                    file = file.getParentFile();
                    LOG.log(Level.FINE, " will use parent {0}", new Object[]{file});
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> done = new HashSet<File>();
        File topmost = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (org.netbeans.modules.versioning.util.Utils.isScanForbidden((File)file)) break;
            if (Utils.containsMetadata(file)) {
                LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                topmost = file;
                done.clear();
            } else {
                LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{topmost, System.currentTimeMillis() - t});
        }
        return topmost;
    }

    private void addCvsIgnorePatterns(Set<Pattern> patterns, File file) {
        Set<String> shPatterns;
        try {
            shPatterns = this.readCvsIgnoreEntries(file);
        }
        catch (IOException e) {
            return;
        }
        for (String shPattern : shPatterns) {
            if ("!".equals(shPattern)) {
                patterns.clear();
                continue;
            }
            try {
                patterns.add(CvsVersioningSystem.sh2regex(shPattern));
            }
            catch (IOException e) {}
        }
    }

    private boolean isInCvsIgnore(File file) {
        try {
            String patternToIgnore = this.computePatternToIgnore(file.getName());
            return this.readCvsIgnoreEntries(file.getParentFile()).contains(patternToIgnore);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    public boolean isIgnoredFilename(File file) {
        return FILENAME_CVS.equals(file.getName());
    }

    public AdminHandler getAdminHandler() {
        return this.sah;
    }

    public FileHandler getFileHandler() {
        return this.workdirFileHandler;
    }

    public FileHandler getGzippedFileHandler() {
        return this.workdirGzippedFileHandler;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParameter(Object key) {
        Map map = this.params;
        synchronized (map) {
            return this.params.get(key);
        }
    }

    public KeywordSubstitutionOptions getDefaultKeywordSubstitution(File file) {
        return this.isText(file) || !this.isBinary(file) ? KeywordSubstitutionOptions.DEFAULT : KeywordSubstitutionOptions.BINARY;
    }

    public boolean isText(File file) {
        if (FILENAME_CVSIGNORE.equals(file.getName())) {
            return true;
        }
        try {
            Entry entry = this.sah.getEntry(file);
            if (entry != null) {
                return !entry.isBinary();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (org.netbeans.modules.versioning.util.Utils.isFileContentText((File)file)) {
            return true;
        }
        int idx = file.getName().lastIndexOf(46);
        return idx != -1 && textExtensions.contains(file.getName().substring(idx + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinary(File file) {
        InputStream in = null;
        try {
            in = new FileInputStream(file);
            in = new BufferedInputStream(in);
            for (int i = 0; i < 1024; ++i) {
                int ch = in.read();
                if (ch == -1) {
                    break;
                }
                if (ch >= 32 || ch == 9 || ch == 10 || ch == 13) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.notify(1, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(Object key, Object value) {
        Object old;
        Map map = this.params;
        synchronized (map) {
            old = this.params.put(key, value);
        }
        if (old != value) {
            this.listenerSupport.fireVersioningEvent(EVENT_PARAM_CHANGED, key);
        }
    }

    public void setIgnored(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            try {
                this.setIgnored(files[i]);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void setIgnored(File file) throws IOException {
        if (file.exists()) {
            this.addToCvsIgnore(file);
        }
    }

    void setNotUnignored(File file) {
        this.unignoreOverride.remove(file);
    }

    public void setNotignored(File[] files) {
        for (File file : files) {
            if (this.isInCvsIgnore(file)) {
                try {
                    this.removeFromCvsIgnore(file);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                continue;
            }
            this.unignoreOverride.add(file);
            this.fileStatusCache.refresh(file, 0);
        }
    }

    private void addToCvsIgnore(File file) throws IOException {
        String patternToIgnore;
        Set<String> entries = this.readCvsIgnoreEntries(file.getParentFile());
        if (entries.add(patternToIgnore = this.computePatternToIgnore(file.getName()))) {
            this.writeCvsIgnoreEntries(file.getParentFile(), entries);
        }
    }

    private String computePatternToIgnore(String name) {
        return name.replace(' ', '?');
    }

    private void removeFromCvsIgnore(File file) throws IOException {
        String patternToIgnore;
        Set<String> entries = this.readCvsIgnoreEntries(file.getParentFile());
        if (entries.remove(patternToIgnore = this.computePatternToIgnore(file.getName()))) {
            this.writeCvsIgnoreEntries(file.getParentFile(), entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readCvsIgnoreEntries(File directory) throws IOException {
        File cvsIgnore = new File(directory, FILENAME_CVSIGNORE);
        HashSet<String> entries = new HashSet<String>(5);
        if (!cvsIgnore.canRead()) {
            return entries;
        }
        BufferedReader r = null;
        try {
            String s;
            r = new BufferedReader(new FileReader(cvsIgnore));
            while ((s = r.readLine()) != null) {
                entries.addAll(Arrays.asList(s.trim().split(" ")));
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCvsIgnoreEntries(File directory, Set entries) throws IOException {
        File cvsIgnore = new File(directory, FILENAME_CVSIGNORE);
        FileObject fo = FileUtil.toFileObject((File)cvsIgnore);
        if (entries.size() == 0) {
            if (fo != null) {
                fo.delete();
            }
            return;
        }
        if (fo == null || !fo.isValid()) {
            fo = FileUtil.toFileObject((File)directory);
            fo = fo.createData(FILENAME_CVSIGNORE);
        }
        FileLock lock = fo.lock();
        PrintWriter w = null;
        try {
            w = new PrintWriter(fo.getOutputStream(lock));
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                w.println(i.next());
            }
        }
        finally {
            lock.releaseLock();
            if (w != null) {
                w.close();
            }
        }
    }

    public static void ignoreFilesystemEvents(boolean ignore) {
        FilesystemHandler.ignoreEvents(ignore);
    }

    public static GlobalOptions createGlobalOptions() {
        GlobalOptions globalOptions = new GlobalOptions();
        if (System.getProperty("cvsClientLog") == null) {
            int gzipLevel = 4;
            String level = System.getProperty("netbeans.experimental.cvs.io.compressionLevel");
            if (level != null) {
                try {
                    int candidate = Integer.parseInt(level);
                    if (0 <= candidate && candidate < 10) {
                        gzipLevel = candidate;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (gzipLevel > 0) {
                globalOptions.setCompressionLevel(gzipLevel);
            }
        }
        return globalOptions;
    }

    public VCSAnnotator getVCSAnnotator() {
        return this.fileStatusProvider;
    }

    public VCSInterceptor getVCSInterceptor() {
        return this.filesystemHandler;
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        FileInformation info = this.fileStatusCache.getStatus(workingCopy);
        if ((info.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            if (CvsVersioningSystem.getInstance().getAdminHandler().getEntry(workingCopy) == null) {
                return;
            }
            File original = VersionsCache.getInstance().getRemoteFile(workingCopy, "*", null, true);
            if (original == null) {
                throw new IOException("Unable to get BASE revision of " + workingCopy);
            }
            org.netbeans.modules.versioning.util.Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(originalFile), (InputStream)new FileInputStream(original));
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Unable to get original file", e);
        }
    }

    public void refreshAllAnnotations() {
        this.listenerSupport.fireVersioningEvent(EVENT_REFRESH_ANNOTATIONS);
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("CVS.ParallelTasks", 5, true);
        }
        return this.parallelRP;
    }

    public RequestProcessor getRequestProcessor() {
        if (this.serialRP == null) {
            this.serialRP = new RequestProcessor("CVS.SerializedTasks", 1, true);
        }
        return this.serialRP;
    }

    static {
        EVENT_PARAM_CHANGED = new Object();
        PARAM_BATCH_REFRESH_RUNNING = new Object();
        EVENT_VERSIONED_FILES_CHANGED = new Object();
        EVENT_REFRESH_ANNOTATIONS = new Object();
        textExtensions = new HashSet<String>(Arrays.asList("txt", "xml", "html", "properties", "mf", "jhm", "hs", "form"));
        LOG = Logger.getLogger(CvsVersioningSystem.class.getName());
    }
}

