/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.customwizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.mobility.cldcplatform.ArchiveFilter;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.UEIEmulatorConfiguratorImpl;
import org.netbeans.modules.mobility.cldcplatform.customwizard.WizardPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class ClasspathPanel
extends JPanel
implements WizardPanel.ComponentDescriptor {
    private static final String PROP_CLASSPATH = "Classpath";
    private final DefaultListModel classpathListModel = new DefaultListModel();
    private WizardPanel wizardPanel;
    private J2MEPlatform.J2MEProfile[] profiles;
    private JButton addButton;
    private JList classpathList;
    private JTextPane infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton removeButton;

    public ClasspathPanel() {
        this.initComponents();
        this.infoPanel.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.infoPanel.setContentType("text/html;charset=UTF-8");
        this.classpathList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object[] selectedValues = ClasspathPanel.this.classpathList.getSelectedValues();
                ClasspathPanel.this.removeButton.setEnabled(selectedValues != null && selectedValues.length > 0);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.classpathList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.setName(NbBundle.getMessage(ClasspathPanel.class, (String)"Title_CPPanel_Bootstrap_Libraries"));
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.classpathList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Classpath"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Classpath"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Classpath"));
        this.classpathList.setModel(this.classpathListModel);
        this.jScrollPane1.setViewportView(this.classpathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Add"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Remove"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Remove"));
        this.jLabel2.setLabelFor(this.infoPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Detected_APIs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Detected_APIs"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_CPPanel_Detected_APIs"));
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane2.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        File[] values = this.browse(NbBundle.getMessage(ClasspathPanel.class, (String)"TITLE_ClasspathPanel_SelectClasspath"));
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            String value = values[i].getAbsolutePath();
            if (this.classpathListModel.contains(value)) continue;
            this.classpathListModel.addElement(value);
        }
        this.updateStatus();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object[] values = this.classpathList.getSelectedValues();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.classpathListModel.removeElement(values[i]);
            }
        }
        this.updateStatus();
    }

    @Override
    public void setWizardPanel(WizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    @Override
    public void readSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform platform = (J2MEPlatform)((Object)wizardDescriptor.getProperty("Platform"));
        J2MEPlatform.Device previous = platform.getDevices()[0];
        J2MEPlatform.J2MEProfile[] profiles = previous.getProfiles();
        if (profiles.length > 0) {
            List classpath = (List)wizardDescriptor.getProperty(PROP_CLASSPATH);
            this.stringsToModel(classpath);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            this.searchForClasspath(list, new File(platform.getHomePath()), 6);
            this.stringsToModel(list);
        }
    }

    @Override
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform platform = (J2MEPlatform)((Object)wizardDescriptor.getProperty("Platform"));
        J2MEPlatform.Device previous = platform.getDevices()[0];
        J2MEPlatform.Device device = new J2MEPlatform.Device(previous.getName(), null, null, this.profiles, null);
        platform.setDevices(new J2MEPlatform.Device[]{device});
        wizardDescriptor.putProperty(PROP_CLASSPATH, this.modelToStrings());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isPanelValid() {
        boolean prof = false;
        boolean conf = false;
        for (int i = 0; i < this.profiles.length; ++i) {
            J2MEPlatform.J2MEProfile profile = this.profiles[i];
            if ("profile".equals(profile.getType())) {
                prof = true;
                continue;
            }
            if (!"configuration".equals(profile.getType())) continue;
            conf = true;
        }
        if (!prof) {
            this.wizardPanel.setErrorMessage(ClasspathPanel.class, "ERR_NoProfile");
        } else if (!conf) {
            this.wizardPanel.setErrorMessage(ClasspathPanel.class, "ERR_NoConfiguration");
        } else {
            this.wizardPanel.setErrorMessage(ClasspathPanel.class, null);
        }
        return prof && conf;
    }

    @Override
    public boolean isFinishPanel() {
        return true;
    }

    private void updateStatus() {
        J2MEPlatform platform = (J2MEPlatform)((Object)this.wizardPanel.getProperty("Platform"));
        String string = this.stringsToString(Arrays.asList(this.classpathListModel.toArray()));
        List<J2MEPlatform.J2MEProfile> profilesList = UEIEmulatorConfiguratorImpl.analyzePath(new File(platform.getHomePath()), string, string);
        this.profiles = profilesList.toArray(new J2MEPlatform.J2MEProfile[profilesList.size()]);
        StringBuffer recognizedProfiles = new StringBuffer();
        StringBuffer recognizedConfigurations = new StringBuffer();
        StringBuffer recognizedOptionals = new StringBuffer();
        for (int i = 0; i < this.profiles.length; ++i) {
            J2MEPlatform.J2MEProfile profile = this.profiles[i];
            if (profile.isNameIsJarFileName()) continue;
            if ("profile".equals(profile.getType())) {
                if (recognizedProfiles.length() > 0) {
                    recognizedProfiles.append(", ");
                }
                recognizedProfiles.append(NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_OutputTextBold", (Object)profile.getName(), (Object)profile.getVersion()));
                continue;
            }
            if ("configuration".equals(profile.getType())) {
                if (recognizedConfigurations.length() > 0) {
                    recognizedConfigurations.append(", ");
                }
                recognizedConfigurations.append(NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_OutputTextBold", (Object)profile.getName(), (Object)profile.getVersion()));
                continue;
            }
            if (!"optional".equals(profile.getType())) continue;
            if (recognizedOptionals.length() > 0) {
                recognizedOptionals.append(", ");
            }
            recognizedOptionals.append(NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_OutputText", (Object)profile.getName(), (Object)profile.getVersion()));
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append("<html><font face=\"dialog\" size=\"-1\">");
        boolean shown = false;
        if (recognizedProfiles.length() > 0) {
            sb.append(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Profiles")).append(recognizedProfiles).append("<br>");
            shown = true;
        }
        if (recognizedConfigurations.length() > 0) {
            sb.append(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanel_Configurations")).append(recognizedConfigurations).append("<br>");
            shown = true;
        }
        if (recognizedOptionals.length() > 0) {
            sb.append(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_CPPanle_Optional_APIs")).append(recognizedOptionals).append("<br>");
            shown = true;
        }
        sb.append(shown ? "<font size=\"-2\">" + NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_CPPanel_Recognized_Packages_Shown_Only") : NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_CPPanel_Details_Not_Available"));
        this.infoPanel.setText(sb.toString());
        this.infoPanel.setCaretPosition(0);
        this.wizardPanel.fireChanged();
    }

    private void stringsToModel(List<String> strings) {
        this.classpathListModel.clear();
        for (String str : strings) {
            this.classpathListModel.addElement(str);
        }
        this.updateStatus();
    }

    private List<String> modelToStrings() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.classpathListModel.size(); ++i) {
            list.add((String)this.classpathListModel.get(i));
        }
        return list;
    }

    private String stringsToString(List<Object> list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    private void searchForClasspath(ArrayList<String> list, File directory, int level) {
        File[] files = directory.listFiles();
        if (files != null && files.length < 40 && list.size() < 100) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = file.getName().toLowerCase();
                if (level > 0 && file.isDirectory()) {
                    this.searchForClasspath(list, file, level - 1);
                    continue;
                }
                if (!file.isFile() || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                list.add(file.getAbsolutePath());
            }
        }
    }

    private File[] browse(String title) {
        return new FileChooserBuilder(ClasspathPanel.class).setTitle(title).setFileFilter((FileFilter)new ArchiveFilter()).showMultiOpenDialog();
    }
}

