/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public class VariablesModel
implements TreeModel,
ExtendedNodeModel,
TableModel {
    private static final String GLOBAL = "Global Variables";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    public static final String CLASS = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
    protected final RubySession rubySession;
    protected final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public VariablesModel(ContextProvider contextProvider) {
        this.rubySession = new ContextProviderWrapper(contextProvider).getRubySession();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (!this.rubySession.isSessionSuspended()) {
            return new Object[0];
        }
        if (parent == "Root") {
            RubyVariable[] frameVars = this.rubySession.getVariables();
            Object[] vars = new Object[frameVars.length + 1];
            vars[0] = GLOBAL;
            System.arraycopy(frameVars, 0, vars, 1, frameVars.length);
            return vars;
        }
        if (parent == GLOBAL) {
            return this.rubySession.getGlobalVariables();
        }
        if (parent instanceof RubyVariable) {
            return this.rubySession.getChildren((RubyVariable)parent);
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root" || node == GLOBAL) {
            return false;
        }
        if (node instanceof RubyVariable) {
            RubyValue val = ((RubyVariable)node).getValue();
            return val == null || !val.hasVariables();
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object parent) throws UnknownTypeException {
        if (!this.rubySession.isSessionSuspended()) {
            return 0;
        }
        if (parent == "Root") {
            return this.rubySession.getVariables().length + 1;
        }
        if (parent == GLOBAL) {
            return this.rubySession.getGlobalVariables().length;
        }
        if (parent instanceof RubyVariable) {
            return this.rubySession.getChildren((RubyVariable)parent).length;
        }
        throw new UnknownTypeException(parent);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return VariablesModel.getMessage("CTL_VariablesModel.Column.Name.Name");
        }
        if (node == GLOBAL) {
            return VariablesModel.getMessage("CTL_VariablesModel.Global.Variables");
        }
        if (node instanceof RubyVariable) {
            String name = ((RubyVariable)node).getName();
            assert (name != null) : "null name for the RubyVariable: " + node;
            return name;
        }
        assert (node != null) : "null node passed to VariablesModel.getDisplayName()";
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        assert (node != "Root");
        if (node == GLOBAL) {
            return CLASS;
        }
        if (node instanceof RubyVariable) {
            if (((RubyVariable)node).isClass()) {
                return CLASS;
            }
            return LOCAL;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == GLOBAL) {
            return VariablesModel.getMessage("CTL_VariablesModel.Global.Variables.Short.Description");
        }
        if (node == "Root") {
            return VariablesModel.getMessage("CTL_VariablesModel.Column.Name.Desc");
        }
        if (node instanceof RubyVariable) {
            RubyValue value = ((RubyVariable)node).getValue();
            return '(' + value.getReferenceTypeName() + ") " + value.getValueString();
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == GLOBAL) {
            return "";
        }
        if (node instanceof RubyVariable) {
            RubyVariable var = (RubyVariable)node;
            if (var.getValue() == null) {
                return "<nil>";
            }
            if ("LocalsValue".equals(columnID)) {
                return var.getValue().getValueString();
            }
            if ("LocalsType".equals(columnID)) {
                return var.getValue().getReferenceTypeName();
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(VariablesModel.class, (String)key);
    }
}

