/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.Type;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.FastSwitchType;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.VariableCompiler;
import org.jruby.compiler.impl.ChildScopedBodyCompiler;
import org.jruby.compiler.impl.ChildScopedBodyCompiler19;
import org.jruby.compiler.impl.ClassBodyCompiler;
import org.jruby.compiler.impl.RootScopedBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBodyCompiler
implements BodyCompiler {
    protected SkinnyMethodAdapter method;
    protected VariableCompiler variableCompiler;
    protected InvocationCompiler invocationCompiler;
    protected int argParamCount;
    protected Label[] currentLoopLabels;
    protected Label scopeStart = new Label();
    protected Label scopeEnd = new Label();
    protected Label redoJump;
    protected boolean inNestedMethod = false;
    private int lastLine = -1;
    private int lastPositionLine = -1;
    protected StaticScope scope;
    protected ASTInspector inspector;
    protected String methodName;
    protected StandardASMCompiler script;

    public BaseBodyCompiler(StandardASMCompiler scriptCompiler, String methodName, ASTInspector inspector, StaticScope scope) {
        this.script = scriptCompiler;
        this.scope = scope;
        this.inspector = inspector;
        this.methodName = methodName;
        this.argParamCount = this.getActualArgsCount(scope);
        this.method = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(9, methodName, this.getSignature(), null, null));
        this.createVariableCompiler();
        if (StandardASMCompiler.invDynInvCompilerConstructor != null) {
            try {
                this.invocationCompiler = (InvocationCompiler)StandardASMCompiler.invDynInvCompilerConstructor.newInstance(this, this.method);
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException ie) {
            }
            catch (InvocationTargetException ie) {
                // empty catch block
            }
        }
        if (this.invocationCompiler == null) {
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }
    }

    protected boolean shouldUseBoxedArgs(StaticScope scope) {
        return scope.getRestArg() >= 0 || scope.getRestArg() == -2 || scope.getOptionalArgs() > 0 || scope.getRequiredArgs() > 3;
    }

    protected int getActualArgsCount(StaticScope scope) {
        if (this.shouldUseBoxedArgs(scope)) {
            return 1;
        }
        return scope.getRequiredArgs();
    }

    protected abstract String getSignature();

    protected abstract void createVariableCompiler();

    public abstract void beginMethod(CompilerCallback var1, StaticScope var2);

    @Override
    public abstract void endBody();

    @Override
    public BodyCompiler chainToMethod(String methodName) {
        BaseBodyCompiler compiler = this.outline(methodName);
        this.endBody();
        return compiler;
    }

    public void beginChainedMethod() {
        this.method.start();
        this.method.aload(1);
        this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        this.method.astore(this.getRuntimeIndex());
        this.method.aload(this.getRuntimeIndex());
        this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        this.method.astore(this.getNilIndex());
        this.method.aload(1);
        this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.getDynamicScopeIndex());
        if (this.scope.getNumberOfVariables() > 4) {
            this.method.aload(this.getDynamicScopeIndex());
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            this.method.astore(this.getVarsArrayIndex());
        }
        this.method.label(this.scopeStart);
    }

    @Override
    public abstract BaseBodyCompiler outline(String var1);

    public StandardASMCompiler getScriptCompiler() {
        return this.script;
    }

    @Override
    public void lineNumber(ISourcePosition position) {
        int thisLine = position.getStartLine();
        if (thisLine == this.lastLine) {
            return;
        }
        this.lastLine = thisLine;
        Label line = new Label();
        this.method.label(line);
        this.method.visitLineNumber(thisLine + 1, line);
    }

    public void loadThreadContext() {
        this.method.aload(1);
    }

    @Override
    public void loadSelf() {
        this.method.aload(2);
    }

    protected int getClosureIndex() {
        return 3 + this.argParamCount + 0;
    }

    protected int getRuntimeIndex() {
        return 3 + this.argParamCount + 2;
    }

    protected int getNilIndex() {
        return 3 + this.argParamCount + 4;
    }

    protected int getPreviousExceptionIndex() {
        return 3 + this.argParamCount + 6;
    }

    protected int getDynamicScopeIndex() {
        return 3 + this.argParamCount + 1;
    }

    protected int getVarsArrayIndex() {
        return 3 + this.argParamCount + 3;
    }

    protected int getFirstTempIndex() {
        return 3 + this.argParamCount + 7;
    }

    protected int getExceptionIndex() {
        return 3 + this.argParamCount + 5;
    }

    public void loadThis() {
        this.method.aload(0);
    }

    public void loadRuntime() {
        this.method.aload(this.getRuntimeIndex());
    }

    public void loadBlock() {
        this.method.aload(this.getClosureIndex());
    }

    @Override
    public void loadNil() {
        this.method.aload(this.getNilIndex());
    }

    @Override
    public void loadNull() {
        this.method.aconst_null();
    }

    @Override
    public void loadObject() {
        this.loadRuntime();
        this.invokeRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
    }

    public void invokeUtilityMethod(String methodName, String signature) {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), methodName, signature);
    }

    public void invokeThreadContext(String methodName, String signature) {
        this.method.invokevirtual(StandardASMCompiler.THREADCONTEXT, methodName, signature);
    }

    public void invokeRuby(String methodName, String signature) {
        this.method.invokevirtual(StandardASMCompiler.RUBY, methodName, signature);
    }

    public void invokeIRubyObject(String methodName, String signature) {
        this.method.invokeinterface(StandardASMCompiler.IRUBYOBJECT, methodName, signature);
    }

    @Override
    public void consumeCurrentValue() {
        this.method.pop();
    }

    @Override
    public void duplicateCurrentValue() {
        this.method.dup();
    }

    @Override
    public void swapValues() {
        this.method.swap();
    }

    @Override
    public void reverseValues(int count2) {
        switch (count2) {
            case 2: {
                this.method.swap();
                break;
            }
            case 3: {
                this.method.dup_x2();
                this.method.pop();
                this.method.swap();
                break;
            }
            case 4: {
                this.method.swap();
                this.method.dup2_x2();
                this.method.pop2();
                this.method.swap();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                int i;
                int[] tmpLocals = new int[count2];
                for (i = 0; i < count2; ++i) {
                    tmpLocals[i] = this.getVariableCompiler().grabTempLocal();
                    this.getVariableCompiler().setTempLocal(tmpLocals[i]);
                }
                for (i = 0; i < count2; ++i) {
                    this.getVariableCompiler().getTempLocal(tmpLocals[i]);
                    this.getVariableCompiler().releaseTempLocal();
                }
                break;
            }
            default: {
                throw new NotCompilableException("can't reverse more than ten values on the stack");
            }
        }
    }

    @Override
    public void retrieveSelf() {
        this.loadSelf();
    }

    @Override
    public void retrieveSelfClass() {
        this.loadSelf();
        this.metaclass();
    }

    @Override
    public VariableCompiler getVariableCompiler() {
        return this.variableCompiler;
    }

    @Override
    public InvocationCompiler getInvocationCompiler() {
        return this.invocationCompiler;
    }

    @Override
    public void assignConstantInCurrent(String name2) {
        this.loadThreadContext();
        this.method.ldc(name2);
        this.invokeUtilityMethod("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, ThreadContext.class, String.class)));
    }

    @Override
    public void assignConstantInModule(String name2) {
        this.method.ldc(name2);
        this.loadThreadContext();
        this.invokeUtilityMethod("setConstantInModule", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class, ThreadContext.class));
    }

    @Override
    public void assignConstantInObject(String name2) {
        this.loadObject();
        this.method.swap();
        this.assignConstantInModule(name2);
    }

    @Override
    public void retrieveConstant(String name2) {
        this.script.getCacheCompiler().cacheConstant(this, name2);
    }

    @Override
    public void retrieveConstantFromModule(String name2) {
        this.invokeUtilityMethod("checkIsModule", CodegenUtils.sig(RubyModule.class, IRubyObject.class));
        this.script.getCacheCompiler().cacheConstantFrom(this, name2);
    }

    @Override
    public void retrieveConstantFromObject(String name2) {
        this.loadObject();
        this.script.getCacheCompiler().cacheConstantFrom(this, name2);
    }

    @Override
    public void retrieveClassVariable(String name2) {
        this.loadThreadContext();
        this.loadRuntime();
        this.loadSelf();
        this.method.ldc(name2);
        this.invokeUtilityMethod("fastFetchClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
    }

    @Override
    public void assignClassVariable(String name2) {
        this.loadThreadContext();
        this.method.swap();
        this.loadRuntime();
        this.method.swap();
        this.loadSelf();
        this.method.swap();
        this.method.ldc(name2);
        this.method.swap();
        this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    @Override
    public void assignClassVariable(String name2, CompilerCallback value2) {
        this.loadThreadContext();
        this.loadRuntime();
        this.loadSelf();
        this.method.ldc(name2);
        value2.call(this);
        this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    @Override
    public void declareClassVariable(String name2) {
        this.loadThreadContext();
        this.method.swap();
        this.loadRuntime();
        this.method.swap();
        this.loadSelf();
        this.method.swap();
        this.method.ldc(name2);
        this.method.swap();
        this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    @Override
    public void declareClassVariable(String name2, CompilerCallback value2) {
        this.loadThreadContext();
        this.loadRuntime();
        this.loadSelf();
        this.method.ldc(name2);
        value2.call(this);
        this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    @Override
    public void createNewFloat(double value2) {
        this.loadRuntime();
        this.method.ldc(new Double(value2));
        this.invokeRuby("newFloat", CodegenUtils.sig(RubyFloat.class, CodegenUtils.params(Double.TYPE)));
    }

    @Override
    public void createNewFixnum(long value2) {
        this.script.getCacheCompiler().cacheFixnum(this, value2);
    }

    @Override
    public void createNewBignum(BigInteger value2) {
        this.loadRuntime();
        this.script.getCacheCompiler().cacheBigInteger(this, value2);
        this.method.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, CodegenUtils.params(Ruby.class, BigInteger.class)));
    }

    @Override
    public void createNewString(ArrayCallback callback, int count2) {
        this.loadRuntime();
        this.method.ldc(20);
        this.method.invokestatic(CodegenUtils.p(RubyString.class), "newStringLight", CodegenUtils.sig(RubyString.class, Ruby.class, Integer.TYPE));
        for (int i = 0; i < count2; ++i) {
            callback.nextValue(this, null, i);
            this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
        }
    }

    @Override
    public void createNewSymbol(ArrayCallback callback, int count2) {
        this.loadRuntime();
        this.createNewString(callback, count2);
        this.toJavaString();
        this.invokeRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
    }

    @Override
    public void createNewString(ByteList value2) {
        this.script.getCacheCompiler().cacheString(this, value2);
    }

    @Override
    public void createNewSymbol(String name2) {
        this.script.getCacheCompiler().cacheSymbol(this, name2);
    }

    @Override
    public void createNewArray(boolean lightweight) {
        this.loadRuntime();
        this.method.swap();
        if (lightweight) {
            this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
        } else {
            this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
        }
    }

    @Override
    public void createNewArray(Object[] sourceArray, ArrayCallback callback, boolean lightweight) {
        this.loadRuntime();
        this.buildRubyArray(sourceArray, callback, lightweight);
    }

    @Override
    public void createNewLiteralArray(Object[] sourceArray, ArrayCallback callback, boolean lightweight) {
        this.buildRubyLiteralArray(sourceArray, callback, lightweight);
    }

    @Override
    public void createEmptyArray() {
        this.loadRuntime();
        this.invokeRuby("newArray", CodegenUtils.sig(RubyArray.class, new Class[0]));
    }

    @Override
    public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
        this.buildObjectArray(StandardASMCompiler.IRUBYOBJECT, sourceArray, callback);
    }

    @Override
    public void createObjectArray(int elementCount) {
        if (elementCount >= 6) {
            throw new NotCompilableException("Don't use createObjectArray(int) for more than 5 elements");
        }
        Object[] params2 = new Class[elementCount];
        Arrays.fill(params2, IRubyObject.class);
        this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, (Class[])params2));
    }

    private void buildObjectArray(String type2, Object[] sourceArray, ArrayCallback callback) {
        if (sourceArray.length == 0) {
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        } else if (sourceArray.length <= 5) {
            for (int i = 0; i < sourceArray.length; ++i) {
                callback.nextValue(this, sourceArray, i);
            }
            this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class, sourceArray.length)));
        } else {
            this.method.pushInt(sourceArray.length);
            this.method.anewarray(type2);
            for (int i = 0; i < sourceArray.length; ++i) {
                this.method.dup();
                this.method.pushInt(i);
                callback.nextValue(this, sourceArray, i);
                this.method.arraystore();
            }
        }
    }

    private void buildRubyArray(Object[] sourceArray, ArrayCallback callback, boolean light) {
        if (sourceArray.length == 0) {
            this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newEmptyArray", CodegenUtils.sig(RubyArray.class, Ruby.class));
        } else if (sourceArray.length <= 5) {
            for (int i = 0; i < sourceArray.length; ++i) {
                callback.nextValue(this, sourceArray, i);
            }
            this.invokeUtilityMethod("constructRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject.class, sourceArray.length)));
        } else {
            this.method.pushInt(sourceArray.length);
            this.method.anewarray(CodegenUtils.p(IRubyObject.class));
            for (int i = 0; i < sourceArray.length; ++i) {
                this.method.dup();
                this.method.pushInt(i);
                callback.nextValue(this, sourceArray, i);
                this.method.arraystore();
            }
            if (light) {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, Ruby.class, IRubyObject[].class));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, Ruby.class, IRubyObject[].class));
            }
        }
    }

    private void buildRubyLiteralArray(Object[] sourceArray, ArrayCallback callback, boolean light) {
        if (sourceArray.length < 100) {
            this.loadRuntime();
            this.buildRubyArray(sourceArray, callback, light);
        } else {
            SkinnyMethodAdapter oldMethod = this.method;
            String methodName = "array_builder_" + this.script.getAndIncrementMethodIndex() + "";
            this.method = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4106, methodName, CodegenUtils.sig(IRubyObject[].class, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject[].class), null, null));
            this.method.start();
            this.method.aload(1);
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.astore(this.getRuntimeIndex());
            this.method.aload(this.getRuntimeIndex());
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            for (int i = 0; i < sourceArray.length; ++i) {
                if ((i + 1) % 100 == 0) {
                    String nextName = "array_builder_" + this.script.getAndIncrementMethodIndex() + "";
                    this.method.aloadMany(0, 1, 2);
                    this.method.invokestatic(this.script.getClassname(), nextName, CodegenUtils.sig(IRubyObject[].class, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject[].class));
                    this.method.areturn();
                    this.method.end();
                    this.method = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4106, nextName, CodegenUtils.sig(IRubyObject[].class, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject[].class), null, null));
                    this.method.start();
                    this.method.aload(1);
                    this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    this.method.astore(this.getRuntimeIndex());
                    this.method.aload(this.getRuntimeIndex());
                    this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                    this.method.astore(this.getNilIndex());
                }
                this.method.aload(2);
                this.method.pushInt(i);
                callback.nextValue(this, sourceArray, i);
                this.method.arraystore();
            }
            this.method.aload(2);
            this.method.areturn();
            this.method.end();
            this.method = oldMethod;
            this.loadRuntime();
            this.method.aload(0);
            this.method.aload(1);
            this.method.pushInt(sourceArray.length);
            this.method.anewarray(CodegenUtils.p(IRubyObject.class));
            this.method.invokestatic(this.script.getClassname(), methodName, CodegenUtils.sig(IRubyObject[].class, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject[].class));
            if (light) {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, Ruby.class, IRubyObject[].class));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, Ruby.class, IRubyObject[].class));
            }
        }
    }

    @Override
    public void createEmptyHash() {
        this.loadRuntime();
        this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
    }

    @Override
    public void createNewHash(Object elements, ArrayCallback callback, int keyCount) {
        this.createNewHashCommon(elements, callback, keyCount, "constructHash", "fastASetCheckString");
    }

    @Override
    public void createNewLiteralHash(Object elements, ArrayCallback callback, int keyCount) {
        this.createNewLiteralHashCommon(elements, callback, keyCount, "constructHash", "fastASetCheckString");
    }

    @Override
    public void createNewHash19(Object elements, ArrayCallback callback, int keyCount) {
        this.createNewHashCommon(elements, callback, keyCount, "constructHash19", "fastASetCheckString19");
    }

    private void createNewHashCommon(Object elements, ArrayCallback callback, int keyCount, String constructorName, String methodName) {
        int i;
        this.loadRuntime();
        for (i = 0; i < keyCount && i < 3; ++i) {
            callback.nextValue(this, elements, i);
        }
        this.invokeUtilityMethod(constructorName, CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class, IRubyObject.class, i * 2)));
        while (i < keyCount) {
            this.method.dup();
            this.loadRuntime();
            callback.nextValue(this, elements, i);
            this.method.invokevirtual(CodegenUtils.p(RubyHash.class), methodName, CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class, IRubyObject.class, IRubyObject.class)));
            ++i;
        }
    }

    private void createNewLiteralHashCommon(Object elements, ArrayCallback callback, int keyCount, String constructorName, String methodName) {
        if (keyCount < 50) {
            this.createNewHashCommon(elements, callback, keyCount, constructorName, methodName);
        } else {
            SkinnyMethodAdapter oldMethod = this.method;
            String builderMethod = "hash_builder_" + this.script.getAndIncrementMethodIndex() + "";
            this.method = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4106, builderMethod, CodegenUtils.sig(RubyHash.class, "L" + this.script.getClassname() + ";", ThreadContext.class, RubyHash.class), null, null));
            this.method.start();
            this.method.aload(1);
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.astore(this.getRuntimeIndex());
            this.method.aload(this.getRuntimeIndex());
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            for (int i = 0; i < keyCount; ++i) {
                if ((i + 1) % 100 == 0) {
                    String nextName = "hash_builder_" + this.script.getAndIncrementMethodIndex() + "";
                    this.method.aloadMany(0, 1, 2);
                    this.method.invokestatic(this.script.getClassname(), nextName, CodegenUtils.sig(RubyHash.class, "L" + this.script.getClassname() + ";", ThreadContext.class, RubyHash.class));
                    this.method.areturn();
                    this.method.end();
                    this.method = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4106, nextName, CodegenUtils.sig(RubyHash.class, "L" + this.script.getClassname() + ";", ThreadContext.class, RubyHash.class), null, null));
                    this.method.start();
                    this.method.aload(1);
                    this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    this.method.astore(this.getRuntimeIndex());
                    this.method.aload(this.getRuntimeIndex());
                    this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                    this.method.astore(this.getNilIndex());
                }
                this.method.aload(2);
                this.loadRuntime();
                callback.nextValue(this, elements, i);
                this.method.invokevirtual(CodegenUtils.p(RubyHash.class), methodName, CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class, IRubyObject.class, IRubyObject.class)));
            }
            this.method.aload(2);
            this.method.areturn();
            this.method.end();
            this.method = oldMethod;
            this.method.aload(0);
            this.method.aload(1);
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, Ruby.class));
            this.method.invokestatic(this.script.getClassname(), builderMethod, CodegenUtils.sig(RubyHash.class, "L" + this.script.getClassname() + ";", ThreadContext.class, RubyHash.class));
        }
    }

    @Override
    public void createNewRange(CompilerCallback beginEndCallback, boolean isExclusive) {
        this.loadRuntime();
        this.loadThreadContext();
        beginEndCallback.call(this);
        if (isExclusive) {
            this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newExclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
        } else {
            this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newInclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
        }
    }

    @Override
    public void createNewLambda(CompilerCallback closure) {
        this.loadThreadContext();
        closure.call(this);
        this.loadSelf();
        this.invokeUtilityMethod("newLiteralLambda", CodegenUtils.sig(RubyProc.class, ThreadContext.class, Block.class, IRubyObject.class));
    }

    private void isTrue() {
        this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    @Override
    public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        this.isTrue();
        this.method.ifeq(falseJmp);
        trueBranch.branch(this);
        this.method.go_to(afterJmp);
        this.method.label(falseJmp);
        falseBranch.branch(this);
        this.method.label(afterJmp);
    }

    @Override
    public void performLogicalAnd(BranchCallback longBranch) {
        Label falseJmp = new Label();
        this.method.dup();
        this.isTrue();
        this.method.ifeq(falseJmp);
        this.method.pop();
        longBranch.branch(this);
        this.method.label(falseJmp);
    }

    @Override
    public void performLogicalOr(BranchCallback longBranch) {
        Label falseJmp = new Label();
        this.method.dup();
        this.isTrue();
        this.method.ifne(falseJmp);
        this.method.pop();
        longBranch.branch(this);
        this.method.label(falseJmp);
    }

    @Override
    public void performBooleanLoopSafe(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        String mname = this.getNewRescueName();
        BaseBodyCompiler nested = this.outline(mname);
        nested.performBooleanLoopSafeInner(condition, body, checkFirst);
    }

    private void performBooleanLoopSafeInner(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        this.performBooleanLoop(condition, body, checkFirst);
        this.endBody();
    }

    @Override
    public void performBooleanLoop(BranchCallback condition, final BranchCallback body, boolean checkFirst) {
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label catchNext = new Label();
        Label catchBreak = new Label();
        Label endOfBody = new Label();
        Label conditionCheck = new Label();
        final Label topOfBody = new Label();
        Label done = new Label();
        Label normalLoopEnd = new Label();
        this.method.trycatch(tryBegin, tryEnd, catchNext, CodegenUtils.p(JumpException.NextJump.class));
        this.method.trycatch(tryBegin, tryEnd, catchBreak, CodegenUtils.p(JumpException.BreakJump.class));
        this.method.label(tryBegin);
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
        if (checkFirst) {
            this.method.go_to(conditionCheck);
        }
        this.method.label(topOfBody);
        Runnable redoBody = new Runnable(){

            public void run() {
                Runnable raiseBody = new Runnable(){

                    public void run() {
                        body.branch(BaseBodyCompiler.this);
                    }
                };
                Runnable raiseCatch = new Runnable(){

                    public void run() {
                        BaseBodyCompiler.this.loadThreadContext();
                        BaseBodyCompiler.this.invokeUtilityMethod("unwrapRedoNextBreakOrJustLocalJump", CodegenUtils.sig(Throwable.class, RaiseException.class, ThreadContext.class));
                        BaseBodyCompiler.this.method.athrow();
                    }
                };
                BaseBodyCompiler.this.method.trycatch(CodegenUtils.p(RaiseException.class), raiseBody, raiseCatch);
            }
        };
        Runnable redoCatch = new Runnable(){

            public void run() {
                BaseBodyCompiler.this.method.pop();
                BaseBodyCompiler.this.method.go_to(topOfBody);
            }
        };
        this.method.trycatch(CodegenUtils.p(JumpException.RedoJump.class), redoBody, redoCatch);
        this.method.label(endOfBody);
        this.method.pop();
        this.method.label(conditionCheck);
        condition.branch(this);
        this.isTrue();
        this.method.ifne(topOfBody);
        this.currentLoopLabels = oldLoopLabels;
        this.method.label(tryEnd);
        this.method.go_to(normalLoopEnd);
        this.method.label(catchNext);
        this.method.pop();
        this.method.go_to(conditionCheck);
        this.method.label(catchBreak);
        this.loadThreadContext();
        this.invokeUtilityMethod("breakJumpInWhile", CodegenUtils.sig(IRubyObject.class, JumpException.BreakJump.class, ThreadContext.class));
        this.method.go_to(done);
        this.method.label(normalLoopEnd);
        this.loadNil();
        this.method.label(done);
    }

    @Override
    public void performBooleanLoopLight(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        Label endOfBody = new Label();
        Label conditionCheck = new Label();
        Label topOfBody = new Label();
        Label done = new Label();
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
        if (checkFirst) {
            this.method.go_to(conditionCheck);
        }
        this.method.label(topOfBody);
        body.branch(this);
        this.method.label(endOfBody);
        this.method.pop();
        this.method.label(conditionCheck);
        condition.branch(this);
        this.isTrue();
        this.method.ifne(topOfBody);
        this.currentLoopLabels = oldLoopLabels;
        this.loadNil();
        this.method.label(done);
    }

    @Override
    public void createNewClosure(int line, StaticScope scope, int arity2, CompilerCallback body, CompilerCallback args2, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$" + "__block__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, inspector, scope);
        closureCompiler.beginMethod(args2, scope);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        this.script.getCacheCompiler().cacheClosure(this, closureMethodName, arity2, scope, hasMultipleArgsHead, argsNodeId, inspector);
        this.script.addBlockCallbackDescriptor(closureMethodName);
        this.invokeUtilityMethod("createBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, BlockBody.class)));
    }

    @Override
    public void createNewClosure19(int line, StaticScope scope, int arity2, CompilerCallback body, CompilerCallback args2, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$" + "__block__";
        ChildScopedBodyCompiler19 closureCompiler = new ChildScopedBodyCompiler19(this.script, closureMethodName, inspector, scope);
        closureCompiler.beginMethod(args2, scope);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        this.script.getCacheCompiler().cacheClosure19(this, closureMethodName, arity2, scope, hasMultipleArgsHead, argsNodeId, inspector);
        this.script.addBlockCallback19Descriptor(closureMethodName);
        this.invokeUtilityMethod("createBlock19", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, BlockBody.class)));
    }

    @Override
    public void runBeginBlock(StaticScope scope, CompilerCallback body) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$__begin__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, null, scope);
        closureCompiler.beginMethod(null, scope);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        StandardASMCompiler.buildStaticScopeNames(this.method, scope);
        this.script.getCacheCompiler().cacheSpecialClosure(this, closureMethodName);
        this.invokeUtilityMethod("runBeginBlock", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String[].class, CompiledBlockCallback.class)));
    }

    @Override
    public void createNewForLoop(int arity2, CompilerCallback body, CompilerCallback args2, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$__for__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, inspector, this.scope);
        closureCompiler.beginMethod(args2, null);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        this.method.pushInt(arity2);
        this.script.getCacheCompiler().cacheSpecialClosure(this, closureMethodName);
        this.method.ldc(hasMultipleArgsHead);
        this.method.ldc(BlockBody.asArgumentType(argsNodeId));
        this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
    }

    @Override
    public void createNewEndBlock(CompilerCallback body) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$__end__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, null, this.scope);
        closureCompiler.beginMethod(null, null);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        this.method.iconst_0();
        this.script.getCacheCompiler().cacheSpecialClosure(this, closureMethodName);
        this.method.iconst_0();
        this.method.iconst_0();
        this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
        this.loadRuntime();
        this.invokeUtilityMethod("registerEndBlock", CodegenUtils.sig(Void.TYPE, Block.class, Ruby.class));
        this.loadNil();
    }

    public void getCompiledClass() {
        this.method.ldc(Type.getType(this.script.getClassname()));
    }

    public void println() {
        this.method.dup();
        this.method.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        this.method.swap();
        this.method.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
    }

    @Override
    public void defineAlias(CompilerCallback args2) {
        this.loadThreadContext();
        args2.call(this);
        this.invokeUtilityMethod("defineAlias", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class, Object.class));
    }

    @Override
    public void literal(String value2) {
        this.method.ldc(value2);
    }

    @Override
    public void loadFalse() {
        this.loadRuntime();
        this.invokeRuby("getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
    }

    @Override
    public void loadTrue() {
        this.loadRuntime();
        this.invokeRuby("getTrue", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
    }

    @Override
    public void loadCurrentModule() {
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getStaticScope", CodegenUtils.sig(StaticScope.class, new Class[0]));
        this.method.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class, new Class[0]));
    }

    @Override
    public void retrieveInstanceVariable(String name2) {
        this.script.getCacheCompiler().cachedGetVariable(this, name2);
    }

    @Override
    public void assignInstanceVariable(String name2) {
        final int tmp = this.getVariableCompiler().grabTempLocal();
        this.getVariableCompiler().setTempLocal(tmp);
        CompilerCallback callback = new CompilerCallback(){

            public void call(BodyCompiler context) {
                context.getVariableCompiler().getTempLocal(tmp);
            }
        };
        this.script.getCacheCompiler().cachedSetVariable(this, name2, callback);
    }

    @Override
    public void assignInstanceVariable(String name2, CompilerCallback value2) {
        this.script.getCacheCompiler().cachedSetVariable(this, name2, value2);
    }

    @Override
    public void retrieveGlobalVariable(String name2) {
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeUtilityMethod("getGlobalVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, String.class));
    }

    @Override
    public void assignGlobalVariable(String name2) {
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeUtilityMethod("setGlobalVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class, String.class));
    }

    @Override
    public void assignGlobalVariable(String name2, CompilerCallback value2) {
        value2.call(this);
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeUtilityMethod("setGlobalVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class, String.class));
    }

    @Override
    public void negateCurrentValue() {
        this.loadRuntime();
        this.invokeUtilityMethod("negate", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class));
    }

    @Override
    public void splatCurrentValue(String methodName) {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), methodName, CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void singlifySplattedValue() {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void aryToAry() {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aryToAry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void ensureRubyArray() {
        this.invokeUtilityMethod("ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void ensureMultipleAssignableRubyArray(boolean masgnHasHead) {
        this.loadRuntime();
        this.method.pushBoolean(masgnHasHead);
        this.invokeUtilityMethod("ensureMultipleAssignableRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class, Ruby.class, Boolean.TYPE)));
    }

    @Override
    public void forEachInValueArray(int start2, int count2, Object source2, ArrayCallback callback, CompilerCallback argsCallback) {
        if (start2 < count2 || argsCallback != null) {
            int tempLocal = this.getVariableCompiler().grabTempLocal();
            this.getVariableCompiler().setTempLocal(tempLocal);
            while (start2 < count2) {
                this.getVariableCompiler().getTempLocal(tempLocal);
                switch (start2) {
                    case 0: {
                        this.invokeUtilityMethod("arrayEntryOrNilZero", CodegenUtils.sig(IRubyObject.class, RubyArray.class));
                        break;
                    }
                    case 1: {
                        this.invokeUtilityMethod("arrayEntryOrNilOne", CodegenUtils.sig(IRubyObject.class, RubyArray.class));
                        break;
                    }
                    case 2: {
                        this.invokeUtilityMethod("arrayEntryOrNilTwo", CodegenUtils.sig(IRubyObject.class, RubyArray.class));
                        break;
                    }
                    default: {
                        this.method.pushInt(start2);
                        this.invokeUtilityMethod("arrayEntryOrNil", CodegenUtils.sig(IRubyObject.class, RubyArray.class, Integer.TYPE));
                    }
                }
                callback.nextValue(this, source2, start2);
                ++start2;
            }
            if (argsCallback != null) {
                this.getVariableCompiler().getTempLocal(tempLocal);
                this.loadRuntime();
                this.method.pushInt(start2);
                this.invokeUtilityMethod("subarrayOrEmpty", CodegenUtils.sig(RubyArray.class, RubyArray.class, Ruby.class, Integer.TYPE));
                argsCallback.call(this);
            }
            this.getVariableCompiler().getTempLocal(tempLocal);
            this.getVariableCompiler().releaseTempLocal();
        }
    }

    @Override
    public void forEachInValueArray(int start2, int preCount, Object preSource, int postCount, Object postSource, ArrayCallback callback, CompilerCallback argsCallback) {
        if (start2 < preCount || argsCallback != null) {
            int tempLocal = this.getVariableCompiler().grabTempLocal();
            this.getVariableCompiler().setTempLocal(tempLocal);
            while (start2 < preCount) {
                this.getVariableCompiler().getTempLocal(tempLocal);
                switch (start2) {
                    case 0: {
                        this.invokeUtilityMethod("arrayEntryOrNilZero", CodegenUtils.sig(IRubyObject.class, RubyArray.class));
                        break;
                    }
                    case 1: {
                        this.invokeUtilityMethod("arrayEntryOrNilOne", CodegenUtils.sig(IRubyObject.class, RubyArray.class));
                        break;
                    }
                    case 2: {
                        this.invokeUtilityMethod("arrayEntryOrNilTwo", CodegenUtils.sig(IRubyObject.class, RubyArray.class));
                        break;
                    }
                    default: {
                        this.method.pushInt(start2);
                        this.invokeUtilityMethod("arrayEntryOrNil", CodegenUtils.sig(IRubyObject.class, RubyArray.class, Integer.TYPE));
                    }
                }
                callback.nextValue(this, preSource, start2);
                ++start2;
            }
            if (argsCallback != null) {
                this.getVariableCompiler().getTempLocal(tempLocal);
                this.loadRuntime();
                this.method.pushInt(start2);
                this.invokeUtilityMethod("subarrayOrEmpty", CodegenUtils.sig(RubyArray.class, RubyArray.class, Ruby.class, Integer.TYPE));
                argsCallback.call(this);
            }
            if (postCount > 0) {
                throw new NotCompilableException("1.9 mode can't handle post variables in masgn yet");
            }
            this.getVariableCompiler().getTempLocal(tempLocal);
            this.getVariableCompiler().releaseTempLocal();
        }
    }

    @Override
    public void asString() {
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
    }

    @Override
    public void toJavaString() {
        this.method.invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
    }

    @Override
    public void nthRef(int match2) {
        this.method.pushInt(match2);
        this.backref();
        this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "nth_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
    }

    @Override
    public void match() {
        this.loadThreadContext();
        this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match2", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
    }

    @Override
    public void match2(CompilerCallback value2) {
        this.loadThreadContext();
        value2.call(this);
        this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
    }

    @Override
    public void match3() {
        this.loadThreadContext();
        this.invokeUtilityMethod("match3", CodegenUtils.sig(IRubyObject.class, RubyRegexp.class, IRubyObject.class, ThreadContext.class));
    }

    @Override
    public void createNewRegexp(ByteList value2, int options2) {
        this.script.getCacheCompiler().cacheRegexp(this, value2.toString(), options2);
    }

    @Override
    public void createNewRegexp(CompilerCallback createStringCallback, int options2) {
        boolean onceOnly;
        boolean bl = onceOnly = (options2 & 0x80) != 0;
        if (onceOnly) {
            this.script.getCacheCompiler().cacheDRegexp(this, createStringCallback, options2);
        } else {
            this.loadRuntime();
            createStringCallback.call(this);
            this.method.pushInt(options2);
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newDRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, RubyString.class, Integer.TYPE)));
        }
    }

    @Override
    public void pollThreadEvents() {
        if (!RubyInstanceConfig.THREADLESS_COMPILE_ENABLED) {
            this.loadThreadContext();
            this.invokeThreadContext("pollThreadEvents", CodegenUtils.sig(Void.TYPE, new Class[0]));
        }
    }

    @Override
    public void nullToNil() {
        Label notNull = new Label();
        this.method.dup();
        this.method.ifnonnull(notNull);
        this.method.pop();
        this.loadNil();
        this.method.label(notNull);
    }

    @Override
    public void isInstanceOf(Class clazz, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.method.instance_of(CodegenUtils.p(clazz));
        Label falseJmp = new Label();
        Label afterJmp = new Label();
        this.method.ifeq(falseJmp);
        trueBranch.branch(this);
        this.method.go_to(afterJmp);
        this.method.label(falseJmp);
        falseBranch.branch(this);
        this.method.label(afterJmp);
    }

    @Override
    public void isCaptured(final int number, final BranchCallback trueBranch, final BranchCallback falseBranch) {
        this.backref();
        this.method.dup();
        this.isInstanceOf(RubyMatchData.class, new BranchCallback(){

            public void branch(BodyCompiler context) {
                BaseBodyCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyMatchData.class));
                BaseBodyCompiler.this.method.pushInt(number);
                BaseBodyCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "group", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE)));
                BaseBodyCompiler.this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                Label isNil = new Label();
                Label after = new Label();
                BaseBodyCompiler.this.method.ifne(isNil);
                trueBranch.branch(context);
                BaseBodyCompiler.this.method.go_to(after);
                BaseBodyCompiler.this.method.label(isNil);
                falseBranch.branch(context);
                BaseBodyCompiler.this.method.label(after);
            }
        }, new BranchCallback(){

            public void branch(BodyCompiler context) {
                BaseBodyCompiler.this.method.pop();
                falseBranch.branch(context);
            }
        });
    }

    @Override
    public void backref() {
        this.loadRuntime();
        this.loadThreadContext();
        this.invokeUtilityMethod("getBackref", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class));
    }

    @Override
    public void backrefMethod(String methodName) {
        this.backref();
        this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), methodName, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void issueLoopBreak() {
        this.method.go_to(this.currentLoopLabels[2]);
    }

    public void issueLoopNext() {
        this.method.go_to(this.currentLoopLabels[0]);
    }

    public void issueLoopRedo() {
        this.method.go_to(this.currentLoopLabels[1]);
    }

    protected String getNewEnsureName() {
        return "ensure_" + this.script.getAndIncrementEnsureNumber() + "$RUBY$__ensure__";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void protect(BranchCallback regularCode, BranchCallback protectedCode, Class ret) {
        String mname = this.getNewEnsureName();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4105, mname, CodegenUtils.sig(ret, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject.class, Block.class), null, null));
        SkinnyMethodAdapter old_method = null;
        SkinnyMethodAdapter var_old_method = null;
        SkinnyMethodAdapter inv_old_method = null;
        boolean oldInNestedMethod = this.inNestedMethod;
        this.inNestedMethod = true;
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = null;
        int oldArgCount = this.argParamCount;
        this.argParamCount = 0;
        try {
            old_method = this.method;
            var_old_method = this.getVariableCompiler().getMethodAdapter();
            inv_old_method = this.getInvocationCompiler().getMethodAdapter();
            this.method = mv;
            this.getVariableCompiler().setMethodAdapter(mv);
            this.getInvocationCompiler().setMethodAdapter(mv);
            mv.visitCode();
            mv.aload(1);
            mv.dup();
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            mv.dup();
            mv.astore(this.getRuntimeIndex());
            mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            mv.astore(this.getNilIndex());
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            mv.dup();
            mv.astore(this.getDynamicScopeIndex());
            mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            mv.astore(this.getVarsArrayIndex());
            Label codeBegin = new Label();
            Label codeEnd = new Label();
            Label ensureBegin = new Label();
            Label ensureEnd = new Label();
            this.method.label(codeBegin);
            regularCode.branch(this);
            this.method.label(codeEnd);
            protectedCode.branch(this);
            mv.areturn();
            this.method.label(ensureBegin);
            this.method.astore(this.getExceptionIndex());
            this.method.label(ensureEnd);
            protectedCode.branch(this);
            this.method.aload(this.getExceptionIndex());
            this.method.athrow();
            this.method.trycatch(codeBegin, codeEnd, ensureBegin, null);
            this.method.trycatch(ensureBegin, ensureEnd, ensureBegin, null);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        finally {
            this.method = old_method;
            this.getVariableCompiler().setMethodAdapter(var_old_method);
            this.getInvocationCompiler().setMethodAdapter(inv_old_method);
            this.inNestedMethod = oldInNestedMethod;
            this.currentLoopLabels = oldLoopLabels;
            this.argParamCount = oldArgCount;
        }
        this.method.aload(0);
        this.loadThreadContext();
        this.loadSelf();
        if (this instanceof ChildScopedBodyCompiler) {
            this.pushNull();
        } else {
            this.loadBlock();
        }
        this.method.invokestatic(this.script.getClassname(), mname, CodegenUtils.sig(ret, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject.class, Block.class));
    }

    @Override
    public void performEnsure(BranchCallback regularCode, BranchCallback protectedCode) {
        String mname = this.getNewEnsureName();
        BaseBodyCompiler ensure = this.outline(mname);
        ensure.performEnsureInner(regularCode, protectedCode);
    }

    private void performEnsureInner(BranchCallback regularCode, BranchCallback protectedCode) {
        Label codeBegin = new Label();
        Label codeEnd = new Label();
        Label ensureBegin = new Label();
        Label ensureEnd = new Label();
        this.method.label(codeBegin);
        regularCode.branch(this);
        this.method.label(codeEnd);
        protectedCode.branch(this);
        this.method.areturn();
        this.method.label(ensureBegin);
        this.method.astore(this.getExceptionIndex());
        this.method.label(ensureEnd);
        protectedCode.branch(this);
        this.method.aload(this.getExceptionIndex());
        this.method.athrow();
        this.method.trycatch(codeBegin, codeEnd, ensureBegin, null);
        this.method.trycatch(ensureBegin, ensureEnd, ensureBegin, null);
        this.loadNil();
        this.endBody();
    }

    protected String getNewRescueName() {
        return "rescue_" + this.script.getAndIncrementRescueNumber() + "$RUBY$__rescue__";
    }

    @Override
    public void storeExceptionInErrorInfo() {
        this.loadException();
        this.loadThreadContext();
        this.invokeUtilityMethod("storeExceptionInErrorInfo", CodegenUtils.sig(Void.TYPE, Throwable.class, ThreadContext.class));
    }

    @Override
    public void clearErrorInfo() {
        this.loadThreadContext();
        this.invokeUtilityMethod("clearErrorInfo", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rescue(BranchCallback regularCode, Class exception2, BranchCallback catchCode, Class ret) {
        String mname = this.getNewRescueName();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4105, mname, CodegenUtils.sig(ret, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject.class, Block.class), null, null));
        SkinnyMethodAdapter old_method = null;
        SkinnyMethodAdapter var_old_method = null;
        SkinnyMethodAdapter inv_old_method = null;
        Label afterMethodBody = new Label();
        Label catchRetry = new Label();
        Label catchRaised = new Label();
        Label catchJumps = new Label();
        Label exitRescue = new Label();
        boolean oldWithinProtection = this.inNestedMethod;
        this.inNestedMethod = true;
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = null;
        int oldArgCount = this.argParamCount;
        this.argParamCount = 0;
        try {
            old_method = this.method;
            var_old_method = this.getVariableCompiler().getMethodAdapter();
            inv_old_method = this.getInvocationCompiler().getMethodAdapter();
            this.method = mv;
            this.getVariableCompiler().setMethodAdapter(mv);
            this.getInvocationCompiler().setMethodAdapter(mv);
            mv.start();
            mv.aload(1);
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            mv.astore(this.getRuntimeIndex());
            this.loadThreadContext();
            this.invokeThreadContext("getErrorInfo", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            mv.astore(this.getPreviousExceptionIndex());
            this.loadRuntime();
            mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            mv.astore(this.getNilIndex());
            mv.aload(1);
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            mv.astore(this.getDynamicScopeIndex());
            if (this.scope.getNumberOfVariables() > 4) {
                mv.aload(this.getDynamicScopeIndex());
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                mv.astore(this.getVarsArrayIndex());
            }
            Label beforeBody = new Label();
            Label afterBody = new Label();
            Label catchBlock = new Label();
            mv.trycatch(beforeBody, afterBody, catchBlock, CodegenUtils.p(exception2));
            mv.label(beforeBody);
            regularCode.branch(this);
            mv.label(afterBody);
            mv.go_to(exitRescue);
            mv.label(catchBlock);
            mv.astore(this.getExceptionIndex());
            catchCode.branch(this);
            mv.label(afterMethodBody);
            mv.go_to(exitRescue);
            mv.trycatch(catchBlock, afterMethodBody, catchRetry, CodegenUtils.p(JumpException.RetryJump.class));
            mv.label(catchRetry);
            mv.pop();
            mv.go_to(beforeBody);
            mv.trycatch(beforeBody, afterMethodBody, catchRaised, CodegenUtils.p(RaiseException.class));
            mv.label(catchRaised);
            mv.athrow();
            mv.trycatch(beforeBody, afterMethodBody, catchJumps, CodegenUtils.p(JumpException.class));
            mv.label(catchJumps);
            this.loadThreadContext();
            this.method.aload(this.getPreviousExceptionIndex());
            this.invokeThreadContext("setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            this.method.pop();
            mv.athrow();
            mv.label(exitRescue);
            this.loadThreadContext();
            this.method.aload(this.getPreviousExceptionIndex());
            this.invokeThreadContext("setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            this.method.pop();
            mv.areturn();
            mv.end();
        }
        finally {
            this.inNestedMethod = oldWithinProtection;
            this.method = old_method;
            this.getVariableCompiler().setMethodAdapter(var_old_method);
            this.getInvocationCompiler().setMethodAdapter(inv_old_method);
            this.currentLoopLabels = oldLoopLabels;
            this.argParamCount = oldArgCount;
        }
        this.method.aload(0);
        this.loadThreadContext();
        this.loadSelf();
        if (this instanceof ChildScopedBodyCompiler) {
            this.pushNull();
        } else {
            this.loadBlock();
        }
        this.method.invokestatic(this.script.getClassname(), mname, CodegenUtils.sig(ret, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject.class, Block.class));
    }

    @Override
    public void performRescue(BranchCallback regularCode, BranchCallback rubyCatchCode, boolean needsRetry) {
        String mname = this.getNewRescueName();
        BaseBodyCompiler rescueMethod = this.outline(mname);
        rescueMethod.performRescueLight(regularCode, rubyCatchCode, needsRetry);
        rescueMethod.endBody();
    }

    @Override
    public void performRescueLight(BranchCallback regularCode, BranchCallback rubyCatchCode, boolean needsRetry) {
        Label afterRubyCatchBody = new Label();
        Label catchRetry = new Label();
        Label catchJumps = new Label();
        Label exitRescue = new Label();
        this.loadThreadContext();
        this.invokeThreadContext("getErrorInfo", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        this.method.astore(this.getPreviousExceptionIndex());
        Label beforeBody = new Label();
        Label afterBody = new Label();
        Label rubyCatchBlock = new Label();
        Label flowCatchBlock = new Label();
        this.method.visitTryCatchBlock(beforeBody, afterBody, flowCatchBlock, CodegenUtils.p(JumpException.FlowControlException.class));
        this.method.visitTryCatchBlock(beforeBody, afterBody, rubyCatchBlock, CodegenUtils.p(Throwable.class));
        this.method.visitLabel(beforeBody);
        regularCode.branch(this);
        this.method.label(afterBody);
        this.method.go_to(exitRescue);
        this.method.label(flowCatchBlock);
        this.method.athrow();
        this.method.label(rubyCatchBlock);
        this.method.astore(this.getExceptionIndex());
        rubyCatchCode.branch(this);
        this.method.label(afterRubyCatchBody);
        this.method.go_to(exitRescue);
        if (needsRetry) {
            this.method.trycatch(rubyCatchBlock, afterRubyCatchBody, catchRetry, CodegenUtils.p(JumpException.RetryJump.class));
            this.method.label(catchRetry);
            this.method.pop();
            this.method.go_to(beforeBody);
        }
        this.method.trycatch(beforeBody, afterRubyCatchBody, catchJumps, CodegenUtils.p(JumpException.FlowControlException.class));
        this.method.label(catchJumps);
        this.loadThreadContext();
        this.method.aload(this.getPreviousExceptionIndex());
        this.invokeThreadContext("setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        this.method.pop();
        this.method.athrow();
        this.method.label(exitRescue);
        this.loadThreadContext();
        this.method.aload(this.getPreviousExceptionIndex());
        this.invokeThreadContext("setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        this.method.pop();
    }

    @Override
    public void wrapJavaException() {
        this.loadRuntime();
        this.loadException();
        this.wrapJavaObject();
    }

    public void wrapJavaObject() {
        this.method.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToUsableRubyObject", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
    }

    @Override
    public void inDefined() {
        this.method.aload(1);
        this.method.iconst_1();
        this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
    }

    @Override
    public void outDefined() {
        this.method.aload(1);
        this.method.iconst_0();
        this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
    }

    @Override
    public void stringOrNil() {
        this.loadRuntime();
        this.loadNil();
        this.invokeUtilityMethod("stringOrNil", CodegenUtils.sig(IRubyObject.class, String.class, Ruby.class, IRubyObject.class));
    }

    @Override
    public void pushNull() {
        this.method.aconst_null();
    }

    @Override
    public void pushString(String str) {
        this.method.ldc(str);
    }

    @Override
    public void isMethodBound(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.metaclass();
        this.method.ldc(name2);
        this.method.iconst_0();
        this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public void hasBlock(BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadBlock();
        this.method.invokevirtual(CodegenUtils.p(Block.class), "isGiven", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public void isGlobalDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadRuntime();
        this.invokeRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "isDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public void isConstantDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadThreadContext();
        this.method.ldc(name2);
        this.invokeThreadContext("getConstantDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public void isInstanceVariableDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadSelf();
        this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastHasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label trueLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifne(trueLabel);
        falseBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(trueLabel);
        trueBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public void isClassVarDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label trueLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifne(trueLabel);
        falseBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(trueLabel);
        trueBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public Object getNewEnding() {
        return new Label();
    }

    @Override
    public void isNil(BranchCallback trueBranch, BranchCallback falseBranch) {
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public void isNull(BranchCallback trueBranch, BranchCallback falseBranch) {
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifnonnull(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    @Override
    public void ifNull(Object gotoToken) {
        this.method.ifnull((Label)gotoToken);
    }

    @Override
    public void ifNotNull(Object gotoToken) {
        this.method.ifnonnull((Label)gotoToken);
    }

    @Override
    public void setEnding(Object endingToken) {
        this.method.label((Label)endingToken);
    }

    @Override
    public void go(Object gotoToken) {
        this.method.go_to((Label)gotoToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void isConstantBranch(final BranchCallback setup, final String name2) {
        BranchCallback catchCode = new BranchCallback(){

            public void branch(BodyCompiler context) {
                BaseBodyCompiler.this.loadThreadContext();
                BaseBodyCompiler.this.method.aload(BaseBodyCompiler.this.getPreviousExceptionIndex());
                BaseBodyCompiler.this.invokeThreadContext("setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                BaseBodyCompiler.this.method.pop();
                BaseBodyCompiler.this.pushNull();
            }
        };
        BranchCallback regularCode = new BranchCallback(){

            public void branch(BodyCompiler context) {
                setup.branch(BaseBodyCompiler.this);
                BaseBodyCompiler.this.method.ldc(name2);
                BaseBodyCompiler.this.invokeUtilityMethod("getDefinedConstantOrBoundMethod", CodegenUtils.sig(String.class, IRubyObject.class, String.class));
            }
        };
        String mname = this.getNewRescueName();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4105, mname, CodegenUtils.sig(String.class, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject.class, Block.class), null, null));
        SkinnyMethodAdapter old_method = null;
        SkinnyMethodAdapter var_old_method = null;
        SkinnyMethodAdapter inv_old_method = null;
        Label exitRescue = new Label();
        boolean oldWithinProtection = this.inNestedMethod;
        this.inNestedMethod = true;
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = null;
        int oldArgCount = this.argParamCount;
        this.argParamCount = 0;
        try {
            old_method = this.method;
            var_old_method = this.getVariableCompiler().getMethodAdapter();
            inv_old_method = this.getInvocationCompiler().getMethodAdapter();
            this.method = mv;
            this.getVariableCompiler().setMethodAdapter(mv);
            this.getInvocationCompiler().setMethodAdapter(mv);
            mv.start();
            mv.aload(1);
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            mv.astore(this.getRuntimeIndex());
            this.loadThreadContext();
            this.invokeThreadContext("getErrorInfo", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            mv.astore(this.getPreviousExceptionIndex());
            this.loadRuntime();
            mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            mv.astore(this.getNilIndex());
            mv.aload(1);
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            mv.astore(this.getDynamicScopeIndex());
            if (this.scope.getNumberOfVariables() > 4) {
                mv.aload(this.getDynamicScopeIndex());
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                mv.astore(this.getVarsArrayIndex());
            }
            Label beforeBody = new Label();
            Label afterBody = new Label();
            Label catchBlock = new Label();
            mv.trycatch(beforeBody, afterBody, catchBlock, CodegenUtils.p(JumpException.class));
            mv.label(beforeBody);
            regularCode.branch(this);
            mv.label(afterBody);
            mv.go_to(exitRescue);
            mv.label(catchBlock);
            mv.astore(this.getExceptionIndex());
            catchCode.branch(this);
            mv.label(exitRescue);
            mv.areturn();
            mv.end();
        }
        finally {
            this.inNestedMethod = oldWithinProtection;
            this.method = old_method;
            this.getVariableCompiler().setMethodAdapter(var_old_method);
            this.getInvocationCompiler().setMethodAdapter(inv_old_method);
            this.currentLoopLabels = oldLoopLabels;
            this.argParamCount = oldArgCount;
        }
        this.method.aload(0);
        this.loadThreadContext();
        this.loadSelf();
        if (this instanceof ChildScopedBodyCompiler) {
            this.pushNull();
        } else {
            this.loadBlock();
        }
        this.method.invokestatic(this.script.getClassname(), mname, CodegenUtils.sig(String.class, "L" + this.script.getClassname() + ";", ThreadContext.class, IRubyObject.class, Block.class));
    }

    @Override
    public void metaclass() {
        this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    @Override
    public void aprintln() {
        this.method.aprintln();
    }

    @Override
    public void getVisibilityFor(String name2) {
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
        this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "getVisibility", CodegenUtils.sig(Visibility.class, new Class[0]));
    }

    @Override
    public void isPrivate(Object gotoToken, int toConsume) {
        this.method.getstatic(CodegenUtils.p(Visibility.class), "PRIVATE", CodegenUtils.ci(Visibility.class));
        Label temp = new Label();
        this.method.if_acmpne(temp);
        while (toConsume-- > 0) {
            this.method.pop();
        }
        this.method.go_to((Label)gotoToken);
        this.method.label(temp);
    }

    @Override
    public void isNotProtected(Object gotoToken, int toConsume) {
        this.method.getstatic(CodegenUtils.p(Visibility.class), "PROTECTED", CodegenUtils.ci(Visibility.class));
        Label temp = new Label();
        this.method.if_acmpeq(temp);
        while (toConsume-- > 0) {
            this.method.pop();
        }
        this.method.go_to((Label)gotoToken);
        this.method.label(temp);
    }

    @Override
    public void selfIsKindOf(Object gotoToken) {
        this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "getRealClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.loadSelf();
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
        this.method.ifne((Label)gotoToken);
    }

    @Override
    public void notIsModuleAndClassVarDefined(String name2, Object gotoToken) {
        this.method.dup();
        this.method.instance_of(CodegenUtils.p(RubyModule.class));
        Label falsePopJmp = new Label();
        Label successJmp = new Label();
        this.method.ifeq(falsePopJmp);
        this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        this.method.ifeq((Label)gotoToken);
        this.method.go_to(successJmp);
        this.method.label(falsePopJmp);
        this.method.pop();
        this.method.go_to((Label)gotoToken);
        this.method.label(successJmp);
    }

    @Override
    public void ifSingleton(Object gotoToken) {
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isSingleton", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifne((Label)gotoToken);
    }

    @Override
    public void getInstanceVariable(String name2) {
        this.method.ldc(name2);
        this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
        this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
    }

    @Override
    public void getFrameName() {
        this.loadThreadContext();
        this.invokeThreadContext("getFrameName", CodegenUtils.sig(String.class, new Class[0]));
    }

    @Override
    public void getFrameKlazz() {
        this.loadThreadContext();
        this.invokeThreadContext("getFrameKlazz", CodegenUtils.sig(RubyModule.class, new Class[0]));
    }

    @Override
    public void superClass() {
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "getSuperClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    @Override
    public void attached() {
        this.method.visitTypeInsn(192, CodegenUtils.p(MetaClass.class));
        this.method.invokevirtual(CodegenUtils.p(MetaClass.class), "getAttached", CodegenUtils.sig(IRubyObject.class, new Class[0]));
    }

    @Override
    public void ifNotSuperMethodBound(Object token) {
        this.method.swap();
        this.method.iconst_0();
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
        this.method.ifeq((Label)token);
    }

    @Override
    public void concatArrays() {
        this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "concat", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void concatObjectArrays() {
        this.invokeUtilityMethod("concatObjectArrays", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject[].class)));
    }

    @Override
    public void appendToArray() {
        this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "append", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void appendToObjectArray() {
        this.invokeUtilityMethod("appendToObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class)));
    }

    @Override
    public void convertToJavaArray() {
        this.method.invokestatic(CodegenUtils.p(ArgsUtil.class), "convertToJavaArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void aliasGlobal(String newName, String oldName) {
        this.loadRuntime();
        this.invokeRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
        this.method.ldc(newName);
        this.method.ldc(oldName);
        this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
        this.loadNil();
    }

    @Override
    public void raiseTypeError(String msg) {
        this.loadRuntime();
        this.method.ldc(msg);
        this.invokeRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
        this.method.athrow();
    }

    @Override
    public void undefMethod(CompilerCallback nameArg) {
        this.loadThreadContext();
        nameArg.call(this);
        this.invokeUtilityMethod("undefMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class));
    }

    @Override
    public void defineClass(final String name2, final StaticScope staticScope, final CompilerCallback superCallback, final CompilerCallback pathCallback, CompilerCallback bodyCallback, final CompilerCallback receiverCallback, final ASTInspector inspector) {
        String classMethodName = null;
        if (receiverCallback == null) {
            String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name2);
            classMethodName = "class_" + this.script.getAndIncrementMethodIndex() + "$RUBY$" + mangledName;
        } else {
            classMethodName = "sclass_" + this.script.getAndIncrementMethodIndex() + "$RUBY$__singleton__";
        }
        final ClassBodyCompiler classBody = new ClassBodyCompiler(this.script, classMethodName, inspector, staticScope);
        CompilerCallback bodyPrep = new CompilerCallback(){

            public void call(BodyCompiler context) {
                if (receiverCallback == null) {
                    if (superCallback != null) {
                        classBody.loadRuntime();
                        classBody.method.aload(2);
                        classBody.invokeUtilityMethod("prepareSuperClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                    } else {
                        classBody.method.aconst_null();
                    }
                    classBody.loadThreadContext();
                    pathCallback.call(classBody);
                    classBody.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                    classBody.method.swap();
                    classBody.method.ldc(name2);
                    classBody.method.swap();
                    classBody.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetClassUnder", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(String.class, RubyClass.class)));
                } else {
                    classBody.loadRuntime();
                    classBody.method.aload(2);
                    int selfTemp = classBody.getVariableCompiler().grabTempLocal();
                    classBody.getVariableCompiler().setTempLocal(selfTemp);
                    classBody.method.aload(2);
                    classBody.invokeUtilityMethod("getSingletonClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                }
                classBody.method.dup();
                classBody.method.astore(2);
                classBody.loadThreadContext();
                classBody.method.swap();
                BaseBodyCompiler.this.script.getCacheCompiler().cacheStaticScope(classBody, staticScope);
                if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                    classBody.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, StaticScope.class)));
                } else {
                    classBody.invokeThreadContext("preCompiledClassDummyScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, StaticScope.class)));
                }
                if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                    classBody.traceClass();
                }
            }
        };
        Label start2 = new Label();
        Label end2 = new Label();
        Label after = new Label();
        Label noException = new Label();
        classBody.method.trycatch(start2, end2, after, null);
        ((RootScopedBodyCompiler)classBody).beginMethod(bodyPrep, staticScope);
        classBody.method.label(start2);
        bodyCallback.call(classBody);
        classBody.method.label(end2);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            classBody.traceEnd();
        }
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.method.go_to(noException);
        classBody.method.label(after);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            classBody.traceEnd();
        }
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.method.athrow();
        classBody.method.label(noException);
        classBody.endBody();
        this.method.aload(0);
        this.loadThreadContext();
        if (receiverCallback == null) {
            if (superCallback != null) {
                superCallback.call(this);
            } else {
                this.method.aload(2);
            }
        } else {
            receiverCallback.call(this);
        }
        this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        this.method.invokestatic(this.script.getClassname(), classMethodName, StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), 0));
    }

    @Override
    public void defineModule(final String name2, final StaticScope staticScope, final CompilerCallback pathCallback, CompilerCallback bodyCallback, final ASTInspector inspector) {
        String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name2);
        String moduleMethodName = "module__" + this.script.getAndIncrementMethodIndex() + "$RUBY$" + mangledName;
        final ClassBodyCompiler classBody = new ClassBodyCompiler(this.script, moduleMethodName, inspector, staticScope);
        CompilerCallback bodyPrep = new CompilerCallback(){

            public void call(BodyCompiler context) {
                classBody.loadThreadContext();
                pathCallback.call(classBody);
                classBody.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                classBody.method.ldc(name2);
                classBody.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(String.class)));
                classBody.method.dup();
                classBody.method.astore(2);
                classBody.loadThreadContext();
                classBody.method.swap();
                BaseBodyCompiler.this.script.getCacheCompiler().cacheStaticScope(classBody, staticScope);
                if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                    classBody.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, StaticScope.class)));
                } else {
                    classBody.invokeThreadContext("preCompiledClassDummyScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, StaticScope.class)));
                }
                if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                    classBody.traceClass();
                }
            }
        };
        Label start2 = new Label();
        Label end2 = new Label();
        Label after = new Label();
        Label noException = new Label();
        classBody.method.trycatch(start2, end2, after, null);
        ((RootScopedBodyCompiler)classBody).beginMethod(bodyPrep, staticScope);
        classBody.method.label(start2);
        bodyCallback.call(classBody);
        classBody.method.label(end2);
        classBody.method.go_to(noException);
        classBody.method.label(after);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            classBody.traceEnd();
        }
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.method.athrow();
        classBody.method.label(noException);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            classBody.traceEnd();
        }
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.endBody();
        this.method.aload(0);
        this.loadThreadContext();
        this.loadSelf();
        this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        this.method.invokestatic(this.script.getClassname(), moduleMethodName, StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), 4));
    }

    @Override
    public void unwrapPassedBlock() {
        this.loadBlock();
        this.invokeUtilityMethod("getBlockFromBlockPassBody", CodegenUtils.sig(Block.class, CodegenUtils.params(IRubyObject.class, Block.class)));
    }

    @Override
    public void performBackref(char type2) {
        this.loadThreadContext();
        switch (type2) {
            case '~': {
                this.invokeUtilityMethod("backref", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '&': {
                this.invokeUtilityMethod("backrefLastMatch", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '`': {
                this.invokeUtilityMethod("backrefMatchPre", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '\'': {
                this.invokeUtilityMethod("backrefMatchPost", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '+': {
                this.invokeUtilityMethod("backrefMatchLast", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            default: {
                throw new NotCompilableException("ERROR: backref with invalid type");
            }
        }
    }

    @Override
    public void callZSuper(CompilerCallback closure) {
        ArgumentsCallback argsCallback = new ArgumentsCallback(){

            public int getArity() {
                return -1;
            }

            public void call(BodyCompiler context) {
                BaseBodyCompiler.this.loadThreadContext();
                BaseBodyCompiler.this.invokeUtilityMethod("getArgValues", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class));
            }
        };
        this.getInvocationCompiler().invokeDynamic(null, null, argsCallback, CallType.SUPER, closure, false);
    }

    @Override
    public void checkIsExceptionHandled(ArgumentsCallback rescueArgs) {
        rescueArgs.call(this);
        this.loadThreadContext();
        switch (rescueArgs.getArity()) {
            case 1: {
                this.invokeUtilityMethod("isJavaExceptionHandled", CodegenUtils.sig(IRubyObject.class, Throwable.class, IRubyObject.class, ThreadContext.class));
                break;
            }
            case 2: {
                this.invokeUtilityMethod("isJavaExceptionHandled", CodegenUtils.sig(IRubyObject.class, Throwable.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
                break;
            }
            case 3: {
                this.invokeUtilityMethod("isJavaExceptionHandled", CodegenUtils.sig(IRubyObject.class, Throwable.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
                break;
            }
            default: {
                this.invokeUtilityMethod("isJavaExceptionHandled", CodegenUtils.sig(IRubyObject.class, Throwable.class, IRubyObject[].class, ThreadContext.class));
            }
        }
    }

    @Override
    public void rethrowException() {
        this.loadException();
        this.method.athrow();
    }

    @Override
    public void loadClass(String name2) {
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeRuby("getClass", CodegenUtils.sig(RubyClass.class, String.class));
    }

    @Override
    public void loadStandardError() {
        this.loadRuntime();
        this.invokeRuby("getStandardError", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    @Override
    public void unwrapRaiseException() {
        this.method.invokevirtual(CodegenUtils.p(RaiseException.class), "getException", CodegenUtils.sig(RubyException.class, new Class[0]));
    }

    @Override
    public void loadException() {
        this.method.aload(this.getExceptionIndex());
    }

    @Override
    public void setFilePosition(ISourcePosition position) {
        if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
            this.loadThreadContext();
            this.method.ldc(position.getFile());
            this.invokeThreadContext("setFile", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class)));
        }
    }

    @Override
    public void setLinePosition(ISourcePosition position) {
        if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
            if (this.lastPositionLine == position.getStartLine()) {
                return;
            }
            this.lastPositionLine = position.getStartLine();
            this.loadThreadContext();
            this.method.pushInt(position.getStartLine());
            this.method.invokestatic(this.script.getClassname(), "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)));
        }
    }

    @Override
    public void checkWhenWithSplat() {
        this.loadThreadContext();
        this.invokeUtilityMethod("isWhenTriggered", CodegenUtils.sig(RubyBoolean.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
    }

    @Override
    public void issueRetryEvent() {
        this.invokeUtilityMethod("retryJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
    }

    @Override
    public void defineNewMethod(String name2, int methodArity, StaticScope scope, CompilerCallback body, CompilerCallback args2, CompilerCallback receiver2, ASTInspector inspector, boolean root, String filename2, int line) {
        String newMethodName;
        if (root && SafePropertyAccessor.getBoolean("jruby.compile.toplevel", false)) {
            newMethodName = name2;
        } else {
            String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name2);
            newMethodName = "method__" + this.script.getAndIncrementMethodIndex() + "$RUBY$" + mangledName;
        }
        BodyCompiler methodCompiler = this.script.startMethod(name2, newMethodName, args2, scope, inspector);
        body.call(methodCompiler);
        methodCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        if (receiver2 != null) {
            receiver2.call(this);
        }
        this.method.aload(0);
        this.method.ldc(name2);
        this.method.ldc(newMethodName);
        StandardASMCompiler.buildStaticScopeNames(this.method, scope);
        this.method.pushInt(methodArity);
        this.method.pushInt(scope.getRequiredArgs());
        this.method.pushInt(scope.getOptionalArgs());
        this.method.pushInt(scope.getRestArg());
        this.method.ldc(filename2);
        this.method.ldc(line);
        this.method.getstatic(CodegenUtils.p(CallConfiguration.class), inspector.getCallConfig().name(), CodegenUtils.ci(CallConfiguration.class));
        if (receiver2 != null) {
            this.invokeUtilityMethod("defs", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE, CallConfiguration.class)));
        } else {
            this.invokeUtilityMethod("def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE, CallConfiguration.class)));
        }
        this.script.addInvokerDescriptor(newMethodName, methodArity, scope, inspector.getCallConfig(), filename2, line);
    }

    @Override
    public void rethrowIfSystemExit() {
        this.loadRuntime();
        this.method.ldc("SystemExit");
        this.method.invokevirtual(CodegenUtils.p(Ruby.class), "fastGetClass", CodegenUtils.sig(RubyClass.class, String.class));
        this.method.swap();
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
        this.method.iconst_0();
        Label ifEnd = new Label();
        this.method.if_icmpeq(ifEnd);
        this.loadException();
        this.method.athrow();
        this.method.label(ifEnd);
    }

    @Override
    public void literalSwitch(int[] cases, Object[] bodies, ArrayCallback arrayCallback, CompilerCallback defaultCallback) {
        this.method.checkcast(CodegenUtils.p(RubyFixnum.class));
        this.method.invokevirtual(CodegenUtils.p(RubyFixnum.class), "getLongValue", CodegenUtils.sig(Long.TYPE, new Class[0]));
        this.method.l2i();
        HashMap<Object, Label> labelMap = new HashMap<Object, Label>();
        Label[] labels = new Label[cases.length];
        for (int i = 0; i < labels.length; ++i) {
            Object body = bodies[i];
            Label label = (Label)labelMap.get(body);
            if (label == null) {
                label = new Label();
                labelMap.put(body, label);
            }
            labels[i] = label;
        }
        Label defaultLabel = new Label();
        Label endLabel = new Label();
        this.method.lookupswitch(defaultLabel, cases, labels);
        HashSet<Label> labelDone = new HashSet<Label>();
        for (int i = 0; i < cases.length; ++i) {
            if (labelDone.contains(labels[i])) continue;
            labelDone.add(labels[i]);
            this.method.label(labels[i]);
            arrayCallback.nextValue(this, bodies, i);
            this.method.go_to(endLabel);
        }
        this.method.label(defaultLabel);
        defaultCallback.call(this);
        this.method.label(endLabel);
    }

    @Override
    public void typeCheckBranch(Class type2, BranchCallback trueCallback, BranchCallback falseCallback) {
        Label elseLabel = new Label();
        Label done = new Label();
        this.method.dup();
        this.method.instance_of(CodegenUtils.p(type2));
        this.method.ifeq(elseLabel);
        trueCallback.branch(this);
        this.method.go_to(done);
        this.method.label(elseLabel);
        falseCallback.branch(this);
        this.method.label(done);
    }

    @Override
    public void loadFilename() {
        this.loadRuntime();
        this.loadThis();
        this.method.getfield(this.getScriptCompiler().getClassname(), "filename", CodegenUtils.ci(String.class));
        this.method.invokestatic(CodegenUtils.p(RubyString.class), "newString", CodegenUtils.sig(RubyString.class, Ruby.class, CharSequence.class));
    }

    @Override
    public void compileSequencedConditional(CompilerCallback inputValue, FastSwitchType fastSwitchType, Map<CompilerCallback, int[]> switchCases, List<ArgumentsCallback> conditionals, List<CompilerCallback> bodies, CompilerCallback fallback) {
        HashMap<CompilerCallback, Label> bodyLabels = new HashMap<CompilerCallback, Label>();
        Label defaultCase = new Label();
        Label slowPath = new Label();
        CompilerCallback getCaseValue = null;
        final int tmp = this.getVariableCompiler().grabTempLocal();
        if (inputValue != null) {
            inputValue.call(this);
            this.getVariableCompiler().setTempLocal(tmp);
            getCaseValue = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    BaseBodyCompiler.this.getVariableCompiler().getTempLocal(tmp);
                }
            };
            if (switchCases != null) {
                TreeMap<Integer, Label> optimizedLabels = new TreeMap<Integer, Label>();
                for (Map.Entry<CompilerCallback, int[]> entry : switchCases.entrySet()) {
                    Label lbl = new Label();
                    bodyLabels.put(entry.getKey(), lbl);
                    for (int i : entry.getValue()) {
                        optimizedLabels.put(i, lbl);
                    }
                }
                int[] caseValues = new int[optimizedLabels.size()];
                Label[] caseLabels = new Label[optimizedLabels.size()];
                Set entrySet = optimizedLabels.entrySet();
                Iterator iterator = entrySet.iterator();
                for (int i = 0; i < entrySet.size(); ++i) {
                    Map.Entry entry = iterator.next();
                    caseValues[i] = (Integer)entry.getKey();
                    caseLabels[i] = (Label)entry.getValue();
                }
                getCaseValue.call(this);
                this.method.instance_of(CodegenUtils.p(fastSwitchType.getAssociatedClass()));
                this.method.ifeq(slowPath);
                switch (fastSwitchType) {
                    case FIXNUM: {
                        getCaseValue.call(this);
                        this.method.checkcast(CodegenUtils.p(RubyFixnum.class));
                        this.method.invokevirtual(CodegenUtils.p(RubyFixnum.class), "getLongValue", CodegenUtils.sig(Long.TYPE, new Class[0]));
                        this.method.l2i();
                        break;
                    }
                    case SINGLE_CHAR_STRING: {
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("isFastSwitchableSingleCharString", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                        this.method.ifeq(slowPath);
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("getFastSwitchSingleCharString", CodegenUtils.sig(Integer.TYPE, IRubyObject.class));
                        break;
                    }
                    case STRING: {
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("isFastSwitchableString", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                        this.method.ifeq(slowPath);
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("getFastSwitchString", CodegenUtils.sig(Integer.TYPE, IRubyObject.class));
                        break;
                    }
                    case SINGLE_CHAR_SYMBOL: {
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("isFastSwitchableSingleCharSymbol", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                        this.method.ifeq(slowPath);
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("getFastSwitchSingleCharSymbol", CodegenUtils.sig(Integer.TYPE, IRubyObject.class));
                        break;
                    }
                    case SYMBOL: {
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("isFastSwitchableSymbol", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                        this.method.ifeq(slowPath);
                        getCaseValue.call(this);
                        this.invokeUtilityMethod("getFastSwitchSymbol", CodegenUtils.sig(Integer.TYPE, IRubyObject.class));
                    }
                }
                this.method.lookupswitch(defaultCase, caseValues, caseLabels);
            }
        }
        Label done = new Label();
        Label currentLabel = slowPath;
        for (int i = 0; i < conditionals.size(); ++i) {
            ArgumentsCallback conditional = conditionals.get(i);
            CompilerCallback body = bodies.get(i);
            this.method.label(currentLabel);
            this.getInvocationCompiler().invokeEqq(conditional, getCaseValue);
            currentLabel = i + 1 < conditionals.size() ? new Label() : defaultCase;
            this.method.ifeq(currentLabel);
            Label bodyLabel = (Label)bodyLabels.get(body);
            if (bodyLabel != null) {
                this.method.label(bodyLabel);
            }
            body.call(this);
            this.method.go_to(done);
        }
        this.method.label(currentLabel);
        fallback.call(this);
        this.method.label(done);
        this.getVariableCompiler().releaseTempLocal();
    }

    @Override
    public void traceLine() {
        this.loadThreadContext();
        this.invokeUtilityMethod("traceLine", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
    }

    @Override
    public void traceClass() {
        this.loadThreadContext();
        this.invokeUtilityMethod("traceClass", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
    }

    @Override
    public void traceEnd() {
        this.loadThreadContext();
        this.invokeUtilityMethod("traceEnd", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
    }
}

