/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ProcedureNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ProcedureNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private MetadataElementHandle<Schema> schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ProcedureNodeProvider(Lookup lookup) {
        super(lookup, new ProcedureComparator());
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Schema schema = (Schema)ProcedureNodeProvider.this.schemaHandle.resolve(metaData);
                        if (schema != null) {
                            Collection procedures = schema.getProcedures();
                            for (Procedure procedure : procedures) {
                                MetadataElementHandle handle = MetadataElementHandle.create((MetadataElement)procedure);
                                Collection matches = ProcedureNodeProvider.this.getNodes(handle);
                                if (matches.size() > 0) {
                                    newList.addAll(matches);
                                    continue;
                                }
                                NodeDataLookup lookup = new NodeDataLookup();
                                lookup.add(ProcedureNodeProvider.this.connection);
                                lookup.add(handle);
                                newList.add(ProcedureNode.create(lookup, ProcedureNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    static class ProcedureComparator
    implements Comparator<Node> {
        ProcedureComparator() {
        }

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareToIgnoreCase(model2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ProcedureNodeProvider createInstance(Lookup lookup) {
                ProcedureNodeProvider provider = new ProcedureNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

