/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemAction;
import org.netbeans.modules.ruby.platform.gems.GemListPanel;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.GemRequirement;
import org.netbeans.modules.ruby.rubyproject.RequiredGems;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.GemRequirementDetailsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class GemRequirementsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(GemRequirementsPanel.class.getName());
    private final RubyBaseProject project;
    private final SharedRubyProjectProperties properties;
    private RequiredGems requiredGems;
    private RequiredGems requiredGemsTest;
    private JButton addButton;
    private JButton editButton;
    private JButton gemManagerButton;
    private JTable gemsTable;
    private JTabbedPane jTabbedPane1;
    private JButton removeButton;
    private JScrollPane runScrollPane;
    private JTable testGemsTable;
    private JScrollPane testScrollPane;

    GemRequirementsPanel(RubyBaseProject project, SharedRubyProjectProperties uiProps) {
        this.project = project;
        this.properties = uiProps;
        RequiredGems[] reqs = RequiredGems.lookup(project);
        this.requiredGems = reqs[0];
        this.requiredGemsTest = reqs[1];
        this.requiredGems.setRequiredGems(project.evaluator().getProperty("required.gems"));
        this.requiredGemsTest.setRequiredGems(project.evaluator().getProperty("required.gems.tests"));
        this.initComponents();
        this.enableButtons(true);
    }

    private void enableButtons(boolean enabled) {
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.editButton.setVisible(enabled);
    }

    private DefaultTableModel createTableModel() {
        return this.createTableModelFor(this.requiredGems);
    }

    private DefaultTableModel createTestTableModel() {
        return this.createTableModelFor(this.requiredGemsTest);
    }

    private DefaultTableModel createTableModelFor(RequiredGems requiredGems) {
        List<RequiredGems.GemIndexingStatus> gems = requiredGems.getGemIndexingStatuses();
        if (gems == null) {
            return this.createTableModelWithDefaultGems();
        }
        GemManager gemManager = this.getGemManager();
        Object[][] data = new Object[gems.size()][3];
        for (int i = 0; i < gems.size(); ++i) {
            RequiredGems.GemIndexingStatus indexedGem = gems.get(i);
            data[i][0] = indexedGem.getRequirement().getName();
            data[i][1] = indexedGem.getRequirement().getVersionRequirement();
            String indexedVersion = indexedGem.getIndexedVersion();
            if (indexedVersion == null) {
                indexedVersion = gemManager.getLatestVersion(indexedGem.getRequirement().getName());
            }
            data[i][2] = indexedVersion != null ? indexedVersion : NbBundle.getMessage(GemRequirementsPanel.class, (String)"NoVersionInstalled");
        }
        NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title0");
        return new DefaultTableModel(data, new Object[]{NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title0"), NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title1"), NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title2")});
    }

    private DefaultTableModel createTableModelWithDefaultGems() {
        RubyPlatform platform = this.project.getPlatform();
        if (platform == null) {
            return new DefaultTableModel();
        }
        GemManager gemManager = platform.getGemManager();
        if (gemManager == null) {
            return null;
        }
        List gems = gemManager.getInstalledGems(new ArrayList());
        Object[][] data = new Object[gems.size()][3];
        for (int i = 0; i < gems.size(); ++i) {
            Gem gem = (Gem)gems.get(i);
            data[i][0] = gem.getName();
            data[i][1] = "";
            data[i][2] = gemManager.getLatestVersion(gem.getName());
        }
        return new DefaultTableModel(data, new Object[]{NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title0"), NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title1"), NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title2")});
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.runScrollPane = new JScrollPane();
        this.gemsTable = new JTable();
        this.testScrollPane = new JScrollPane();
        this.testGemsTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.gemManagerButton = new JButton();
        this.gemsTable.setModel(this.createTableModel());
        this.gemsTable.getTableHeader().setReorderingAllowed(false);
        this.runScrollPane.setViewportView(this.gemsTable);
        this.gemsTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title0"));
        this.gemsTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title1"));
        this.gemsTable.getColumnModel().getColumn(2).setHeaderValue(NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemsTable.columnModel.title2"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.runScrollPane.TabConstraints.tabTitle"), this.runScrollPane);
        this.testGemsTable.setModel(this.createTestTableModel());
        this.testScrollPane.setViewportView(this.testGemsTable);
        this.jTabbedPane1.addTab(NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.testScrollPane.TabConstraints.tabTitle"), this.testScrollPane);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GemRequirementsPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GemRequirementsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.editButton.text"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GemRequirementsPanel.this.editButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.gemManagerButton, (String)NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.gemManagerButton.text"));
        this.gemManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GemRequirementsPanel.this.gemManagerButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTabbedPane1, -2, 403, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.removeButton, -1, 108, Short.MAX_VALUE).add((Component)this.gemManagerButton, -2, 108, Short.MAX_VALUE).add(1, (Component)this.editButton, -1, 108, Short.MAX_VALUE).add(1, (Component)this.addButton, -1, 108, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTabbedPane1, -1, 273, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(43, 43, 43).add((Component)this.addButton).addPreferredGap(0).add((Component)this.editButton).addPreferredGap(0).add((Component)this.removeButton).addPreferredGap(0, 114, Short.MAX_VALUE).add((Component)this.gemManagerButton))).addContainerGap()));
    }

    private JTable getSelectedTable() {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            return this.gemsTable;
        }
        return this.testGemsTable;
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] rows;
        JTable selected = this.getSelectedTable();
        DefaultTableModel model = (DefaultTableModel)selected.getModel();
        for (int row : rows = selected.getSelectedRows()) {
            String name = (String)model.getValueAt(row, 0);
            this.getSelectedRequiredGems().removeRequirement(name);
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            model.removeRow(rows[i]);
        }
    }

    private RequiredGems getSelectedRequiredGems() {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            return this.requiredGems;
        }
        return this.requiredGemsTest;
    }

    private GemManager getGemManager() {
        return this.project.getPlatform().getGemManager();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        AtomicBoolean cancelled = new AtomicBoolean();
        final ArrayList gems = new ArrayList();
        Runnable fetchGemsTask = new Runnable(){

            @Override
            public void run() {
                GemManager gemManager = GemRequirementsPanel.this.getGemManager();
                if (gemManager == null) {
                    return;
                }
                gems.addAll(gemManager.getInstalledGems(new ArrayList()));
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)fetchGemsTask, (String)NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.fetchGems"), (AtomicBoolean)cancelled, (boolean)true);
        if (cancelled.get()) {
            return;
        }
        GemListPanel gemListPanel = new GemListPanel(gems);
        DialogDescriptor dd = new DialogDescriptor((Object)gemListPanel, NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementsPanel.chooseGems"));
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(GemRequirementsPanel.class));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(NotifyDescriptor.OK_OPTION)) {
            ArrayList<GemRequirement> reqsToAdd = new ArrayList<GemRequirement>();
            for (Gem each : gemListPanel.getSelectedGems()) {
                reqsToAdd.add(GemRequirement.forGem(each));
            }
            this.getSelectedRequiredGems().addRequirements(reqsToAdd);
            this.getSelectedTable().setModel(this.createTableModel());
        }
    }

    private void gemManagerButtonActionPerformed(ActionEvent evt) {
        GemAction.showGemManager((RubyPlatform)this.project.getPlatform(), (boolean)false);
    }

    private String[] getSelection() {
        JTable table = this.getSelectedTable();
        int index = table.getSelectedRow();
        if (index == -1) {
            return null;
        }
        String[] result = new String[]{(String)table.getValueAt(index, 0), (String)table.getValueAt(index, 1), (String)table.getValueAt(index, 2)};
        return result;
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        String[] selected = this.getSelection();
        if (selected == null) {
            return;
        }
        GemRequirementDetailsPanel panel = new GemRequirementDetailsPanel(this.getGemManager(), selected[0], selected[1], selected[2]);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(GemRequirementsPanel.class, (String)"GemRequirementDetailsPanel.title", (Object)selected[0]));
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(GemRequirementsPanel.class));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(NotifyDescriptor.OK_OPTION)) {
            GemRequirement req = panel.getGemRequirement();
            this.getSelectedRequiredGems().removeRequirement(req.getName());
            this.getSelectedRequiredGems().addRequirements(Collections.singleton(req));
            this.getSelectedTable().setModel(this.createTableModel());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.properties.setGemRequirements(this.requiredGems.getGemRequirements());
        this.properties.setGemRequirementsForTests(this.requiredGemsTest.getGemRequirements());
    }
}

