/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class TreeRootNode
extends FilterNode
implements PropertyChangeListener {
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
    private final SourceGroup g;
    private static final Image PACKAGE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/rubyproject/ui/packageBadge.gif");

    public TreeRootNode(SourceGroup g) {
        this(DataFolder.findFolder((FileObject)g.getRootFolder()), g);
    }

    private TreeRootNode(DataFolder folder, SourceGroup g) {
        this((Node)new FilterNode(folder.getNodeDelegate(), folder.createNodeChildren(VISIBILITY_QUERY_FILTER)), g);
    }

    private TreeRootNode(Node originalNode, SourceGroup g) {
        super(originalNode, (Children)new PackageFilterChildren(originalNode), (Lookup)new ProxyLookup(new Lookup[]{originalNode.getLookup(), Lookups.singleton((Object)new PathFinder(g))}));
        this.g = g;
        g.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)g));
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = this.g.getIcon(opened);
        if (icon == null) {
            Image image = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            return ImageUtilities.mergeImages((Image)image, (Image)PACKAGE_BADGE, (int)7, (int)7);
        }
        return ImageUtilities.icon2Image((Icon)icon);
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public String getName() {
        return this.g.getName();
    }

    public String getDisplayName() {
        return this.g.getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    private static final class PackageFilterChildren
    extends FilterNode.Children {
        public PackageFilterChildren(Node originalNode) {
            super(originalNode);
        }

        protected Node copyNode(Node originalNode) {
            DataObject dobj = (DataObject)originalNode.getLookup().lookup(DataObject.class);
            return dobj instanceof DataFolder ? new FilterNode(originalNode, (Children)new PackageFilterChildren(originalNode)) : super.copyNode(originalNode);
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private static final long serialVersionUID = 1L;
        private final EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(ChangeListener.class, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(ChangeListener.class, listener);
        }
    }

    public static final class PathFinder {
        private final SourceGroup g;

        PathFinder(SourceGroup g) {
            this.g = g;
        }

        public Node findPath(Node rootNode, Object o) {
            FileObject fo;
            if (o instanceof FileObject) {
                fo = (FileObject)o;
            } else if (o instanceof DataObject) {
                fo = ((DataObject)o).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                FileObject folder = fo.isFolder() ? fo : fo.getParent();
                String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)folder);
                ArrayList<String> path = new ArrayList<String>();
                StringTokenizer strtok = new StringTokenizer(relPath, "/");
                while (strtok.hasMoreTokens()) {
                    String token = strtok.nextToken();
                    path.add(token);
                }
                try {
                    Node folderNode;
                    Node node = folderNode = folder.equals(groupRoot) ? rootNode : NodeOp.findPath((Node)rootNode, Collections.enumeration(path));
                    if (fo.isFolder()) {
                        return folderNode;
                    }
                    Node[] childs = folderNode.getChildren().getNodes(true);
                    for (int i = 0; i < childs.length; ++i) {
                        DataObject dobj = (DataObject)childs[i].getLookup().lookup(DataObject.class);
                        if (dobj == null || !dobj.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
                        return childs[i];
                    }
                }
                catch (NodeNotFoundException e) {
                    e.printStackTrace();
                }
            } else if (groupRoot.equals(fo)) {
                return rootNode;
            }
            return null;
        }
    }
}

