/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.rubyproject.templates.NewRubyFileWizardIterator;
import org.netbeans.modules.ruby.rubyproject.templates.RubyTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RubyTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private static final String FOLDER_TO_DELETE = "folderToDelete";
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private RubyTargetChooserPanelGUI gui;
    private final WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private final Project project;
    private final SourceGroup[] folders;
    private final NewRubyFileWizardIterator.Type type;

    public RubyTargetChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, NewRubyFileWizardIterator.Type type) {
        this.project = project;
        this.folders = folders;
        this.bottomPanel = bottomPanel;
        this.type = type;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new RubyTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.type);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx bottomHelp;
        if (this.bottomPanel != null && (bottomHelp = this.bottomPanel.getHelp()) != null) {
            return bottomHelp;
        }
        return null;
    }

    public boolean isValid() {
        String msg;
        if (this.gui == null || this.gui.getTargetName() == null) {
            this.setErrorMessage(null);
            return false;
        }
        this.setLocalizedErrorMessage(null);
        if (this.type == NewRubyFileWizardIterator.Type.SPEC) {
            if (this.gui.getClassName() == null || !RubyUtils.isValidConstantName((String)this.gui.getClassName())) {
                this.setErrorMessage("ERR_RubyTargetChooser_InvalidClass");
                return false;
            }
            msg = RubyUtils.getIdentifierWarning((String)this.gui.getClassName(), (int)0);
            if (msg != null) {
                this.setLocalizedErrorMessage(msg);
            }
        } else if (this.type == NewRubyFileWizardIterator.Type.CLASS || this.type == NewRubyFileWizardIterator.Type.MODULE || this.type == NewRubyFileWizardIterator.Type.TEST) {
            String in;
            if (this.type == NewRubyFileWizardIterator.Type.CLASS || this.type == NewRubyFileWizardIterator.Type.TEST) {
                String superclass;
                if (this.gui.getClassName() == null || !RubyUtils.isValidConstantName((String)this.gui.getClassName())) {
                    this.setErrorMessage("ERR_RubyTargetChooser_InvalidClass");
                    return false;
                }
                msg = RubyUtils.getIdentifierWarning((String)this.gui.getClassName(), (int)0);
                if (msg != null) {
                    this.setLocalizedErrorMessage(msg);
                }
                if ((superclass = this.gui.getExtends()) != null && superclass.length() > 0) {
                    String[] mods;
                    for (String mod : mods = superclass.split("::")) {
                        if (!RubyUtils.isValidConstantName((String)mod)) {
                            this.setErrorMessage("ERR_RubyTargetChooser_InvalidSuperclass");
                            return false;
                        }
                        msg = RubyUtils.getIdentifierWarning((String)mod, (int)0);
                        if (msg == null) continue;
                        this.setLocalizedErrorMessage(msg);
                    }
                }
            }
            if (this.type == NewRubyFileWizardIterator.Type.MODULE) {
                if (this.gui.getClassName() == null || !RubyUtils.isValidConstantName((String)this.gui.getClassName())) {
                    this.setErrorMessage("ERR_RubyTargetChooser_InvalidModule");
                    return false;
                }
                msg = RubyUtils.getIdentifierWarning((String)this.gui.getClassName(), (int)0);
                if (msg != null) {
                    this.setLocalizedErrorMessage(msg);
                }
            }
            if ((in = this.gui.getModuleName()) != null && in.length() > 0) {
                String[] mods;
                for (String mod : mods = in.split("::")) {
                    if (!RubyUtils.isValidConstantName((String)mod)) {
                        this.setErrorMessage("ERR_RubyTargetChooser_InvalidInModule");
                        return false;
                    }
                    String msg2 = RubyUtils.getIdentifierWarning((String)mod, (int)0);
                    if (msg2 == null) continue;
                    this.setLocalizedErrorMessage(msg2);
                }
            }
        }
        if (!RubyTargetChooserPanel.isValidFileName(this.gui.getTargetName())) {
            this.setErrorMessage("ERR_RubyTargetChooser_InvalidFilename");
            return false;
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        boolean returnValue = true;
        String errorMessage = RubyTargetChooserPanel.canUseFileName(this.gui.getTargetFolder(), this.gui.getTargetName(), template.getExt());
        if (this.gui != null && errorMessage != null) {
            this.setLocalizedErrorMessage(errorMessage);
        }
        if (errorMessage != null) {
            returnValue = false;
        }
        if (returnValue && this.bottomPanel != null && !this.bottomPanel.isValid()) {
            return false;
        }
        return returnValue;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator<ChangeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(e);
        }
    }

    public void readSettings(WizardDescriptor settings) {
        Object substitute;
        this.wizard = settings;
        if (this.gui != null) {
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), preselectedFolder);
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)settings);
        }
        if (this.gui != null && (substitute = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            this.wizard.putProperty("NewFileWizard_Title", substitute);
        }
    }

    private String pathToSpecHelper(WizardDescriptor wizard) {
        FileObject specHelper = this.project.getProjectDirectory().getFileObject("spec/spec_helper.rb");
        if (specHelper == null) {
            return null;
        }
        FileObject targetFolder = this.getTargetFolderFromGUI(wizard);
        if (!FileUtil.isParentOf((FileObject)specHelper.getParent(), (FileObject)targetFolder) && !specHelper.getParent().equals(targetFolder)) {
            return null;
        }
        String path = "/";
        FileObject parent = targetFolder;
        while (!parent.equals(specHelper.getParent())) {
            path = path + "../";
            parent = parent.getParent();
        }
        return "File.expand_path(File.dirname(__FILE__) + '" + path + specHelper.getName() + "')";
    }

    public void storeSettings(WizardDescriptor settings) {
        Object value = settings.getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)settings);
            }
            Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)this.getTargetFolderFromGUI(settings));
            Templates.setTargetName((WizardDescriptor)settings, (String)this.gui.getTargetName());
            if (this.type == NewRubyFileWizardIterator.Type.SPEC) {
                this.wizard.putProperty("classname", (Object)this.gui.getClassName());
                String name = RubyUtils.camelToUnderlinedName((String)this.gui.getClassName());
                String pathToRequire = this.pathToSpecHelper(this.wizard);
                if (pathToRequire == null) {
                    pathToRequire = "'" + name + "'";
                }
                this.wizard.putProperty("classfile", (Object)name);
                this.wizard.putProperty("file_to_require", (Object)pathToRequire);
                this.wizard.putProperty("classfield", (Object)name);
            } else if (this.type == NewRubyFileWizardIterator.Type.CLASS || this.type == NewRubyFileWizardIterator.Type.TEST) {
                this.wizard.putProperty("class", (Object)this.gui.getClassName());
                String name = RubyUtils.camelToUnderlinedName((String)this.gui.getClassName());
                if (name.startsWith("test_")) {
                    name = name.substring("test_".length());
                } else if (name.endsWith("_test")) {
                    name = name.substring(0, name.length() - "_test".length());
                }
                this.wizard.putProperty("classfile", (Object)name);
                this.wizard.putProperty("module", (Object)this.gui.getModuleName());
                this.wizard.putProperty("extend", (Object)this.gui.getExtends());
            } else if (this.type == NewRubyFileWizardIterator.Type.MODULE) {
                this.wizard.putProperty("module", (Object)this.gui.getClassName());
                this.wizard.putProperty("outermodules", (Object)this.gui.getModuleName());
            }
        }
        settings.putProperty("NewFileWizard_Title", null);
        if (WizardDescriptor.FINISH_OPTION.equals(value)) {
            this.wizard.putProperty(FOLDER_TO_DELETE, null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void setErrorMessage(String key) {
        if (key == null) {
            this.setLocalizedErrorMessage("");
        } else {
            this.setLocalizedErrorMessage(NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)key));
        }
    }

    private void setLocalizedErrorMessage(String message) {
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    private FileObject getTargetFolderFromGUI(WizardDescriptor wd) {
        assert (this.gui != null);
        File file = new File(this.gui.getTargetFolder());
        FileObject folder = FileUtil.toFileObject((File)file);
        if (folder == null) {
            try {
                folder = FileUtil.createFolder((File)file);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return folder;
    }

    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String ident) {
        return Utilities.isJavaIdentifier((String)ident);
    }

    static boolean isValidFileName(String ident) {
        return ident != null && ident.length() != 0;
    }

    public static String canUseFileName(String folderName, String newObjectName, String extension) {
        StringBuffer sb;
        String newObjectNameToDisplay = newObjectName;
        if (newObjectName != null) {
            newObjectName = newObjectName.replace('.', '/');
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuffer();
            sb.append(newObjectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuffer();
            sb.append(newObjectNameToDisplay);
            sb.append('.');
            sb.append(extension);
            newObjectNameToDisplay = sb.toString();
        }
        if (folderName == null) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        FileObject targetFolder = FileUtil.toFileObject((File)new File(folderName));
        if (targetFolder == null) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!targetFolder.canWrite()) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (RubyTargetChooserPanel.existFileName(targetFolder, "/" + newObjectName)) {
            return NbBundle.getMessage(RubyTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)newObjectNameToDisplay);
        }
        return null;
    }

    private static boolean existFileName(FileObject targetFolder, String relFileName) {
        boolean result = false;
        File fileForTargetFolder = FileUtil.toFile((FileObject)targetFolder);
        result = fileForTargetFolder.exists() ? new File(fileForTargetFolder, relFileName).exists() : targetFolder.getFileObject(relFileName) != null;
        return result;
    }
}

