/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.loader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javacard.ri.platform.loader.DevicesForm;
import org.netbeans.modules.javacard.ri.platform.loader.JavacardPlatformDataObject;
import org.netbeans.modules.javacard.ri.platform.loader.PathPropertyForm;
import org.netbeans.modules.propdos.PropertiesAdapter;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class PlatformCustomizerPanel
extends JPanel
implements ChangeListener {
    private final JavacardPlatformDataObject dob;
    private final Properties properties;
    private JTextField antNameField;
    private JLabel antNameLabel;
    private JPanel classicClasspathPanel;
    private JPanel classpathPanel;
    private JPanel devicesPanel;
    private JPanel javadocPanel;
    private JPanel sourcesPanel;
    private JTabbedPane tabs;

    public PlatformCustomizerPanel(JavacardPlatformDataObject dob) {
        this.dob = dob;
        PropertiesAdapter adap = (PropertiesAdapter)dob.getLookup().lookup(PropertiesAdapter.class);
        assert (adap != null);
        this.properties = adap.asProperties();
        if (!dob.isValid()) {
            this.setLayout(new BorderLayout());
            this.add(new JLabel(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"MSG_INVALID_PLATFORM")));
        } else {
            this.initComponents();
            this.initUi();
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.CustomizingJavaCardPlatform");
    }

    private void initUi() {
        this.antNameField.setText(this.dob.getName());
        this.devicesPanel.add(new DevicesForm((DataObject)this.dob));
        this.classpathPanel.add(new PathPropertyForm(this.properties, "javacard.bootclasspath"));
        this.sourcesPanel.add(new PathPropertyForm(this.properties, "javacard.sourcepath"));
        this.javadocPanel.add(new PathPropertyForm(this.properties, "javacard.javadocpath"));
        this.classicClasspathPanel.add(new PathPropertyForm(this.properties, "javacard.classic.bootclasspath"));
        int toSelect = NbPreferences.forModule(PlatformCustomizerPanel.class).getInt("selectedTabIndex", 0);
        this.tabs.setSelectedIndex(toSelect);
        this.tabs.addChangeListener(this);
    }

    private void initComponents() {
        this.antNameLabel = new JLabel();
        this.antNameField = new JTextField();
        this.tabs = new JTabbedPane();
        this.devicesPanel = new JPanel();
        this.classpathPanel = new JPanel();
        this.sourcesPanel = new JPanel();
        this.javadocPanel = new JPanel();
        this.classicClasspathPanel = new JPanel();
        this.antNameLabel.setLabelFor(this.antNameField);
        this.antNameLabel.setText(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"PlatformCustomizerPanel.antNameLabel.text"));
        this.antNameField.setEditable(false);
        this.antNameField.setText(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"PlatformCustomizerPanel.antNameField.text"));
        this.devicesPanel.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"PlatformCustomizerPanel.devicesPanel.TabConstraints.tabTitle"), this.devicesPanel);
        this.classpathPanel.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"PlatformCustomizerPanel.classpathPanel.TabConstraints.tabTitle"), this.classpathPanel);
        this.sourcesPanel.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"PlatformCustomizerPanel.sourcesPanel.TabConstraints.tabTitle"), this.sourcesPanel);
        this.javadocPanel.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"PlatformCustomizerPanel.javadocPanel.TabConstraints.tabTitle"), this.javadocPanel);
        this.classicClasspathPanel.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(PlatformCustomizerPanel.class, (String)"PlatformCustomizerPanel.classicClasspathPanel.TabConstraints.tabTitle"), this.classicClasspathPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.antNameLabel).add(18, 18, 18).add((Component)this.antNameField, -1, 348, Short.MAX_VALUE)).add((Component)this.tabs, -1, 413, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.antNameField, -2, -1, -2).add((Component)this.antNameLabel)).addPreferredGap(1).add((Component)this.tabs, -1, 247, Short.MAX_VALUE)));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        NbPreferences.forModule(PlatformCustomizerPanel.class).putInt("selectedTabIndex", this.tabs.getSelectedIndex());
    }
}

