/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.shell;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.javacard.shell.ClearCommand;
import org.netbeans.modules.javacard.shell.Command;
import org.netbeans.modules.javacard.shell.ContactedCommand;
import org.netbeans.modules.javacard.shell.ContactlessCommand;
import org.netbeans.modules.javacard.shell.ExtendedCommand;
import org.netbeans.modules.javacard.shell.GetCommand;
import org.netbeans.modules.javacard.shell.HelpCommand;
import org.netbeans.modules.javacard.shell.HistoryCommand;
import org.netbeans.modules.javacard.shell.ListCommand;
import org.netbeans.modules.javacard.shell.PowerdownCommand;
import org.netbeans.modules.javacard.shell.PowerupCommand;
import org.netbeans.modules.javacard.shell.RestartCommand;
import org.netbeans.modules.javacard.shell.ResumeCommand;
import org.netbeans.modules.javacard.shell.SelectCommand;
import org.netbeans.modules.javacard.shell.SendCommand;
import org.netbeans.modules.javacard.shell.ShellException;
import org.netbeans.modules.javacard.shell.ShellPanel;
import org.netbeans.modules.javacard.shell.StartCommand;
import org.netbeans.modules.javacard.shell.StopCommand;
import org.netbeans.modules.javacard.spi.CardState;
import org.openide.util.NbBundle;

class CommandManager {
    private final Map<String, Command> commands = new HashMap<String, Command>(13);

    CommandManager() {
        this.commands.put("help", new HelpCommand());
        this.commands.put("history", new HistoryCommand());
        this.commands.put("select", new SelectCommand());
        this.commands.put("send", new SendCommand());
        this.commands.put("get", new GetCommand());
        this.commands.put("start", new StartCommand());
        this.commands.put("stop", new StopCommand());
        this.commands.put("restart", new RestartCommand());
        this.commands.put("resume", new ResumeCommand());
        this.commands.put("list", new ListCommand());
        this.commands.put("clear", new ClearCommand());
        this.commands.put("powerup", new PowerupCommand());
        this.commands.put("powerdown", new PowerdownCommand());
        this.commands.put("extended", new ExtendedCommand());
        this.commands.put("contacted", new ContactedCommand());
        this.commands.put("contactless", new ContactlessCommand());
    }

    public Object[] allCommandNames() {
        Object[] names = this.commands.keySet().toArray();
        Arrays.sort(names);
        return names;
    }

    public Command getCommand(String str) {
        return this.commands.get(str);
    }

    public boolean isValidCommand(String str) {
        return this.commands.containsKey(str);
    }

    public String execute(ShellPanel shellPanel, String command) throws ShellException {
        CardState state = shellPanel.getCard().getState();
        if (state.isTransitionalState()) {
            return NbBundle.getMessage(ResumeCommand.class, (String)"ERR_TRANSITIONAL_STATE", (Object)shellPanel.getCard().getState());
        }
        String[] tokens = command.split(" ");
        Command c = this.commands.get(tokens[0]);
        if (c != null) {
            return c.execute(shellPanel, tokens);
        }
        throw new ShellException(NbBundle.getMessage(CommandManager.class, (String)"ERR_UNKNOWN_COMMAND", (Object)command));
    }
}

