/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.netbeans.modules.j2ee.jboss4.nodes.JBAbilitiesSupport;
import org.netbeans.modules.j2ee.jboss4.nodes.JBEjbModuleNode;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.Refreshable;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class JBEjbModulesChildren
extends Children.Keys
implements Refreshable {
    private final JBAbilitiesSupport abilitiesSupport;
    private final Lookup lookup;

    public JBEjbModulesChildren(Lookup lookup) {
        this.lookup = lookup;
        this.abilitiesSupport = new JBAbilitiesSupport(lookup);
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{"wait_node"});
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                LinkedList linkedList = new LinkedList();
                MBeanServerConnection mBeanServerConnection = Util.getRMIServer(JBEjbModulesChildren.this.lookup);
                JBEjbModulesChildren.this.addEjbModules(mBeanServerConnection, linkedList);
                JBEjbModulesChildren.this.addEJB3Modules(mBeanServerConnection, linkedList);
                JBEjbModulesChildren.this.setKeys(linkedList);
            }
        }, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEjbModules(Object object, List list) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            ObjectName objectName;
            String string;
            Thread.currentThread().setContextClassLoader(object.getClass().getClassLoader());
            if (this.abilitiesSupport.isRemoteManagementSupported() && this.abilitiesSupport.isJB4x()) {
                string = "name";
                objectName = new ObjectName("jboss.management.local:j2eeType=EJBModule,J2EEApplication=null,*");
            } else {
                string = "module";
                objectName = new ObjectName("jboss.j2ee:service=EjbModule,*");
            }
            Set set = (Set)object.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(object, objectName, null);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = ((ObjectInstance)iterator.next()).getObjectName();
                String string2 = objectName2.getKeyProperty(string);
                list.add(new JBEjbModuleNode(string2, this.lookup));
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEJB3Modules(Object object, List list) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(object.getClass().getClassLoader());
            ObjectName objectName = new ObjectName("jboss.j2ee:service=EJB3,*");
            Set set = (Set)object.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(object, objectName, null);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    ObjectName objectName2 = ((ObjectInstance)iterator.next()).getObjectName();
                    String string = objectName2.getKeyProperty("module");
                    list.add(new JBEjbModuleNode(string, this.lookup, true));
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.INFO, null, exception);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof JBEjbModuleNode) {
            return new Node[]{(JBEjbModuleNode)((Object)object)};
        }
        if (object instanceof String && object.equals("wait_node")) {
            return new Node[]{Util.createWaitNode()};
        }
        return null;
    }
}

