/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.plugins;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.ProgressSupport;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class GrailsPluginSupport {
    private static Logger LOGGER = Logger.getLogger(GrailsPluginSupport.class.getName());
    private final GrailsProject project;

    private GrailsPluginSupport(GrailsProject grailsProject) {
        this.project = grailsProject;
    }

    public static GrailsPluginSupport forProject(Project project) {
        GrailsProject grailsProject = (GrailsProject)project.getLookup().lookup(GrailsProject.class);
        if (grailsProject != null) {
            return new GrailsPluginSupport(grailsProject);
        }
        return null;
    }

    public boolean usesPlugin(String string) {
        assert (string != null) : "Name is null";
        for (GrailsPlugin grailsPlugin : this.loadInstalledPlugins()) {
            if (!string.equals(grailsPlugin.getName())) continue;
            return true;
        }
        return false;
    }

    public FolderFilter getProjectPluginFilter() {
        GrailsProjectConfig grailsProjectConfig = (GrailsProjectConfig)this.project.getLookup().lookup(GrailsProjectConfig.class);
        if (grailsProjectConfig != null && GrailsPlatform.Version.VERSION_1_1.compareTo(grailsProjectConfig.getGrailsPlatform().getVersion()) <= 0) {
            List<GrailsPlugin> list = this.loadInstalledPlugins11();
            final HashSet<String> hashSet = new HashSet<String>();
            for (GrailsPlugin grailsPlugin : list) {
                hashSet.add(grailsPlugin.getDirName());
            }
            return new FolderFilter(){

                @Override
                public boolean accept(String string) {
                    return hashSet.contains(string);
                }
            };
        }
        return new FolderFilter(){

            @Override
            public boolean accept(String string) {
                return true;
            }
        };
    }

    public List<GrailsPlugin> refreshAvailablePlugins() throws InterruptedException {
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getDisplayName() + " (" + "list-plugins" + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand("list-plugins", GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        final PluginProcessor pluginProcessor = new PluginProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().frontWindow(true);
        executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{inputProcessor, InputProcessors.bridge((LineProcessor)pluginProcessor)});
            }
        });
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string);
        Future future = executionService.run();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            future.cancel(true);
            throw interruptedException;
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException.getCause());
        }
        return pluginProcessor.getPlugins();
    }

    public List<GrailsPlugin> loadInstalledPlugins() {
        GrailsPlatform.Version version = GrailsPlatform.getDefault().getVersion();
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(version) <= 0) {
            return this.loadInstalledPlugins11();
        }
        return this.loadInstalledPlugins10();
    }

    private List<GrailsPlugin> loadInstalledPlugins10() {
        ArrayList<GrailsPlugin> arrayList = new ArrayList<GrailsPlugin>();
        try {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("plugins");
            if (fileObject != null && fileObject.isFolder()) {
                fileObject.refresh();
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    FileObject fileObject3;
                    if (!fileObject2.isFolder() || (fileObject3 = fileObject2.getFileObject("plugin.xml")) == null || !fileObject3.canRead()) continue;
                    arrayList.add(this.getPluginFromInputStream(fileObject3.getInputStream(), null));
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GrailsPlugin> loadInstalledPlugins11() {
        ArrayList<GrailsPlugin> arrayList;
        block6: {
            arrayList = new ArrayList<GrailsPlugin>();
            try {
                FileObject fileObject = this.project.getProjectDirectory().getFileObject("application.properties");
                if (fileObject == null || !fileObject.isData()) break block6;
                Properties properties = new Properties();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
                try {
                    properties.load(bufferedInputStream);
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (!string.startsWith("plugins.")) continue;
                        String string2 = properties.getProperty(string);
                        string = string.substring("plugins.".length());
                        arrayList.add(new GrailsPlugin(string, string2, null));
                    }
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean uninstallPlugins(Collection<GrailsPlugin> collection) {
        GrailsPlatform.Version version = GrailsPlatform.getDefault().getVersion();
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(version) <= 0) {
            return this.uninstallPlugins11(collection);
        }
        return this.uninstallPlugins10(collection);
    }

    private boolean uninstallPlugins10(Collection<GrailsPlugin> collection) {
        FileObject fileObject;
        if (collection != null && collection.size() > 0 && (fileObject = this.project.getProjectDirectory().getFileObject("plugins")) != null && fileObject.isFolder() && fileObject.canWrite()) {
            fileObject.refresh();
            try {
                for (GrailsPlugin grailsPlugin : collection) {
                    FileObject fileObject2;
                    FileObject fileObject3 = fileObject.getFileObject(grailsPlugin.getDirName());
                    if (fileObject3 != null && fileObject3.isValid()) {
                        fileObject3.delete();
                    }
                    if ((fileObject2 = fileObject.getFileObject(grailsPlugin.getZipName())) == null || !fileObject2.isValid()) continue;
                    fileObject2.delete();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return true;
    }

    private boolean uninstallPlugins11(Collection<GrailsPlugin> collection) {
        return this.handlePlugins(collection, true);
    }

    public boolean installPlugins(Collection<GrailsPlugin> collection) {
        return this.handlePlugins(collection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePlugins(Collection<GrailsPlugin> collection, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        if (collection == null || collection.size() <= 0) {
            return false;
        }
        boolean bl2 = true;
        GrailsPlatform grailsPlatform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            for (GrailsPlugin grailsPlugin : collection) {
                String string = NbBundle.getMessage(GrailsPluginSupport.class, (String)(bl ? "Uninstallation" : "Installation"));
                String string2 = NbBundle.getMessage(GrailsPluginSupport.class, (String)(bl ? "PluginUninstallPleaseWait" : "PluginInstallPleaseWait"), (Object)grailsPlugin.getName());
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
                ProgressSupport.ProgressDialogDescriptor progressDialogDescriptor = ProgressSupport.createProgressDialog(string, progressHandle, null);
                final Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)progressDialogDescriptor);
                progressDialogDescriptor.addCancelListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                });
                Callable<Boolean> callable = this.getPluginHandlerCallable(grailsPlatform, grailsPlugin, progressDialogDescriptor, dialog, bl);
                Future<Boolean> future = executorService.submit(callable);
                progressHandle.start();
                progressHandle.progress(string2);
                dialog.setVisible(true);
                try {
                    bl2 = bl2 && future.get() != false;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)(executionException.getCause() != null ? executionException.getCause() : executionException));
                }
                finally {
                    progressHandle.finish();
                }
            }
            executorService.shutdown();
        }
        catch (Throwable throwable) {
            executorService.shutdown();
            FileUtil.refreshFor((File[])new File[]{this.project.getBuildConfig().getProjectPluginsDir()});
            throw throwable;
        }
        FileUtil.refreshFor((File[])new File[]{this.project.getBuildConfig().getProjectPluginsDir()});
        return bl2;
    }

    private Callable<Boolean> getPluginHandlerCallable(final GrailsPlatform grailsPlatform, final GrailsPlugin grailsPlugin, final ProgressSupport.ProgressDialogDescriptor progressDialogDescriptor, final Dialog dialog, boolean bl) {
        final String string = bl ? "uninstall-plugin" : "install-plugin";
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                Constable constable;
                ProjectInformation projectInformation = (ProjectInformation)GrailsPluginSupport.this.project.getLookup().lookup(ProjectInformation.class);
                String string2 = projectInformation.getDisplayName() + " (" + string + ")";
                ArrayList<String> arrayList = new ArrayList<String>(3);
                if (GrailsPlatform.Version.VERSION_1_1.compareTo(grailsPlatform.getVersion()) <= 0) {
                    arrayList.add("--non-interactive");
                }
                if (grailsPlugin.getPath() == null) {
                    arrayList.add(grailsPlugin.getName());
                    arrayList.add(grailsPlugin.getVersion());
                } else {
                    arrayList.add(grailsPlugin.getPath().getAbsolutePath());
                }
                Callable callable = ExecutionSupport.getInstance().createSimpleCommand(string, GrailsProjectConfig.forProject((Project)GrailsPluginSupport.this.project), arrayList.toArray(new String[arrayList.size()]));
                ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().frontWindow(true).postExecution((Runnable)new RefreshProjectRunnable(GrailsPluginSupport.this.project));
                ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string2);
                final Future future = executionService.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressDialogDescriptor.addCancelListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                future.cancel(true);
                            }
                        });
                    }
                });
                boolean bl = false;
                boolean bl2 = false;
                try {
                    try {
                        constable = (Integer)future.get();
                        if (constable != 0) {
                            bl = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                        future.cancel(true);
                        bl = true;
                    }
                    catch (ExecutionException executionException) {
                        bl = true;
                        Exceptions.printStackTrace((Throwable)(executionException.getCause() != null ? executionException.getCause() : executionException));
                    }
                    catch (CancellationException cancellationException) {
                        bl = true;
                    }
                    constable = Boolean.valueOf(!bl);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                return constable;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrailsPlugin getPluginFromZipFile(String string) {
        GrailsPlugin grailsPlugin;
        block6: {
            grailsPlugin = null;
            try {
                File file = new File(string);
                if (!file.exists() || !file.isFile()) break block6;
                ZipFile zipFile = new ZipFile(file);
                try {
                    ZipEntry zipEntry = zipFile.getEntry("plugin.xml");
                    if (zipEntry != null) {
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        grailsPlugin = this.getPluginFromInputStream(inputStream, file);
                    }
                }
                finally {
                    zipFile.close();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return grailsPlugin;
    }

    private GrailsPlugin getPluginFromInputStream(InputStream inputStream, File file) throws Exception {
        Document document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)false, null, null);
        Node node = document.getFirstChild();
        String string = node.getAttributes().getNamedItem("name").getTextContent();
        String string2 = null;
        String string3 = null;
        if (node.getAttributes().getNamedItem("version") != null) {
            string2 = node.getAttributes().getNamedItem("version").getTextContent();
        }
        if (document.getElementsByTagName("title") != null && document.getElementsByTagName("title").getLength() > 0) {
            string3 = document.getElementsByTagName("title").item(0).getTextContent();
        }
        return new GrailsPlugin(string, string2, string3, file);
    }

    private static class PluginProcessor
    implements LineProcessor {
        private final List<GrailsPlugin> plugins = Collections.synchronizedList(new ArrayList());
        private static final Pattern PLUGIN_PATTERN = Pattern.compile("(.+)[\\s]+<(.+)>[\\s]+--(.+)");

        private PluginProcessor() {
        }

        public void processLine(String string) {
            GrailsPlugin grailsPlugin = null;
            Matcher matcher = PLUGIN_PATTERN.matcher(string);
            if (matcher.matches() && !"no releases".equals(matcher.group(2))) {
                grailsPlugin = new GrailsPlugin(matcher.group(1).trim(), matcher.group(2), matcher.group(3));
            }
            if (grailsPlugin != null) {
                this.plugins.add(grailsPlugin);
            }
        }

        public void reset() {
        }

        public void close() {
        }

        public List<GrailsPlugin> getPlugins() {
            return this.plugins;
        }
    }

    public static interface FolderFilter {
        public boolean accept(String var1);
    }
}

