/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.LicenceData;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.KenaiUser;

public final class KenaiProject {
    public static final String PROP_PROJECT_CHANGED = "project_change";
    public static final String PROP_PROJECT_NOTIFICATION = "project_notification";
    public static final String PROP_PROJECT_REMOVED = "project_removed";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ProjectData data;
    private Icon projectIcon;
    private KenaiFeature[] features;
    private KenaiProjectMember[] members;
    private KenaiLicense[] licenses;
    private Kenai kenai;
    private boolean deleted = false;
    private static final int repositoryPatternProjectGroup = 4;

    private KenaiProject(Kenai kenai, ProjectData p) {
        this.fillInfo(p);
        this.kenai = kenai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KenaiProject get(Kenai kenai, ProjectData p) {
        HashMap<String, WeakReference<KenaiProject>> hashMap = kenai.projectsCache;
        synchronized (hashMap) {
            WeakReference<KenaiProject> wr = kenai.projectsCache.get(p.name);
            KenaiProject result = null;
            if (wr == null || (result = (KenaiProject)wr.get()) == null) {
                result = new KenaiProject(kenai, p);
                kenai.projectsCache.put(p.name, new WeakReference<KenaiProject>(result));
            } else {
                result = (KenaiProject)wr.get();
                result.fillInfo(p);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KenaiProject get(Kenai kenai, String name) {
        HashMap<String, WeakReference<KenaiProject>> hashMap = kenai.projectsCache;
        synchronized (hashMap) {
            WeakReference<KenaiProject> wr = kenai.projectsCache.get(name);
            if (wr == null) {
                return null;
            }
            return (KenaiProject)wr.get();
        }
    }

    public synchronized String getName() {
        return this.data.name;
    }

    public synchronized URL getWebLocation() {
        try {
            return new URL(this.data.web_url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public synchronized String getDisplayName() {
        return this.data.display_name;
    }

    public synchronized String getDescription() throws KenaiException {
        this.checkDeleted();
        this.fetchDetailsIfNotAvailable();
        return this.data.description;
    }

    public synchronized String getImageUrl() throws KenaiException {
        this.checkDeleted();
        this.fetchDetailsIfNotAvailable();
        return this.data.image;
    }

    public boolean isMyProject() {
        Collection<KenaiProject> my = this.kenai.myProjects;
        if (my == null) {
            return false;
        }
        return my.contains(this);
    }

    public KenaiProjectMember.Role getMyRole() throws KenaiException {
        this.checkDeleted();
        PasswordAuthentication passwordAuthentication = this.kenai.getPasswordAuthentication();
        if (passwordAuthentication == null) {
            return null;
        }
        String myName = passwordAuthentication.getUserName();
        for (KenaiProjectMember user : this.getMembers()) {
            if (!myName.equals(user.getUserName())) continue;
            return user.getRole();
        }
        return null;
    }

    public Icon getProjectIcon() throws KenaiException {
        this.checkDeleted();
        if (this.projectIcon == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new KenaiException("KenaiProject.getProjectIcon() must not be called from AWT thread unless an icon is cached!");
            }
            try {
                URL url = new URL(this.getImageUrl());
                BufferedImage img = ImageIO.read(url);
                this.projectIcon = new ImageIcon(img);
            }
            catch (IOException ex) {
                throw new KenaiException(ex.getMessage());
            }
        }
        return this.projectIcon;
    }

    public synchronized String getTags() throws KenaiException {
        this.checkDeleted();
        this.fetchDetailsIfNotAvailable();
        return this.data.tags;
    }

    public synchronized boolean isPrivate() throws KenaiException {
        this.checkDeleted();
        this.fetchDetailsIfNotAvailable();
        return this.data.private_hidden;
    }

    private static Pattern getRepositoryPattern(Kenai kenai) {
        return Pattern.compile("(https|http)://([a-z]+\\.)?" + kenai.getUrl().getHost().replace(".", "\\.") + "/(svn|hg)/(\\S*)~(.*)");
    }

    public static KenaiProject forRepository(String uri) throws KenaiException {
        if (uri == null) {
            return null;
        }
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            Matcher m = KenaiProject.getRepositoryPattern(k).matcher(uri);
            if (m.matches()) {
                return k.getProject(m.group(4));
            }
            if (!k.getUrl().getHost().equals("netbeans.org") || !uri.startsWith("https://hg.netbeans.org") && !uri.startsWith("http://hg.netbeans.org")) continue;
            return k.getProject("ide");
        }
        return null;
    }

    public static String getNameForRepository(String uri) {
        if (uri == null) {
            return null;
        }
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            Matcher m = KenaiProject.getRepositoryPattern(k).matcher(uri);
            if (m.matches()) {
                return m.group(4);
            }
            if (!k.getUrl().getHost().equals("netbeans.org") || !uri.startsWith("https://hg.netbeans.org") && !uri.startsWith("http://hg.netbeans.org")) continue;
            return "ide";
        }
        return null;
    }

    public synchronized KenaiFeature[] getFeatures() throws KenaiException {
        this.checkDeleted();
        this.fetchDetailsIfNotAvailable();
        if (this.features == null) {
            this.features = new KenaiFeature[this.data.features.length];
            int i = 0;
            for (FeatureData feature : this.data.features) {
                this.features[i++] = new KenaiFeature(feature);
            }
        }
        return this.features;
    }

    public synchronized KenaiProjectMember[] getMembers() throws KenaiException {
        this.checkDeleted();
        if (this.members == null) {
            Collection<KenaiProjectMember> projectMembers = this.kenai.getProjectMembers(this.getName());
            this.members = projectMembers.toArray(new KenaiProjectMember[projectMembers.size()]);
        }
        return this.members;
    }

    public synchronized void addMember(KenaiUser user, KenaiProjectMember.Role role) throws KenaiException {
        this.checkDeleted();
        this.members = null;
        this.kenai.addMember(this, user, role);
        this.firePropertyChange(PROP_PROJECT_CHANGED, null, user);
    }

    public synchronized void deleteMember(KenaiUser user) throws KenaiException {
        this.checkDeleted();
        this.members = null;
        this.getMembers();
        this.kenai.deleteMember(this, user);
        this.firePropertyChange(PROP_PROJECT_CHANGED, user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete() throws KenaiException {
        this.checkDeleted();
        this.kenai.delete(this);
        HashMap<String, WeakReference<KenaiProject>> hashMap = this.kenai.projectsCache;
        synchronized (hashMap) {
            this.kenai.projectsCache.remove(this.data.name);
        }
        this.deleted = true;
        this.firePropertyChange(PROP_PROJECT_REMOVED, null, null);
    }

    private void checkDeleted() throws KenaiException {
        if (this.deleted) {
            throw new KenaiException("project " + this.data.name + " was deleted");
        }
    }

    public synchronized KenaiUser getOwner() throws KenaiException {
        this.checkDeleted();
        this.fetchDetailsIfNotAvailable();
        if (this.data.owner == null) {
            return null;
        }
        return KenaiUser.forName(this.data.owner + "@" + this.kenai.getUrl().getHost());
    }

    public synchronized KenaiFeature[] getFeatures(KenaiService.Type type) throws KenaiException {
        this.checkDeleted();
        ArrayList<KenaiFeature> fs = new ArrayList<KenaiFeature>();
        for (KenaiFeature f : this.getFeatures()) {
            if (!f.getType().equals((Object)type)) continue;
            fs.add(f);
        }
        return fs.toArray(new KenaiFeature[fs.size()]);
    }

    public synchronized KenaiLicense[] getLicenses() throws KenaiException {
        this.checkDeleted();
        this.fetchDetailsIfNotAvailable();
        if (this.licenses == null) {
            this.licenses = new KenaiLicense[this.data.licenses.length];
            int i = 0;
            for (LicenceData licence : this.data.licenses) {
                this.licenses[i++] = new KenaiLicense(licence);
            }
        }
        return this.licenses;
    }

    public KenaiFeature createProjectFeature(String name, String display_name, String description, String service, String url, String repository_url, String browse_url) throws KenaiException {
        this.checkDeleted();
        KenaiFeature feature = this.kenai.createProjectFeature(this.getName(), name, display_name, description, service, url, repository_url, browse_url);
        this.refresh();
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillInfo(ProjectData prj) {
        KenaiProject kenaiProject = this;
        synchronized (kenaiProject) {
            if (prj.updated_at == null && this.data != null && this.data.updated_at != null) {
                return;
            }
            this.data = prj;
            this.features = null;
            this.members = null;
            this.licenses = null;
            this.projectIcon = null;
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_PROJECT_CHANGED, null, null));
    }

    synchronized ProjectData getData() {
        return this.data;
    }

    private void fetchDetailsIfNotAvailable() throws KenaiException {
        if (this.data.updated_at != null) {
            return;
        }
        this.refresh();
    }

    private void refresh() throws KenaiException {
        this.fillInfo(this.kenai.getDetails(this.getName()));
    }

    public synchronized boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KenaiProject other = (KenaiProject)obj;
        return !(this.data.name == null ? other.data.name != null : !this.data.name.equals(other.data.name));
    }

    public synchronized int hashCode() {
        int hash = 5;
        hash = 13 * hash + (this.data.name != null ? this.data.name.hashCode() : 0);
        return hash;
    }

    public synchronized String toString() {
        return "KenaiProject " + this.getName();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(name, l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public synchronized void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    public synchronized void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(name, l);
    }

    public Kenai getKenai() {
        return this.kenai;
    }
}

