/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.lang.reflect.Array;
import java.util.Iterator;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> T[] copy(T[] array) {
        T[] a = ArrayUtil.newArray(array, array.length);
        System.arraycopy(array, 0, a, 0, array.length);
        return a;
    }

    public static <T> T[] union(T[] array, T ... toAdd) {
        T[] a = ArrayUtil.newArray(array, array.length + toAdd.length);
        System.arraycopy(array, 0, a, 0, array.length);
        System.arraycopy(toAdd, 0, a, array.length, toAdd.length);
        return a;
    }

    public static <T> boolean contains(T[] array, T ... contained) {
        for (T t : contained) {
            boolean c = false;
            for (T a : array) {
                if (!a.equals(t)) continue;
                c = true;
                break;
            }
            if (c) continue;
            return false;
        }
        return true;
    }

    public static <T> Iterator<T> iterator(T[] array) {
        return new ArrayIterator<T>(array);
    }

    private static <T> T[] newArray(T[] original, int lenght) {
        Object[] a = (Object[])Array.newInstance(original.getClass().getComponentType(), lenght);
        return a;
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private T[] array;
        private int i = 0;

        public ArrayIterator(T[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.array.length > this.i;
        }

        @Override
        public T next() {
            return this.array[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

