/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class VCallNode
extends Node
implements INameNode {
    public final CallSite callAdapter;

    public VCallNode(ISourcePosition position, String name) {
        super(position, NodeType.VCALLNODE);
        this.callAdapter = MethodIndex.getVariableCallSite(name);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitVCallNode(this);
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.callAdapter.call(context, self);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return self.getMetaClass().isMethodBound(this.getName(), false) ? "method" : null;
    }
}

