/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyHash;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class HashNode
extends Node {
    private final ListNode listNode;

    public HashNode(ISourcePosition position, ListNode listNode) {
        super(position, NodeType.HASHNODE);
        this.listNode = listNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public ListNode getListNode() {
        return this.listNode;
    }

    @Override
    public List<Node> childNodes() {
        return HashNode.createList(this.listNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyHash hash = RubyHash.newHash(runtime);
        if (this.listNode != null) {
            int size = this.listNode.size();
            int i = 0;
            while (i < size) {
                IRubyObject key = this.listNode.get(i++).interpret(runtime, context, self, aBlock);
                IRubyObject value = this.listNode.get(i++).interpret(runtime, context, self, aBlock);
                hash.fastASet(key, value);
            }
        }
        return hash;
    }
}

