/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyFile;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyProcess;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubyThread;
import org.jruby.nb.anno.FrameField;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.ShellLauncher;
import org.jruby.nb.util.TypeConverter;
import org.jruby.nb.util.io.BadDescriptorException;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.ChannelStream;
import org.jruby.nb.util.io.FileExistsException;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.ModeFlags;
import org.jruby.nb.util.io.OpenFile;
import org.jruby.nb.util.io.PipeException;
import org.jruby.nb.util.io.STDIO;
import org.jruby.nb.util.io.Stream;
import org.jruby.util.ByteList;

@JRubyClass(name={"IO"}, include={"Enumerable"})
public class RubyIO
extends RubyObject {
    protected OpenFile openFile;
    protected List<RubyThread> blockingThreads;
    protected static AtomicInteger filenoIndex = new AtomicInteger(2);
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIO(runtime, klass);
        }
    };
    private static final ByteList NIL_BYTELIST = ByteList.create((CharSequence)"nil");
    private static final ByteList RECURSIVE_BYTELIST = ByteList.create((CharSequence)"[...]");

    public void registerDescriptor(ChannelDescriptor descriptor) {
        this.getRuntime().getDescriptors().put(new Integer(descriptor.getFileno()), new WeakReference<ChannelDescriptor>(descriptor));
    }

    public void unregisterDescriptor(int aFileno) {
        this.getRuntime().getDescriptors().remove(new Integer(aFileno));
    }

    public ChannelDescriptor getDescriptorByFileno(int aFileno) {
        Reference reference = this.getRuntime().getDescriptors().get(new Integer(aFileno));
        if (reference == null) {
            return null;
        }
        return (ChannelDescriptor)reference.get();
    }

    public static int getNewFileno() {
        return filenoIndex.incrementAndGet();
    }

    public RubyIO(Ruby runtime, RubyClass type) {
        super(runtime, type);
        this.openFile = new OpenFile();
    }

    public RubyIO(Ruby runtime, OutputStream outputStream) {
        super(runtime, runtime.getIO());
        if (outputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(outputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(66);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime, InputStream inputStream) {
        super(runtime, runtime.getIO());
        if (inputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(inputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(1);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime, Channel channel) {
        super(runtime, runtime.getIO());
        if (channel == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(channel, RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime, ShellLauncher.POpenProcess process, ModeFlags modes) {
        super(runtime, runtime.getIO());
        this.openFile = new OpenFile();
        this.openFile.setMode(modes.getOpenFileFlags() | 8);
        this.openFile.setProcess(process);
        try {
            if (this.openFile.isReadable()) {
                ReadableByteChannel inChannel = process.getInput() != null ? process.getInput() : Channels.newChannel(process.getInputStream());
                ChannelDescriptor main = new ChannelDescriptor(inChannel, RubyIO.getNewFileno(), new FileDescriptor());
                main.setCanBeSeekable(false);
                this.openFile.setMainStream(new ChannelStream(this.getRuntime(), main));
                this.registerDescriptor(main);
            }
            if (this.openFile.isWritable()) {
                WritableByteChannel outChannel = process.getOutput() != null ? process.getOutput() : Channels.newChannel(process.getOutputStream());
                ChannelDescriptor pipe = new ChannelDescriptor(outChannel, RubyIO.getNewFileno(), new FileDescriptor());
                pipe.setCanBeSeekable(false);
                if (this.openFile.getMainStream() != null) {
                    this.openFile.setPipeStream(new ChannelStream(this.getRuntime(), pipe));
                } else {
                    this.openFile.setMainStream(new ChannelStream(this.getRuntime(), pipe));
                }
                this.registerDescriptor(pipe);
            }
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    public RubyIO(Ruby runtime, STDIO stdio) {
        super(runtime, runtime.getIO());
        this.openFile = new OpenFile();
        try {
            switch (stdio) {
                case IN: {
                    this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(runtime.getIn(), 0, new ModeFlags(0L), FileDescriptor.in), FileDescriptor.in));
                    break;
                }
                case OUT: {
                    this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(runtime.getOut()), 1, new ModeFlags(9L), FileDescriptor.out), FileDescriptor.out));
                    this.openFile.getMainStream().setSync(true);
                    break;
                }
                case ERR: {
                    this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(runtime.getErr()), 2, new ModeFlags(9L), FileDescriptor.err), FileDescriptor.err));
                    this.openFile.getMainStream().setSync(true);
                }
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public static RubyIO newIO(Ruby runtime, Channel channel) {
        return new RubyIO(runtime, channel);
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    protected OpenFile getOpenFileChecked() {
        this.openFile.checkClosed(this.getRuntime());
        return this.openFile;
    }

    public static RubyClass createIOClass(Ruby runtime) {
        RubyClass ioClass = runtime.defineClass("IO", runtime.getObject(), IO_ALLOCATOR);
        ioClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyIO;
            }
        };
        ioClass.includeModule(runtime.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.fastSetConstant("SEEK_SET", runtime.newFixnum(0));
        ioClass.fastSetConstant("SEEK_CUR", runtime.newFixnum(1));
        ioClass.fastSetConstant("SEEK_END", runtime.newFixnum(2));
        return ioClass;
    }

    public OutputStream getOutStream() {
        return this.getOpenFileChecked().getMainStream().newOutputStream();
    }

    public InputStream getInStream() {
        return this.getOpenFileChecked().getMainStream().newInputStream();
    }

    public Channel getChannel() {
        if (this.getOpenFileChecked().getMainStream() instanceof ChannelStream) {
            return ((ChannelStream)this.openFile.getMainStream()).getDescriptor().getChannel();
        }
        return null;
    }

    public Stream getHandler() {
        return this.getOpenFileChecked().getMainStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args) throws InvalidValueException {
        Ruby runtime = context.getRuntime();
        if (args.length < 1) {
            throw runtime.newArgumentError("wrong number of arguments");
        }
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args[0], runtime.getIO(), MethodIndex.getIndex("to_io"), "to_io");
        if (!tmp.isNil()) {
            try {
                RubyIO ios = (RubyIO)tmp;
                if (ios.openFile == this.openFile) {
                    return this;
                }
                OpenFile originalFile = ios.getOpenFileChecked();
                OpenFile selfFile = this.getOpenFileChecked();
                long pos = 0L;
                if (originalFile.isReadable()) {
                    pos = originalFile.getMainStream().fgetpos();
                }
                if (originalFile.getPipeStream() != null) {
                    originalFile.getPipeStream().fflush();
                } else if (originalFile.isWritable()) {
                    originalFile.getMainStream().fflush();
                }
                if (selfFile.isWritable()) {
                    selfFile.getWriteStream().fflush();
                }
                selfFile.setMode(originalFile.getMode());
                selfFile.setProcess(originalFile.getProcess());
                selfFile.setLineNumber(originalFile.getLineNumber());
                selfFile.setPath(originalFile.getPath());
                selfFile.setFinalizer(originalFile.getFinalizer());
                ChannelDescriptor selfDescriptor = selfFile.getMainStream().getDescriptor();
                ChannelDescriptor originalDescriptor = originalFile.getMainStream().getDescriptor();
                if (selfDescriptor.getChannel() != originalDescriptor.getChannel()) {
                    if (selfDescriptor.getFileno() >= 0 && selfDescriptor.getFileno() <= 2) {
                        selfFile.getMainStream().clearerr();
                        originalDescriptor.dup2Into(selfDescriptor);
                        this.registerDescriptor(selfDescriptor);
                    } else {
                        Stream pipeFile = selfFile.getPipeStream();
                        int mode = selfFile.getMode();
                        selfFile.getMainStream().fclose();
                        selfFile.setPipeStream(null);
                        if (pipeFile != null) {
                            selfFile.setMainStream(ChannelStream.fdopen(runtime, originalDescriptor, new ModeFlags()));
                            selfFile.setPipeStream(pipeFile);
                        } else {
                            selfFile.setMainStream(new ChannelStream(runtime, originalDescriptor.dup2(selfDescriptor.getFileno())));
                            this.registerDescriptor(selfFile.getMainStream().getDescriptor());
                            selfFile.getMainStream().setSync(selfFile.getMainStream().isSync());
                        }
                        selfFile.setMode(mode);
                    }
                    if (originalFile.isReadable() && pos >= 0L) {
                        selfFile.seek(pos, 0);
                        originalFile.seek(pos, 0);
                    }
                }
                if (selfFile.getPipeStream() == null || selfDescriptor.getFileno() == selfFile.getPipeStream().getDescriptor().getFileno()) return this;
                int fd = selfFile.getPipeStream().getDescriptor().getFileno();
                if (originalFile.getPipeStream() == null) {
                    selfFile.getPipeStream().fclose();
                    selfFile.setPipeStream(null);
                    return this;
                }
                if (fd == originalFile.getPipeStream().getDescriptor().getFileno()) return this;
                selfFile.getPipeStream().fclose();
                ChannelDescriptor newFD2 = originalFile.getPipeStream().getDescriptor().dup2(fd);
                selfFile.setPipeStream(ChannelStream.fdopen(runtime, newFD2, RubyIO.getIOModes(runtime, "w")));
                this.registerDescriptor(newFD2);
                return this;
            }
            catch (IOException ex) {
                throw runtime.newIOError("could not reopen: " + ex.getMessage());
            }
            catch (BadDescriptorException ex) {
                throw runtime.newIOError("could not reopen: " + ex.getMessage());
            }
            catch (PipeException ex) {
                throw runtime.newIOError("could not reopen: " + ex.getMessage());
            }
        }
        RubyString pathString = args[0].convertToString();
        if (this.openFile == null) {
            this.openFile = new OpenFile();
        }
        try {
            ModeFlags modes;
            if (args.length > 1) {
                RubyString modeString = args[1].convertToString();
                modes = RubyIO.getIOModes(runtime, ((Object)modeString).toString());
                this.openFile.setMode(modes.getOpenFileFlags());
            } else {
                modes = RubyIO.getIOModes(runtime, "r");
            }
            String path = ((Object)pathString).toString();
            this.openFile.setPath(path);
            if (this.openFile.getMainStream() == null) {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(runtime, path, modes));
                }
                catch (FileExistsException fee) {
                    throw runtime.newErrnoEEXISTError(path);
                }
                this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
                if (this.openFile.getPipeStream() == null) return this;
                this.openFile.getPipeStream().fclose();
                this.unregisterDescriptor(this.openFile.getPipeStream().getDescriptor().getFileno());
                this.openFile.setPipeStream(null);
                return this;
            }
            this.openFile.getMainStream().freopen(path, RubyIO.getIOModes(runtime, this.openFile.getModeAsString(runtime)));
            this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
            if (this.openFile.getPipeStream() == null) return this;
        }
        catch (PipeException pe) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime.newErrnoEINVALError();
        }
        return this;
    }

    public static ModeFlags getIOModes(Ruby runtime, String modesString) throws InvalidValueException {
        return new ModeFlags(RubyIO.getIOModesIntFromString(runtime, modesString));
    }

    public static int getIOModesIntFromString(Ruby runtime, String modesString) {
        int modes = 0;
        int length = modesString.length();
        if (length == 0) {
            throw runtime.newArgumentError("illegal access mode");
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                modes |= 0;
                break;
            }
            case 'a': {
                modes |= 0x109;
                break;
            }
            case 'w': {
                modes |= 0x301;
                break;
            }
            default: {
                throw runtime.newArgumentError("illegal access mode " + modes);
            }
        }
        block9: for (int n = 1; n < length; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    modes |= 0x8000;
                    continue block9;
                }
                case '+': {
                    modes = modes & 0xFFFEFFFF | 2;
                    continue block9;
                }
                default: {
                    throw runtime.newArgumentError("illegal access mode " + modes);
                }
            }
        }
        return modes;
    }

    private static ByteList getSeparatorFromArgs(Ruby runtime, IRubyObject[] args, int idx) {
        ByteList separator;
        IRubyObject sepVal = args.length > idx ? args[idx] : runtime.getRecordSeparatorVar().get();
        ByteList byteList = separator = sepVal.isNil() ? null : sepVal.convertToString().getByteList();
        if (separator != null && separator.realSize == 0) {
            separator = Stream.PARAGRAPH_DELIMETER;
        }
        return separator;
    }

    private ByteList getSeparatorForGets(Ruby runtime, IRubyObject[] args) {
        return RubyIO.getSeparatorFromArgs(runtime, args, 0);
    }

    public IRubyObject getline(Ruby runtime, ByteList separator) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            boolean isParagraph = separator == Stream.PARAGRAPH_DELIMETER;
            ByteList byteList = separator = separator == Stream.PARAGRAPH_DELIMETER ? Stream.PARAGRAPH_SEPARATOR : separator;
            if (isParagraph) {
                this.swallow(10);
            }
            if (separator == null) {
                IRubyObject str = this.readAll(null);
                if (((RubyString)str).getByteList().length() == 0) {
                    return runtime.getNil();
                }
                this.incrementLineno(runtime, myOpenFile);
                return str;
            }
            if (separator.length() == 1) {
                return this.getlineFast(runtime, separator.get(0));
            }
            Stream readStream = myOpenFile.getMainStream();
            int c = -1;
            int n = -1;
            int newline = separator.get(separator.length() - 1) & 0xFF;
            ByteList buf = new ByteList(0);
            boolean update = false;
            while (true) {
                block17: {
                    block18: {
                        block16: {
                            this.readCheck(readStream);
                            readStream.clearerr();
                            try {
                                n = readStream.getline(buf, (byte)newline);
                                c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                            }
                            catch (EOFException e) {
                                n = -1;
                            }
                            if (n != -1) break block16;
                            if (readStream.isBlocking() || !(readStream instanceof ChannelStream)) break block17;
                            if (!this.waitReadable(((ChannelStream)readStream).getDescriptor())) {
                                throw runtime.newIOError("bad file descriptor: " + this.openFile.getPath());
                            }
                            break block18;
                        }
                        update = true;
                    }
                    if (c != newline) continue;
                }
                if (n == -1 || c == newline && buf.length() >= separator.length() && 0 == ByteList.memcmp((byte[])buf.unsafeBytes(), (int)(buf.begin + buf.realSize - separator.length()), (byte[])separator.unsafeBytes(), (int)separator.begin, (int)separator.realSize)) break;
            }
            if (isParagraph && c != -1) {
                this.swallow(10);
            }
            if (!update) {
                return runtime.getNil();
            }
            this.incrementLineno(runtime, myOpenFile);
            RubyString str = RubyString.newString(runtime, buf);
            str.setTaint(true);
            return str;
        }
        catch (PipeException ex) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    private void incrementLineno(Ruby runtime, OpenFile myOpenFile) {
        int lineno = myOpenFile.getLineNumber() + 1;
        myOpenFile.setLineNumber(lineno);
        runtime.getGlobalVariables().set("$.", runtime.newFixnum(lineno));
        RubyNumeric.int2fix(runtime, myOpenFile.getLineNumber());
    }

    protected boolean swallow(int term) throws IOException, BadDescriptorException {
        int c;
        Stream readStream = this.openFile.getMainStream();
        do {
            this.readCheck(readStream);
            try {
                c = readStream.fgetc();
            }
            catch (EOFException e) {
                c = -1;
            }
            if (c == term) continue;
            readStream.ungetc(c);
            return true;
        } while (c != -1);
        return false;
    }

    public IRubyObject getlineFast(Ruby runtime, int delim) throws IOException, BadDescriptorException {
        Stream readStream = this.openFile.getMainStream();
        int c = -1;
        ByteList buf = new ByteList(0);
        boolean update = false;
        do {
            int n;
            this.readCheck(readStream);
            readStream.clearerr();
            try {
                n = readStream.getline(buf, (byte)delim);
                c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
            }
            catch (EOFException e) {
                n = -1;
            }
            if (n == -1) {
                if (readStream.isBlocking() || !(readStream instanceof ChannelStream)) break;
                if (this.waitReadable(((ChannelStream)readStream).getDescriptor())) continue;
                throw runtime.newIOError("bad file descriptor: " + this.openFile.getPath());
            }
            update = true;
        } while (c != delim);
        if (!update) {
            return runtime.getNil();
        }
        this.incrementLineno(runtime, this.openFile);
        RubyString str = RubyString.newString(runtime, buf);
        str.setTaint(true);
        return str;
    }

    @JRubyMethod(name={"new", "for_fd"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        RubyClass klass = (RubyClass)recv;
        if (block.isGiven()) {
            String className = klass.getName();
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, className + "::new() does not take block; use " + className + "::open() instead", className + "::open()");
        }
        return klass.newInstance(context, args, block);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        int argCount = args.length;
        int fileno = RubyNumeric.fix2int(args[0]);
        try {
            ChannelDescriptor descriptor = this.getDescriptorByFileno(fileno);
            if (descriptor == null) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            descriptor.checkOpen();
            ModeFlags modes = argCount == 2 ? (args[1] instanceof RubyFixnum ? new ModeFlags(RubyFixnum.fix2long(args[1])) : RubyIO.getIOModes(this.getRuntime(), args[1].convertToString().toString())) : descriptor.getOriginalModes();
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, modes));
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ive) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    protected Stream fdopen(ChannelDescriptor existingDescriptor, ModeFlags modes) throws InvalidValueException {
        if (existingDescriptor == null) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return ChannelStream.fdopen(this.getRuntime(), existingDescriptor, modes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = context.getRuntime();
        RubyClass klass = (RubyClass)recv;
        RubyIO io = (RubyIO)klass.newInstance(context, args, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, io);
                return iRubyObject;
            }
            finally {
                block8: {
                    try {
                        io.getMetaClass().invoke(context, (IRubyObject)io, "close", IRubyObject.NULL_ARRAY, CallType.FUNCTIONAL, Block.NULL_BLOCK);
                    }
                    catch (RaiseException re) {
                        RubyException rubyEx = re.getException();
                        if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) break block8;
                        throw re;
                    }
                }
            }
        }
        return io;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    protected void checkInitialized() {
        if (this.openFile == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    protected void checkClosed() {
        if (this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.getRuntime();
        try {
            int read;
            RubyString string = obj.asString();
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime);
            Stream writeStream = myOpenFile.getWriteStream();
            if (myOpenFile.isWriteBuffered()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "syswrite for buffered IO", new Object[0]);
            }
            if (!writeStream.getDescriptor().isWritable()) {
                myOpenFile.checkClosed(runtime);
            }
            if ((read = writeStream.getDescriptor().write(string.getByteList())) == -1) {
                // empty if block
            }
            return runtime.newFixnum(read);
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newSystemCallError(e.getMessage());
        }
    }

    @JRubyMethod(name={"write_nonblock"}, required=1)
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject obj) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkWritable(context.getRuntime());
        }
        catch (IOException ex) {
            throw context.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw context.getRuntime().newErrnoEPIPEError();
        }
        return this.write(context, obj);
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.getRuntime();
        runtime.secure(4);
        RubyString str = obj.asString();
        if (str.getByteList().length() == 0) {
            return runtime.newFixnum(0);
        }
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime);
            int written = this.fwrite(str.getByteList());
            if (written == -1) {
                // empty if block
            }
            if (!myOpenFile.isSync()) {
                myOpenFile.setWriteBuffered();
            }
            return runtime.newFixnum(written);
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw runtime.newErrnoEPIPEError();
        }
    }

    protected boolean waitWritable(ChannelDescriptor descriptor) throws IOException {
        Channel channel = descriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        Selector selector = Selector.open();
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & 4;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, descriptor);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
        while (selector.select() == 0) {
        }
        for (SelectionKey skey : selector.selectedKeys()) {
            if ((skey.interestOps() & skey.readyOps() & 4) == 0 || skey.attachment() != descriptor) continue;
            return true;
        }
        return false;
    }

    protected boolean waitReadable(ChannelDescriptor descriptor) throws IOException {
        Channel channel = descriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        Selector selector = Selector.open();
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & 0x11;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, descriptor);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
        while (selector.select() == 0) {
        }
        for (SelectionKey skey : selector.selectedKeys()) {
            if ((skey.interestOps() & skey.readyOps() & 0x11) == 0 || skey.attachment() != descriptor) continue;
            return true;
        }
        return false;
    }

    protected int fwrite(ByteList buffer) {
        int offset = 0;
        boolean eagain = false;
        Stream writeStream = this.openFile.getWriteStream();
        int len = buffer.length();
        int n = len;
        if (n <= 0) {
            return n;
        }
        try {
            if (this.openFile.isSync()) {
                this.openFile.fflush(writeStream);
                while (offset < len) {
                    int l = n;
                    int r = writeStream.getDescriptor().write(buffer, offset, l);
                    if (r == len) {
                        return len;
                    }
                    if (0 <= r) {
                        offset += r;
                        n -= r;
                        eagain = true;
                    }
                    if (eagain && this.waitWritable(writeStream.getDescriptor())) {
                        this.openFile.checkClosed(this.getRuntime());
                        if (offset >= buffer.length()) {
                            return -1;
                        }
                        eagain = false;
                        continue;
                    }
                    return -1;
                }
            }
            return writeStream.fwrite(buffer);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        this.callMethod(context, "write", anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().getDescriptor().getFileno());
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(ThreadContext context, IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(newLineNumber));
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync(ThreadContext context) {
        return context.getRuntime().newBoolean(this.getOpenFileChecked().getMainStream().isSync());
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid(ThreadContext context) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return context.getRuntime().getNil();
        }
        int pid = myOpenFile.getProcess().hashCode();
        return context.getRuntime().newFixnum(pid);
    }

    public boolean writeDataBuffered() {
        return this.openFile.getMainStream().writeDataBuffered();
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos(ThreadContext context) {
        try {
            return context.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().fgetpos());
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException bde) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(ThreadContext context, IRubyObject newPosition) {
        long offset = RubyNumeric.num2long(newPosition);
        if (offset < 0L) {
            throw context.getRuntime().newSystemCallError("Negative seek offset");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.getMainStream().lseek(offset, 0);
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return context.getRuntime().newFixnum(offset);
    }

    @JRubyMethod(name={"print"}, rest=true, reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context, IRubyObject[] args) {
        if (args.length == 0) {
            args = new IRubyObject[]{context.getCurrentFrame().getLastLine()};
        }
        Ruby runtime = context.getRuntime();
        IRubyObject fs = runtime.getGlobalVariables().get("$,");
        IRubyObject rs = runtime.getGlobalVariables().get("$\\");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && !fs.isNil()) {
                this.callMethod(context, "write", fs);
            }
            if (args[i].isNil()) {
                this.callMethod(context, "write", runtime.newString("nil"));
                continue;
            }
            this.callMethod(context, "write", args[i]);
        }
        if (!rs.isNil()) {
            this.callMethod(context, "write", rs);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args) {
        this.callMethod(context, "write", RubyKernel.sprintf(context, this, args));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1, backtrace=true)
    public IRubyObject putc(ThreadContext context, IRubyObject object) {
        byte c = RubyNumeric.num2chr(object);
        try {
            this.getOpenFileChecked().getMainStream().fputc(c);
        }
        catch (BadDescriptorException e) {
            return RubyFixnum.zero(context.getRuntime());
        }
        catch (IOException e) {
            return RubyFixnum.zero(context.getRuntime());
        }
        return object;
    }

    public RubyFixnum seek(ThreadContext context, IRubyObject[] args) {
        long offset = RubyNumeric.num2long(args[0]);
        int whence = 0;
        if (args.length > 1) {
            whence = RubyNumeric.fix2int(args[1].convertToInteger());
        }
        return this.doSeek(context, offset, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0) {
        long offset = RubyNumeric.num2long(arg0);
        int whence = 0;
        return this.doSeek(context, offset, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        long offset = RubyNumeric.num2long(arg0);
        int whence = RubyNumeric.fix2int(arg1.convertToInteger());
        return this.doSeek(context, offset, whence);
    }

    private RubyFixnum doSeek(ThreadContext context, long offset, int whence) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.seek(offset, whence);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"sysseek"}, required=1, optional=1)
    public RubyFixnum sysseek(ThreadContext context, IRubyObject[] args) {
        long pos;
        long offset = RubyNumeric.num2long(args[0]);
        int whence = 0;
        if (args.length > 1) {
            whence = RubyNumeric.fix2int(args[1].convertToInteger());
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            if (myOpenFile.isReadable() && myOpenFile.isReadBuffered()) {
                throw context.getRuntime().newIOError("sysseek for buffered IO");
            }
            if (myOpenFile.isWritable() && myOpenFile.isWriteBuffered()) {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSSEEK_BUFFERED_IO, "sysseek for buffered IO", new Object[0]);
            }
            pos = myOpenFile.getMainStream().getDescriptor().lseek(offset, whence);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return context.getRuntime().newFixnum(pos);
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind(ThreadContext context) {
        OpenFile myOpenfile = this.getOpenFileChecked();
        try {
            myOpenfile.getMainStream().lseek(0L, 0);
            myOpenfile.getMainStream().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenfile.setLineNumber(0);
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime);
            myOpenFile.getWriteStream().sync();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject newSync) {
        this.getOpenFileChecked().setSync(newSync.isTrue());
        this.getOpenFileChecked().getMainStream().setSync(newSync.isTrue());
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStream().feof()) {
                return runtime.getTrue();
            }
            if (myOpenFile.getMainStream().readDataBuffered()) {
                return runtime.getFalse();
            }
            this.readCheck(myOpenFile.getMainStream());
            myOpenFile.getMainStream().clearerr();
            int c = myOpenFile.getMainStream().fgetc();
            if (c != -1) {
                myOpenFile.getMainStream().ungetc(c);
                return runtime.getFalse();
            }
            myOpenFile.checkClosed(runtime);
            myOpenFile.getMainStream().clearerr();
            return runtime.getTrue();
        }
        catch (PipeException ex) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p(ThreadContext context) {
        return context.getRuntime().newBoolean(context.getRuntime().getPosix().isatty(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor()));
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        Ruby runtime = this.getRuntime();
        if (this == original) {
            return this;
        }
        RubyIO originalIO = (RubyIO)TypeConverter.convertToTypeWithCheck(original, runtime.getIO(), MethodIndex.TO_IO, "to_io");
        OpenFile originalFile = originalIO.getOpenFileChecked();
        OpenFile newFile = this.openFile;
        try {
            originalFile.checkClosed(runtime);
            if (originalFile.getPipeStream() != null) {
                originalFile.getPipeStream().fflush();
                originalFile.getMainStream().lseek(0L, 1);
            } else if (originalFile.isWritable()) {
                originalFile.getMainStream().fflush();
            } else {
                originalFile.getMainStream().lseek(0L, 1);
            }
            newFile.setMode(originalFile.getMode());
            newFile.setProcess(originalFile.getProcess());
            newFile.setLineNumber(originalFile.getLineNumber());
            newFile.setPath(originalFile.getPath());
            newFile.setFinalizer(originalFile.getFinalizer());
            ModeFlags modes = newFile.isReadable() ? (newFile.isWritable() ? (newFile.getPipeStream() != null ? new ModeFlags(0L) : new ModeFlags(2L)) : new ModeFlags(0L)) : (newFile.isWritable() ? new ModeFlags(1L) : originalFile.getMainStream().getModes());
            ChannelDescriptor descriptor = originalFile.getMainStream().getDescriptor().dup();
            newFile.setMainStream(ChannelStream.fdopen(runtime, descriptor, modes));
            this.registerDescriptor(newFile.getMainStream().getDescriptor());
        }
        catch (IOException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        catch (PipeException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        catch (InvalidValueException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null);
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        Ruby runtime = this.getRuntime();
        if (runtime.getSafeLevel() >= 4 && this.isTaint()) {
            throw runtime.newSecurityError("Insecure: can't close");
        }
        this.openFile.checkClosed(runtime);
        return this.close2(runtime);
    }

    protected IRubyObject close2(Ruby runtime) {
        if (this.openFile == null) {
            return runtime.getNil();
        }
        this.interruptBlockingThreads();
        if (this.openFile.getPipeStream() != null) {
            ChannelDescriptor pipe = this.openFile.getPipeStream().getDescriptor();
        } else {
            if (this.openFile.getMainStream() == null) {
                return runtime.getNil();
            }
            Object pipe = null;
        }
        ChannelDescriptor main = this.openFile.getMainStream().getDescriptor();
        this.openFile.cleanup(runtime, true);
        if (this.openFile.getProcess() != null) {
            try {
                RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime, this.openFile.getProcess().waitFor());
                runtime.getGlobalVariables().set("$?", processResult);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write(ThreadContext context) throws BadDescriptorException {
        try {
            if (context.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw context.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isReadable()) {
                throw context.getRuntime().newIOError("closing non-duplex IO for writing");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getPipeStream().fclose();
                myOpenFile.setPipeStream(null);
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFD);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read(ThreadContext context) throws BadDescriptorException {
        Ruby runtime = context.getRuntime();
        try {
            if (runtime.getSafeLevel() >= 4 && this.isTaint()) {
                throw runtime.newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isWritable()) {
                throw runtime.newIOError("closing non-duplex IO for reading");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getMainStream().fclose();
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFE);
                myOpenFile.setMainStream(myOpenFile.getPipeStream());
                myOpenFile.setPipeStream(null);
            }
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.getOpenFileChecked().getWriteStream().fflush();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject[] args) {
        ByteList separator;
        Ruby runtime = context.getRuntime();
        IRubyObject result = this.getline(runtime, separator = this.getSeparatorForGets(runtime, args));
        if (!result.isNil()) {
            context.getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    public boolean getBlocking() {
        return ((ChannelStream)this.openFile.getMainStream()).isBlocking();
    }

    @JRubyMethod(name={"fcntl"}, required=2)
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd, IRubyObject arg) {
        return this.ctl(context.getRuntime(), cmd, arg);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(ThreadContext context, IRubyObject[] args) {
        IRubyObject cmd = args[0];
        IRubyObject arg = args.length == 2 ? args[1] : context.getRuntime().getNil();
        return this.ctl(context.getRuntime(), cmd, arg);
    }

    public IRubyObject ctl(Ruby runtime, IRubyObject cmd, IRubyObject arg) {
        long realCmd = cmd.convertToInteger().getLongValue();
        long nArg = 0L;
        if (arg.isNil() || arg == runtime.getFalse()) {
            nArg = 0L;
        } else if (arg instanceof RubyFixnum) {
            nArg = RubyFixnum.fix2long(arg);
        } else if (arg == runtime.getTrue()) {
            nArg = 1L;
        } else {
            throw runtime.newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (realCmd == 1L) {
            boolean block = true;
            if ((nArg & 4L) == 4L) {
                block = false;
            }
            try {
                myOpenFile.getMainStream().setBlocking(block);
            }
            catch (IOException e) {
                throw runtime.newIOError(e.getMessage());
            }
        } else {
            throw runtime.newNotImplementedError("JRuby only supports F_SETFL for fcntl/ioctl currently");
        }
        return runtime.newFixnum(0);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        if (args.length == 0) {
            this.write(context, separator.getByteList());
            return runtime.getNil();
        }
        for (int i = 0; i < args.length; ++i) {
            ByteList line;
            if (args[i].isNil()) {
                line = NIL_BYTELIST;
            } else if (runtime.isInspecting(args[i])) {
                line = RECURSIVE_BYTELIST;
            } else {
                if (args[i] instanceof RubyArray) {
                    this.inspectPuts(context, (RubyArray)args[i]);
                    continue;
                }
                line = args[i].asString().getByteList();
            }
            this.write(context, line);
            if (line.length() != 0 && line.endsWith(separator.getByteList())) continue;
            this.write(context, separator.getByteList());
        }
        return runtime.getNil();
    }

    protected void write(ThreadContext context, ByteList byteList) {
        this.callMethod(context, "write", RubyString.newStringShared(context.getRuntime(), byteList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext context, RubyArray array) {
        try {
            context.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = this.puts(context, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            context.getRuntime().unregisterInspecting(array);
        }
    }

    @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject[] args) {
        IRubyObject line = this.gets(context, args);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            Stream stream = myOpenFile.getMainStream();
            this.readCheck(stream);
            stream.clearerr();
            int c = myOpenFile.getMainStream().fgetc();
            if (c == -1) {
                return this.getRuntime().getNil();
            }
            return this.getRuntime().newFixnum(c);
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    private void readCheck(Stream stream) {
        if (!stream.readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject number) {
        int ch = RubyNumeric.fix2int(number);
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            throw this.getRuntime().newIOError("unread stream");
        }
        try {
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStream().ungetc(ch) == -1 && ch != -1) {
                throw this.getRuntime().newIOError("ungetc failed");
            }
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=1)
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        this.openFile.checkClosed(runtime);
        if (!(this.openFile.getMainStream() instanceof ChannelStream)) {
            throw runtime.newNotImplementedError("read_nonblock only works with Nio based handlers");
        }
        try {
            int maxLength = RubyNumeric.fix2int(args[0]);
            if (maxLength < 0) {
                throw runtime.newArgumentError("negative length " + maxLength + " given");
            }
            ByteList buf = ((ChannelStream)this.openFile.getMainStream()).readnonblock(RubyNumeric.fix2int(args[0]));
            RubyString strbuf = RubyString.newString(runtime, buf == null ? new ByteList(ByteList.NULL_ARRAY) : buf);
            if (args.length > 1) {
                args[1].callMethod(context, MethodIndex.OP_LSHIFT, "<<", strbuf);
                return args[1];
            }
            return strbuf;
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        this.openFile.checkClosed(runtime);
        if (!(this.openFile.getMainStream() instanceof ChannelStream)) {
            throw runtime.newNotImplementedError("readpartial only works with Nio based handlers");
        }
        try {
            int maxLength = RubyNumeric.fix2int(args[0]);
            if (maxLength < 0) {
                throw runtime.newArgumentError("negative length " + maxLength + " given");
            }
            ByteList buf = ((ChannelStream)this.openFile.getMainStream()).readpartial(RubyNumeric.fix2int(args[0]));
            RubyString strbuf = RubyString.newString(runtime, buf == null ? new ByteList(ByteList.NULL_ARRAY) : buf);
            if (args.length > 1) {
                args[1].callMethod(context, MethodIndex.OP_LSHIFT, "<<", strbuf);
                return args[1];
            }
            return strbuf;
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args) {
        int len = (int)RubyNumeric.num2long(args[0]);
        if (len < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString str;
            if (args.length == 1 || args[1].isNil()) {
                if (len == 0) {
                    RubyString rubyString = RubyString.newStringShared(this.getRuntime(), ByteList.EMPTY_BYTELIST);
                    return rubyString;
                }
                ByteList buffer = new ByteList(len);
                str = RubyString.newString(this.getRuntime(), buffer);
            } else {
                str = args[1].convertToString();
                str.modify(len);
                if (len == 0) {
                    RubyString rubyString = str;
                    return rubyString;
                }
                ByteList buffer = str.getByteList();
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStream().readDataBuffered()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
            context.getThread().beforeBlockingCall();
            myOpenFile.checkClosed(this.getRuntime());
            int bytesRead = myOpenFile.getMainStream().getDescriptor().read(len, str.getByteList());
            if (bytesRead == -1 || bytesRead == 0 && len > 0) {
                throw this.getRuntime().newEOFError();
            }
            str.setTaint(true);
            RubyString rubyString = str;
            return rubyString;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            if ("File not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    public IRubyObject read(IRubyObject[] args) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        switch (args.length) {
            case 0: {
                return this.read(context);
            }
            case 1: {
                return this.read(context, args[0]);
            }
            case 2: {
                return this.read(context, args[0], args[1]);
            }
        }
        throw this.getRuntime().newArgumentError(args.length, 2);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            return this.readAll(this.getRuntime().getNil());
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException ex) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0) {
        if (arg0.isNil()) {
            return this.read(context);
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        int length = RubyNumeric.num2int(arg0);
        if (length < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length + " given");
        }
        RubyString str = null;
        return this.readNotAll(context, myOpenFile, length, str);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (arg0.isNil()) {
            try {
                myOpenFile.checkReadable(this.getRuntime());
                myOpenFile.setReadBuffered();
                return this.readAll(arg1);
            }
            catch (PipeException ex) {
                throw this.getRuntime().newErrnoEPIPEError();
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (EOFException ex) {
                throw this.getRuntime().newEOFError();
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw this.getRuntime().newErrnoEBADFError();
            }
        }
        int length = RubyNumeric.num2int(arg0);
        if (length < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length + " given");
        }
        RubyString str = null;
        if (!arg1.isNil()) {
            str = arg1.convertToString();
            str.modify(length);
            if (length == 0) {
                return str;
            }
        }
        return this.readNotAll(context, myOpenFile, length, str);
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length, RubyString str) {
        Ruby runtime = context.getRuntime();
        try {
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStream().feof()) {
                return runtime.getNil();
            }
            this.readCheck(myOpenFile.getMainStream());
            ByteList newBuffer = myOpenFile.getMainStream().fread(length);
            if (newBuffer == null || newBuffer.length() == 0) {
                if (myOpenFile.getMainStream() == null) {
                    return runtime.getNil();
                }
                if (myOpenFile.getMainStream().feof()) {
                    if (str != null) {
                        str.setValue(ByteList.EMPTY_BYTELIST.dup());
                    }
                    return runtime.getNil();
                }
            }
            if (str == null) {
                str = newBuffer == null ? RubyString.newEmptyString(runtime) : RubyString.newString(runtime, newBuffer);
            } else if (newBuffer == null) {
                str.empty();
            } else {
                str.setValue(newBuffer);
            }
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime.newEOFError();
        }
        catch (PipeException ex) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
    }

    protected IRubyObject readAll(IRubyObject buffer) throws BadDescriptorException, EOFException, IOException {
        Ruby runtime = this.getRuntime();
        RubyString str = null;
        if (buffer instanceof RubyString) {
            str = (RubyString)buffer;
        }
        if (this.openFile.getMainStream().readDataBuffered()) {
            this.openFile.checkClosed(runtime);
        }
        ByteList newBuffer = this.openFile.getMainStream().readall();
        if (str == null) {
            str = newBuffer == null ? RubyString.newEmptyString(runtime) : RubyString.newString(runtime, newBuffer);
        } else if (newBuffer == null) {
            str.empty();
        } else {
            str.setValue(newBuffer);
        }
        str.taint(runtime.getCurrentContext());
        return str;
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        this.openFile.checkClosed(context.getRuntime());
        return context.getRuntime().newFileStat(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor());
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(ThreadContext context, Block block) {
        Ruby runtime = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            while (true) {
                myOpenFile.checkReadable(runtime);
                myOpenFile.setReadBuffered();
                int c = myOpenFile.getMainStream().fgetc();
                if (c == -1) break;
                assert (c < 256);
                block.yield(context, this.getRuntime().newFixnum(c));
            }
            return this;
        }
        catch (PipeException ex) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"each_line", "each"}, optional=1, frame=true)
    public RubyIO each_line(ThreadContext context, IRubyObject[] args, Block block) {
        Ruby runtime = context.getRuntime();
        ByteList separator = this.getSeparatorForGets(runtime, args);
        IRubyObject line = this.getline(runtime, separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getline(runtime, separator);
        }
        return this;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public RubyArray readlines(ThreadContext context, IRubyObject[] args) {
        IRubyObject line;
        IRubyObject[] iRubyObjectArray;
        Ruby runtime = context.getRuntime();
        if (args.length > 0) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args[0];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArgs = iRubyObjectArray;
        ByteList separator = this.getSeparatorForGets(runtime, separatorArgs);
        RubyArray result = runtime.newArray();
        while (!(line = this.getline(runtime, separator)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        return "RubyIO(" + this.openFile.getMode() + ", " + this.openFile.getMainStream().getDescriptor().getFileno() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"foreach"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = context.getRuntime();
        int count = args.length;
        RubyString filename = args[0].convertToString();
        runtime.checkSafeString(filename);
        ByteList separator = RubyIO.getSeparatorFromArgs(runtime, args, 1);
        RubyIO io = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename}, Block.NULL_BLOCK);
        if (!io.isNil()) {
            try {
                IRubyObject str = io.getline(runtime, separator);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io.getline(runtime, separator);
                }
            }
            finally {
                io.close();
            }
        }
        return runtime.getNil();
    }

    private static RubyIO convertToIO(ThreadContext context, IRubyObject obj) {
        return (RubyIO)TypeConverter.convertToType(obj, context.getRuntime().getIO(), MethodIndex.TO_IO, "to_io");
    }

    private static boolean registerSelect(ThreadContext context, Selector selector, IRubyObject obj, RubyIO ioObj, int ops) throws IOException {
        Channel channel = ioObj.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & ops;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, obj);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
        return true;
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        return RubyIO.select_static(context, context.getRuntime(), args);
    }

    private static void checkArrayType(Ruby runtime, IRubyObject obj) {
        if (!(obj instanceof RubyArray)) {
            throw runtime.newTypeError("wrong argument type " + obj.getMetaClass().getName() + " (expected Array)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject select_static(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        try {
            RubyIO ioObj;
            HashSet<IRubyObject> pending = new HashSet<IRubyObject>();
            HashSet<IRubyObject> unselectable_reads = new HashSet<IRubyObject>();
            HashSet<IRubyObject> unselectable_writes = new HashSet<IRubyObject>();
            Selector selector = Selector.open();
            if (!args[0].isNil()) {
                RubyIO.checkArrayType(runtime, args[0]);
                for (IRubyObject obj : ((RubyArray)args[0]).getList()) {
                    if (RubyIO.registerSelect(context, selector, obj, ioObj = RubyIO.convertToIO(context, obj), 17)) {
                        if (!ioObj.writeDataBuffered()) continue;
                        pending.add(obj);
                        continue;
                    }
                    if ((ioObj.openFile.getMode() & 1) == 0) continue;
                    unselectable_reads.add(obj);
                }
            }
            if (args.length > 1 && !args[1].isNil()) {
                RubyIO.checkArrayType(runtime, args[1]);
                for (IRubyObject obj : ((RubyArray)args[1]).getList()) {
                    if (RubyIO.registerSelect(context, selector, obj, ioObj = RubyIO.convertToIO(context, obj), 4) || (ioObj.openFile.getMode() & 2) == 0) continue;
                    unselectable_writes.add(obj);
                }
            }
            if (args.length > 2 && !args[2].isNil()) {
                RubyIO.checkArrayType(runtime, args[2]);
            }
            boolean has_timeout = args.length > 3 && !args[3].isNil();
            long timeout = 0L;
            if (has_timeout) {
                IRubyObject timeArg = args[3];
                if (timeArg instanceof RubyFloat) {
                    timeout = Math.round(((RubyFloat)timeArg).getDoubleValue() * 1000.0);
                } else if (timeArg instanceof RubyFixnum) {
                    timeout = Math.round(((RubyFixnum)timeArg).getDoubleValue() * 1000.0);
                } else {
                    throw runtime.newTypeError("can't convert " + timeArg.getMetaClass().getName() + " into time interval");
                }
                if (timeout < 0L) {
                    throw runtime.newArgumentError("negative timeout given");
                }
            }
            if (pending.isEmpty() && unselectable_reads.isEmpty() && unselectable_writes.isEmpty()) {
                if (has_timeout) {
                    if (timeout == 0L) {
                        selector.selectNow();
                    } else {
                        selector.select(timeout);
                    }
                } else {
                    selector.select();
                }
            } else {
                selector.selectNow();
            }
            ArrayList<Object> r = new ArrayList<Object>();
            ArrayList<Object> w = new ArrayList<Object>();
            ArrayList e = new ArrayList();
            for (SelectionKey key : selector.selectedKeys()) {
                if ((key.interestOps() & key.readyOps() & 0x19) != 0) {
                    r.add(key.attachment());
                    pending.remove(key.attachment());
                }
                if ((key.interestOps() & key.readyOps() & 4) == 0) continue;
                w.add(key.attachment());
            }
            r.addAll(pending);
            r.addAll(unselectable_reads);
            w.addAll(unselectable_writes);
            for (SelectionKey key : selector.keys()) {
                SelectableChannel channel = key.channel();
                Object object = channel.blockingLock();
                synchronized (object) {
                    RubyIO originalIO = (RubyIO)TypeConverter.convertToType((IRubyObject)key.attachment(), runtime.getIO(), MethodIndex.TO_IO, "to_io");
                    boolean blocking = originalIO.getBlocking();
                    key.cancel();
                    channel.configureBlocking(blocking);
                }
            }
            selector.close();
            if (r.size() == 0 && w.size() == 0 && e.size() == 0) {
                return runtime.getNil();
            }
            ArrayList<RubyArray> ret = new ArrayList<RubyArray>();
            ret.add(RubyArray.newArray(runtime, r));
            ret.add(RubyArray.newArray(runtime, w));
            ret.add(RubyArray.newArray(runtime, e));
            return RubyArray.newArray(runtime, ret);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    public static IRubyObject read(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        switch (args.length) {
            case 0: {
                throw context.getRuntime().newArgumentError(0, 1);
            }
            case 1: {
                return RubyIO.read(context, recv, args[0], block);
            }
            case 2: {
                return RubyIO.read(context, recv, args[0], args[1], block);
            }
            case 3: {
                return RubyIO.read(context, recv, args[0], args[1], args[2], block);
            }
        }
        throw context.getRuntime().newArgumentError(args.length, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv, IRubyObject arg0, Block block) {
        IRubyObject[] fileArguments = new IRubyObject[]{arg0};
        RubyIO file = (RubyIO)RubyKernel.open(context, recv, fileArguments, block);
        try {
            IRubyObject iRubyObject = file.read(context);
            return iRubyObject;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject[] fileArguments = new IRubyObject[]{arg0};
        RubyIO file = (RubyIO)RubyKernel.open(context, recv, fileArguments, block);
        try {
            if (!arg1.isNil()) {
                IRubyObject iRubyObject = file.read(context, arg1);
                return iRubyObject;
            }
            IRubyObject iRubyObject = file.read(context);
            return iRubyObject;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject[] fileArguments = new IRubyObject[]{arg0};
        RubyIO file = (RubyIO)RubyKernel.open(context, recv, fileArguments, block);
        if (!arg2.isNil()) {
            file.seek(context, arg2);
        }
        try {
            if (!arg1.isNil()) {
                IRubyObject iRubyObject = file.read(context, arg1);
                return iRubyObject;
            }
            IRubyObject iRubyObject = file.read(context);
            return iRubyObject;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject[] iRubyObjectArray;
        int count = args.length;
        IRubyObject[] fileArguments = new IRubyObject[]{args[0].convertToString()};
        if (count >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        RubyIO file = (RubyIO)RubyKernel.open(context, recv, fileArguments, block);
        try {
            RubyArray rubyArray = file.readlines(context, separatorArguments);
            return rubyArray;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject iRubyObject;
        ShellLauncher.POpenProcess process;
        Ruby runtime;
        block9: {
            runtime = context.getRuntime();
            RubyString cmdObj = args[0].convertToString();
            runtime.checkSafeString(cmdObj);
            if ("-".equals(((Object)cmdObj).toString())) {
                throw runtime.newNotImplementedError("popen(\"-\") is unimplemented");
            }
            int mode = args.length == 1 ? 0 : (args[1] instanceof RubyFixnum ? RubyFixnum.num2int(args[1]) : RubyIO.getIOModesIntFromString(runtime, args[1].convertToString().toString()));
            ModeFlags modes = new ModeFlags(mode);
            process = ShellLauncher.popen(runtime, cmdObj, modes);
            RubyIO io = new RubyIO(runtime, process, modes);
            if (!block.isGiven()) return io;
            try {
                iRubyObject = block.yield(context, io);
                if (!io.openFile.isOpen()) break block9;
                io.close();
            }
            catch (Throwable throwable) {
                try {
                    if (io.openFile.isOpen()) {
                        io.close();
                    }
                    runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() * 256));
                    throw throwable;
                }
                catch (InvalidValueException ex) {
                    throw runtime.newErrnoEINVALError();
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
                catch (InterruptedException e) {
                    throw runtime.newThreadError("unexpected interrupt");
                }
            }
        }
        runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() * 256));
        return iRubyObject;
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(ThreadContext context, IRubyObject recv) throws Exception {
        Ruby runtime = context.getRuntime();
        Pipe pipe = Pipe.open();
        RubyIO source = new RubyIO(runtime, pipe.source());
        RubyIO sink = new RubyIO(runtime, pipe.sink());
        sink.openFile.getMainStream().setSync(true);
        return runtime.newArrayNoCopy(new IRubyObject[]{source, sink});
    }

    @JRubyMethod(name={"copy_stream"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv, IRubyObject stream1, IRubyObject stream2) throws IOException {
        RubyIO io1 = (RubyIO)stream1;
        RubyIO io2 = (RubyIO)stream2;
        ChannelDescriptor d1 = io1.openFile.getMainStream().getDescriptor();
        if (!d1.isSeekable()) {
            throw context.getRuntime().newTypeError("only supports file-to-file copy");
        }
        ChannelDescriptor d2 = io2.openFile.getMainStream().getDescriptor();
        if (!d2.isSeekable()) {
            throw context.getRuntime().newTypeError("only supports file-to-file copy");
        }
        FileChannel f1 = (FileChannel)d1.getChannel();
        FileChannel f2 = (FileChannel)d2.getChannel();
        long size = f1.size();
        f1.transferTo(f2.position(), size, f2);
        return context.getRuntime().newFixnum(size);
    }

    public synchronized void addBlockingThread(RubyThread thread) {
        if (this.blockingThreads == null) {
            this.blockingThreads = new ArrayList<RubyThread>(1);
        }
        this.blockingThreads.add(thread);
    }

    public synchronized void removeBlockingThread(RubyThread thread) {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i = 0; i < this.blockingThreads.size(); ++i) {
            if (this.blockingThreads.get(i) != thread) continue;
            this.blockingThreads.remove(i);
        }
    }

    protected synchronized void interruptBlockingThreads() {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i = 0; i < this.blockingThreads.size(); ++i) {
            RubyThread thread = this.blockingThreads.get(i);
            thread.raise(new IRubyObject[]{this.getRuntime().newIOError("stream closed").getException()}, Block.NULL_BLOCK);
        }
    }
}

