/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.util.StringTokenizer;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;

public class ClipData
extends PropertyData {
    PropertyWithUnitData topValue = new PropertyWithUnitData();
    PropertyWithUnitData bottomValue = new PropertyWithUnitData();
    PropertyWithUnitData leftValue = new PropertyWithUnitData();
    PropertyWithUnitData rightValue = new PropertyWithUnitData();

    public void setClip(String clip) {
        this.topValue.clear();
        this.bottomValue.clear();
        this.leftValue.clear();
        this.rightValue.clear();
        if (clip != null) {
            int start = clip.indexOf("(");
            int stop = clip.indexOf(")");
            if (start != -1 && stop != -1) {
                String clipString = clip.substring(start + 1, stop);
                StringTokenizer st = new StringTokenizer(clipString, ",");
                if (st.hasMoreTokens()) {
                    this.setTop(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setRight(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setBottom(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.setLeft(st.nextToken());
                }
            }
        }
    }

    public void setTop(String clipTopStr) {
        this.topValue.setData(clipTopStr);
    }

    public void setBottom(String clipBottomStr) {
        this.bottomValue.setData(clipBottomStr);
    }

    public void setLeft(String clipLeftStr) {
        this.leftValue.setData(clipLeftStr);
    }

    public void setRight(String clipRightStr) {
        this.rightValue.setData(clipRightStr);
    }

    public void setTopValue(String top) {
        this.topValue.setValue(top);
    }

    public void setTopUnit(String topUnit) {
        this.topValue.setUnit(topUnit);
    }

    public void setBottomValue(String bottom) {
        this.bottomValue.setValue(bottom);
    }

    public void setBottomUnit(String bottomUnit) {
        this.bottomValue.setUnit(bottomUnit);
    }

    public void setLeftValue(String left) {
        this.leftValue.setValue(left);
    }

    public void setLeftUnit(String leftUnit) {
        this.leftValue.setUnit(leftUnit);
    }

    public void setRightValue(String right) {
        this.rightValue.setValue(right);
    }

    public void setRightUnit(String rightUnit) {
        this.rightValue.setUnit(rightUnit);
    }

    public String getTopValue() {
        return this.topValue.getValue();
    }

    public String getTopUnit() {
        return this.topValue.getUnit();
    }

    public String getBottomValue() {
        return this.bottomValue.getValue();
    }

    public String getBottomUnit() {
        return this.bottomValue.getUnit();
    }

    public String getLeftValue() {
        return this.leftValue.getValue();
    }

    public String getLeftUnit() {
        return this.leftValue.getUnit();
    }

    public String getRightValue() {
        return this.rightValue.getValue();
    }

    public String getRightUnit() {
        return this.rightValue.getUnit();
    }

    public boolean isTopValueInteger() {
        return this.topValue.isValueInteger();
    }

    public boolean isBottomValueInteger() {
        return this.bottomValue.isValueInteger();
    }

    public boolean isLeftValueInteger() {
        return this.leftValue.isValueInteger();
    }

    public boolean isRightValueInteger() {
        return this.rightValue.isValueInteger();
    }

    @Override
    public String toString() {
        if (!(this.topValue.hasValue() || this.rightValue.hasValue() || this.bottomValue.hasValue() || this.leftValue.hasValue())) {
            return "";
        }
        String clipString = "";
        clipString = this.topValue.hasValue() ? clipString + " " + this.topValue.toString() : clipString + " 0px";
        clipString = this.rightValue.hasValue() ? clipString + ", " + this.rightValue.toString() : clipString + ", 0px";
        clipString = this.bottomValue.hasValue() ? clipString + ", " + this.bottomValue.toString() : clipString + ", 0px";
        clipString = this.leftValue.hasValue() ? clipString + ", " + this.leftValue.toString() : clipString + ", 0px";
        clipString = "rect(" + clipString.trim() + ")";
        return clipString.trim();
    }
}

