/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.ruby.RubyType;

final class RailsMigrationTypeMapper {
    private final Map<String, RubyType> types = new HashMap<String, RubyType>();
    private static final RailsMigrationTypeMapper INSTANCE = new RailsMigrationTypeMapper();

    private RailsMigrationTypeMapper() {
        this.init();
    }

    private void init() {
        this.types.put("binary", RubyType.STRING);
        this.types.put("boolean", RubyType.BOOLEAN);
        this.types.put("date", RubyType.DATE);
        this.types.put("datetime", RubyType.TIME);
        this.types.put("decimal", RubyType.FIXNUM);
        this.types.put("float", RubyType.FLOAT);
        this.types.put("integer", RubyType.BIGNUM);
        this.types.put("string", RubyType.STRING);
        this.types.put("text", RubyType.STRING);
        this.types.put("time", RubyType.TIME);
        this.types.put("timestamp", RubyType.TIME);
    }

    static RubyType getMappedType(String migrationType) {
        RubyType result = RailsMigrationTypeMapper.INSTANCE.types.get(migrationType);
        return result != null ? result : RubyType.create(migrationType);
    }
}

