/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.ReaderFactory;
import hidden.org.codehaus.plexus.util.interpolation.EnvarBasedValueSource;
import hidden.org.codehaus.plexus.util.interpolation.PropertiesBasedValueSource;
import hidden.org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import hidden.org.codehaus.plexus.util.xml.XmlStreamReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.maven.compat.Maven20xCompatAspect;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.settings.validation.SettingsValidationResult;
import org.apache.maven.settings.validation.SettingsValidator;
import org.aspectj.internal.lang.annotation.ajcITD;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenSettingsBuilder
extends AbstractLogEnabled
implements MavenSettingsBuilder {
    private SettingsValidator validator;

    public Settings buildSettings(MavenExecutionRequest request) throws IOException, XmlPullParserException {
        File userSettingsFile = request.getUserSettingsFile();
        File globalSettingsFile = request.getGlobalSettingsFile();
        if (globalSettingsFile == null && userSettingsFile == null) {
            this.getLogger().debug("No settings files provided, and default locations are disabled for this request. Returning empty Settings instance.");
            return new Settings();
        }
        this.getLogger().debug("Reading global settings from: " + globalSettingsFile);
        Settings globalSettings = this.readSettings(globalSettingsFile);
        if (globalSettings == null) {
            globalSettings = new Settings();
        }
        this.getLogger().debug("Reading user settings from: " + userSettingsFile);
        Settings userSettings = this.readSettings(userSettingsFile);
        if (userSettings == null) {
            userSettings = new Settings();
        }
        this.validateSettings(globalSettings, globalSettingsFile);
        this.validateSettings(userSettings, userSettingsFile);
        SettingsUtils.merge(userSettings, globalSettings, "global-level");
        userSettings = this.interpolate(userSettings, request);
        return userSettings;
    }

    private Settings interpolate(Settings settings, MavenExecutionRequest request) throws IOException, XmlPullParserException {
        List activeProfiles = settings.getActiveProfiles();
        StringWriter writer = new StringWriter();
        new SettingsXpp3Writer().write(writer, settings);
        String serializedSettings = writer.toString();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource(new PropertiesBasedValueSource(request.getProperties()));
        interpolator.addValueSource(new EnvarBasedValueSource());
        serializedSettings = interpolator.interpolate(serializedSettings, "settings");
        Settings result = new SettingsXpp3Reader().read(new StringReader(serializedSettings));
        result.setActiveProfiles(activeProfiles);
        return result;
    }

    private Settings readSettings(File settingsFile) throws IOException, XmlPullParserException {
        if (settingsFile == null) {
            this.getLogger().debug("Settings file is null. Returning null.");
            return null;
        }
        if (!settingsFile.exists()) {
            this.getLogger().debug("Settings file doesn't exist. Returning null.");
            return null;
        }
        Settings settings = null;
        XmlStreamReader reader = null;
        try {
            try {
                reader = ReaderFactory.newXmlReader(settingsFile);
                SettingsXpp3Reader modelReader = new SettingsXpp3Reader();
                settings = modelReader.read(reader);
            }
            catch (XmlPullParserException e) {
                this.getLogger().error("Failed to read settings from: " + settingsFile + ". Throwing XmlPullParserException...");
                throw e;
            }
            catch (IOException e) {
                this.getLogger().error("Failed to read settings from: " + settingsFile + ". Throwing IOException...");
                throw e;
            }
        }
        finally {
            IOUtil.close(reader);
        }
        return settings;
    }

    private void validateSettings(Settings settings, File location) throws IOException {
        SettingsValidationResult validationResult = this.validator.validate(settings);
        if (validationResult.getMessageCount() > 0) {
            throw new IOException("Failed to validate Settings file at " + location + "\n" + validationResult.render("\n"));
        }
    }

    @ajcITD(targetType="org.apache.maven.settings.DefaultMavenSettingsBuilder", name="buildSettings", modifiers=1)
    public Settings buildSettings() throws IOException, XmlPullParserException {
        return Maven20xCompatAspect.ajc$interMethod$org_apache_maven_compat_Maven20xCompatAspect$org_apache_maven_settings_DefaultMavenSettingsBuilder$buildSettings(this);
    }
}

