/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.dd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.wizards.dd.Utils;
import org.netbeans.modules.web.wizards.dd.WebXmlVisualPanel1;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class WebFragmentXmlVisualPanel1
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String WEB_FRAGMENT_XML = "web-fragment.xml";
    private static final String META_INF = "META-INF";
    private FileObject targetFolder;
    private JTextField createdFileText;
    private JTextField fileNameText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTextField locationText;
    private JTextField projectText;

    public WebFragmentXmlVisualPanel1() {
        this.initComponents();
    }

    void setProject(Project project) {
        this.fileNameText.setText(WEB_FRAGMENT_XML);
        this.projectText.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        FileObject fileObject = Utils.getSourceRoot(project);
        try {
            if (fileObject != null) {
                this.targetFolder = fileObject;
                this.locationText.setText(FileUtil.getFileDisplayName((FileObject)this.targetFolder) + File.separator + META_INF);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.locationText.setText("");
            Logger.global.log(Level.WARNING, NbBundle.getMessage(WebFragmentXmlVisualPanel1.class, (String)"NO_SOURCES_FOUND"), nullPointerException);
        }
        this.refreshLocation();
    }

    FileObject getSelectedLocation() {
        return this.targetFolder;
    }

    File getCreatedFile() {
        return new File(this.createdFileText.getText());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(WebXmlVisualPanel1.class, (String)"LBL_SelectLocation");
    }

    private void refreshLocation() {
        String string = this.locationText.getText();
        if (string != null && !"".equals(string)) {
            this.createdFileText.setText(string + File.separator + WEB_FRAGMENT_XML);
        }
        this.firePropertyChange("", null, null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.fileNameText = new JTextField();
        this.projectText = new JTextField();
        this.locationText = new JTextField();
        this.createdFileText = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.fileNameText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WebXmlVisualPanel1.class, (String)"LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.projectText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WebXmlVisualPanel1.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setLabelFor(this.locationText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WebXmlVisualPanel1.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setLabelFor(this.createdFileText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WebXmlVisualPanel1.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fileNameText.setColumns(40);
        this.fileNameText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.fileNameText, gridBagConstraints);
        this.projectText.setColumns(40);
        this.projectText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.projectText, gridBagConstraints);
        this.locationText.setColumns(40);
        this.locationText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.locationText, gridBagConstraints);
        this.createdFileText.setColumns(40);
        this.createdFileText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.createdFileText, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }
}

