/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.api.phpmodule.PhpFrameworks;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpConfigurationProvider;
import org.netbeans.modules.php.project.PhpEditorExtender;
import org.netbeans.modules.php.project.PhpModuleImpl;
import org.netbeans.modules.php.project.PhpProjectEncodingQueryImpl;
import org.netbeans.modules.php.project.PhpProjectOperations;
import org.netbeans.modules.php.project.PhpSharabilityQuery;
import org.netbeans.modules.php.project.PhpSources;
import org.netbeans.modules.php.project.PhpTemplates;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.TemplateAttributesProviderImpl;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.modules.php.project.api.PhpSeleniumProvider;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.php.project.classpath.IncludePathClassPathProvider;
import org.netbeans.modules.php.project.copysupport.CopySupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.IgnorePathSupport;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class PhpProject
implements Project {
    private static final Icon PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/phpProject.png", (boolean)false);
    static final Logger LOGGER = Logger.getLogger(PhpProject.class.getName());
    final AntProjectHelper helper;
    final UpdateHelper updateHelper;
    private final ReferenceHelper refHelper;
    private final PropertyEvaluator eval;
    private final Lookup lookup;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private final SourceRoots seleniumRoots;
    private final FileObjectFilter fileObjectFilter = new PhpFileObjectFilter();
    volatile FileObject sourcesDirectory;
    volatile FileObject testsDirectory;
    volatile FileObject seleniumDirectory;
    volatile String name;
    private final AntProjectListener phpAntProjectListener = new PhpAntProjectListener();
    private final PropertyChangeListener projectPropertiesListener = new ProjectPropertiesListener();
    volatile Set<BasePathSupport.Item> ignoredFolders;
    final Object ignoredFoldersLock = new Object();
    final ChangeSupport ignoredFoldersChangeSupport = new ChangeSupport((Object)this);
    final Object frameworksLock = new Object();
    List<PhpFrameworkProvider> frameworks;
    private final FileChangeListener sourceDirectoryFileChangeListener = new SourceDirectoryFileChangeListener();
    private final LookupListener frameworksListener = new FrameworksListener();

    public PhpProject(AntProjectHelper helper) {
        assert (helper != null);
        this.helper = helper;
        this.updateHelper = new UpdateHelper(UpdateImplementation.NULL, helper);
        AuxiliaryConfiguration configuration = helper.createAuxiliaryConfiguration();
        this.eval = this.createEvaluator();
        this.refHelper = new ReferenceHelper(helper, configuration, this.getEvaluator());
        this.sourceRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SOURCES);
        this.testRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.TESTS);
        this.seleniumRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SELENIUM);
        this.lookup = this.createLookup(configuration);
        this.addWeakPropertyEvaluatorListener(this.projectPropertiesListener);
        helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.phpAntProjectListener, (Object)helper));
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    void addWeakPropertyEvaluatorListener(PropertyChangeListener listener) {
        this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)this.eval));
    }

    void addWeakIgnoredFilesListener(ChangeListener listener) {
        this.ignoredFoldersChangeSupport.addChangeListener(WeakListeners.change((ChangeListener)listener, (Object)this.ignoredFoldersChangeSupport));
        VisibilityQuery visibilityQuery = VisibilityQuery.getDefault();
        visibilityQuery.addChangeListener(WeakListeners.change((ChangeListener)listener, (Object)visibilityQuery));
    }

    public FileObjectFilter getFileObjectFilter() {
        return this.fileObjectFilter;
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator baseEval1 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties")});
        PropertyEvaluator baseEval2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties"), new ConfigPropertyProvider(baseEval1, "nbproject/private/configs", this.helper), this.helper.getPropertyProvider("nbproject/private/private.properties"), this.helper.getProjectLibrariesPropertyProvider(), PropertyUtils.userPropertiesProvider((PropertyEvaluator)baseEval2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), new ConfigPropertyProvider(baseEval1, "nbproject/configs", this.helper), this.helper.getPropertyProvider("nbproject/project.properties")});
    }

    public FileObject getProjectDirectory() {
        return this.getHelper().getProjectDirectory();
    }

    public SourceRoots getSourceRoots() {
        return this.sourceRoots;
    }

    public SourceRoots getTestRoots() {
        return this.testRoots;
    }

    public SourceRoots getSeleniumRoots() {
        return this.seleniumRoots;
    }

    FileObject getSourcesDirectory() {
        if (this.sourcesDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.sourcesDirectory == null) {
                            PhpProject.this.sourcesDirectory = PhpProject.this.resolveSourcesDirectory();
                            PhpProject.this.sourcesDirectory.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)PhpProject.this.sourceDirectoryFileChangeListener, (Object)PhpProject.this.sourcesDirectory));
                        }
                    }
                    return null;
                }
            });
        }
        assert (this.sourcesDirectory != null) : "Sources directory cannot be null";
        return this.sourcesDirectory;
    }

    private FileObject resolveSourcesDirectory() {
        String srcDirProperty = this.eval.getProperty("src.dir");
        if (srcDirProperty == null) {
            FileObject projectProps = this.helper.getProjectDirectory().getFileObject("nbproject/project.properties");
            boolean projectPropsFound = projectProps != null;
            StringBuilder buffer = new StringBuilder(2000);
            buffer.append("Property 'src.dir' was not found in 'nbproject/project.properties' (NB metadata corrupted?)\n");
            buffer.append("diagnostics:\n");
            buffer.append("project.properties exists: ");
            buffer.append(projectPropsFound);
            if (projectPropsFound) {
                boolean canRead = projectProps.canRead();
                buffer.append("\nproject.properties valid: ");
                buffer.append(projectProps.isValid());
                buffer.append("\nproject.properties can read: ");
                buffer.append(canRead);
                if (canRead) {
                    buffer.append("\nproject.properties content: [");
                    try {
                        buffer.append(projectProps.asText());
                    }
                    catch (IOException exc) {
                        buffer.append(exc.getMessage());
                    }
                    buffer.append("]");
                }
            } else {
                FileObject projectDirectory = this.getProjectDirectory();
                buffer.append("\nproject directory: ");
                buffer.append(projectDirectory);
                buffer.append("\nproject directory children: ");
                buffer.append(Arrays.asList(projectDirectory.getChildren()));
                FileObject nbproject = projectDirectory.getFileObject("nbproject");
                boolean nbprojectFound = nbproject != null;
                buffer.append("\nnbproject exists: ");
                buffer.append(nbprojectFound);
                if (nbprojectFound) {
                    buffer.append("\nnbproject children: ");
                    buffer.append(Arrays.asList(nbproject.getChildren()));
                }
            }
            buffer.append("\nproperties (helper): ");
            buffer.append(this.helper.getProperties("nbproject/project.properties"));
            buffer.append("\nproperties (evaluator): ");
            buffer.append(this.eval.getProperties());
            throw new IllegalStateException(buffer.toString());
        }
        FileObject srcDir = this.helper.resolveFileObject(srcDirProperty);
        if (srcDir != null) {
            return srcDir;
        }
        return this.restoreDirectory("src.dir", "MSG_SourcesFolderRestored", "MSG_SourcesFolderTemporaryToProjectDirectory");
    }

    FileObject getTestsDirectory() {
        if (this.testsDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.testsDirectory == null) {
                            PhpProject.this.testsDirectory = PhpProject.this.resolveTestsDirectory();
                        }
                    }
                    return null;
                }
            });
        }
        return this.testsDirectory;
    }

    void setTestsDirectory(FileObject testsDirectory) {
        assert (testsDirectory != null && testsDirectory.isValid());
        this.testsDirectory = testsDirectory;
    }

    private FileObject resolveTestsDirectory() {
        String testsProperty = this.eval.getProperty("test.src.dir");
        if (testsProperty == null) {
            return null;
        }
        FileObject testDir = this.helper.resolveFileObject(testsProperty);
        if (testDir != null) {
            return testDir;
        }
        return this.restoreDirectory("test.src.dir", "MSG_TestsFolderRestored", "MSG_TestsFolderTemporaryToProjectDirectory");
    }

    FileObject getSeleniumDirectory() {
        if (this.seleniumDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.seleniumDirectory == null) {
                            PhpProject.this.seleniumDirectory = PhpProject.this.resolveSeleniumDirectory();
                        }
                    }
                    return null;
                }
            });
        }
        return this.seleniumDirectory;
    }

    void setSeleniumDirectory(FileObject seleniumDirectory) {
        assert (this.seleniumDirectory == null) : "Project selenium directory already set to " + this.seleniumDirectory;
        assert (seleniumDirectory != null && seleniumDirectory.isValid());
        this.seleniumDirectory = seleniumDirectory;
    }

    private FileObject resolveSeleniumDirectory() {
        String testsProperty = this.eval.getProperty("selenium.src.dir");
        if (testsProperty == null) {
            return null;
        }
        FileObject testDir = this.helper.resolveFileObject(testsProperty);
        if (testDir != null) {
            return testDir;
        }
        return this.restoreDirectory("selenium.src.dir", "MSG_SeleniumFolderRestored", "MSG_SeleniumFolderTemporaryToProjectDirectory");
    }

    private FileObject restoreDirectory(String propertyName, String infoMessageKey, String errorMessageKey) {
        String projectName = this.getName();
        File dir = FileUtil.normalizeFile((File)new File(this.helper.resolvePath(this.eval.getProperty(propertyName))));
        if (dir.mkdirs()) {
            this.informUser(projectName, NbBundle.getMessage(PhpProject.class, (String)infoMessageKey, (Object)dir.getAbsolutePath()), 1);
            return FileUtil.toFileObject((File)dir);
        }
        this.informUser(projectName, NbBundle.getMessage(PhpProject.class, (String)errorMessageKey, (Object)dir.getAbsolutePath()), 0);
        return this.helper.getProjectDirectory();
    }

    private void informUser(String title, String message, int type) {
        DialogDisplayer.getDefault().notifyLater(new NotifyDescriptor((Object)message, title, -1, type, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
    }

    public PhpModule getPhpModule() {
        PhpModule phpModule = (PhpModule)this.getLookup().lookup(PhpModule.class);
        assert (phpModule != null);
        return phpModule;
    }

    boolean isVisible(File file) {
        if (this.getIgnoredFiles().contains(file)) {
            return false;
        }
        return VisibilityQuery.getDefault().isVisible(file);
    }

    boolean isVisible(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            if (this.getIgnoredFileObjects().contains(fileObject)) {
                return false;
            }
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }
        return this.isVisible(file);
    }

    public Set<File> getIgnoredFiles() {
        HashSet<File> ignored = new HashSet<File>();
        this.putIgnoredProjectFiles(ignored);
        this.putIgnoredFrameworkFiles(ignored);
        return ignored;
    }

    public Set<FileObject> getIgnoredFileObjects() {
        HashSet<FileObject> ignoredFileObjects = new HashSet<FileObject>();
        for (File file : this.getIgnoredFiles()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            ignoredFileObjects.add(fo);
        }
        return ignoredFileObjects;
    }

    private void putIgnoredProjectFiles(Set<File> ignored) {
        if (this.ignoredFolders == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    Object object = PhpProject.this.ignoredFoldersLock;
                    synchronized (object) {
                        if (PhpProject.this.ignoredFolders == null) {
                            PhpProject.this.ignoredFolders = PhpProject.this.resolveIgnoredFolders();
                        }
                    }
                    return null;
                }
            });
        }
        assert (this.ignoredFolders != null) : "Ignored folders cannot be null";
        File projectDir = FileUtil.toFile((FileObject)this.getProjectDirectory());
        for (BasePathSupport.Item item : this.ignoredFolders) {
            if (item.isBroken()) continue;
            File file = new File(item.getFilePath());
            if (!file.isAbsolute()) {
                file = PropertyUtils.resolveFile((File)projectDir, (String)item.getFilePath());
            }
            ignored.add(file);
        }
    }

    private void putIgnoredFrameworkFiles(Set<File> ignored) {
        PhpModule phpModule = this.getPhpModule();
        for (PhpFrameworkProvider provider : this.getFrameworks()) {
            PhpModuleIgnoredFilesExtender ignoredFilesExtender = provider.getIgnoredFilesExtender(phpModule);
            if (ignoredFilesExtender == null) continue;
            for (File file : ignoredFilesExtender.getIgnoredFiles()) {
                assert (file != null) : "Ignored file = null found in " + provider.getName();
                assert (file.isAbsolute()) : "Not absolute file found in " + provider.getName();
                ignored.add(file);
            }
        }
    }

    private Set<BasePathSupport.Item> resolveIgnoredFolders() {
        IgnorePathSupport ignorePathSupport = new IgnorePathSupport(this.eval, this.refHelper, this.helper);
        HashSet<BasePathSupport.Item> ignored = new HashSet<BasePathSupport.Item>();
        EditableProperties properties = this.helper.getProperties("nbproject/project.properties");
        Iterator<BasePathSupport.Item> itemsIterator = ignorePathSupport.itemsIterator(properties.getProperty("ignore.path"));
        while (itemsIterator.hasNext()) {
            ignored.add(itemsIterator.next());
        }
        return ignored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhpFrameworkProvider> getFrameworks() {
        Object object = this.frameworksLock;
        synchronized (object) {
            if (this.frameworks == null) {
                this.frameworks = new LinkedList<PhpFrameworkProvider>();
                PhpModule phpModule = this.getPhpModule();
                for (PhpFrameworkProvider frameworkProvider : PhpFrameworks.getFrameworks()) {
                    if (!frameworkProvider.isInPhpModule(phpModule)) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Adding framework %s for project %s", frameworkProvider.getName(), this.getSourcesDirectory()));
                    }
                    this.frameworks.add(frameworkProvider);
                }
            }
            return new ArrayList<PhpFrameworkProvider>(this.frameworks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFrameworks() {
        Object object = this.frameworksLock;
        synchronized (object) {
            this.frameworks = null;
        }
    }

    public String getName() {
        if (this.name == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        Element data;
                        NodeList nl;
                        if (PhpProject.this.name == null && (nl = (data = PhpProject.this.getHelper().getPrimaryConfigurationData(true)).getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name")).getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                            PhpProject.this.name = ((Text)nl.item(0)).getNodeValue();
                        }
                        if (PhpProject.this.name == null) {
                            PhpProject.this.name = "???";
                        }
                    }
                    return null;
                }
            });
        }
        assert (this.name != null);
        return this.name;
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element nameEl;
                Element data = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                PhpProject.this.getHelper().putPrimaryConfigurationData(data, true);
            }
        });
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.getClass().getName());
        buffer.append(" [ project directory: ");
        buffer.append(this.getProjectDirectory());
        buffer.append(", source directory: ");
        buffer.append(this.sourcesDirectory);
        buffer.append(" ]");
        return buffer.toString();
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    CopySupport getCopySupport() {
        return (CopySupport)this.getLookup().lookup(CopySupport.class);
    }

    private Lookup createLookup(AuxiliaryConfiguration configuration) {
        PhpProjectEncodingQueryImpl phpProjectEncodingQueryImpl = new PhpProjectEncodingQueryImpl(this.getEvaluator());
        return Lookups.fixed((Object[])new Object[]{this, CopySupport.getInstance(this), new SeleniumProvider(), new PhpCoverageProvider(this), new Info(), configuration, new PhpOpenedHook(), new PhpProjectXmlSavedHook(), new PhpActionProvider(this), new PhpConfigurationProvider(this), new PhpModuleImpl(this), new PhpEditorExtender(this), this.helper.createCacheDirectoryProvider(), this.helper.createAuxiliaryProperties(), new ClassPathProviderImpl(this, this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpLogicalViewProvider(this), new CustomizerProviderImpl(this), new PhpSharabilityQuery(this.helper, this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpProjectOperations(this), phpProjectEncodingQueryImpl, new TemplateAttributesProviderImpl(this.getHelper(), phpProjectEncodingQueryImpl), new PhpTemplates(), new PhpSources(this, this.getHelper(), this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), this.getHelper(), this.getEvaluator(), PhpSearchInfo.create(this), new ProjectWebRootProviderImpl()});
    }

    public ReferenceHelper getRefHelper() {
        return this.refHelper;
    }

    public void fireIgnoredFilesChange() {
        this.ignoredFolders = null;
        this.ignoredFoldersChangeSupport.fireChange();
    }

    private final class PhpFileObjectFilter
    implements FileObjectFilter {
        private PhpFileObjectFilter() {
        }

        public boolean searchFile(FileObject file) {
            if (!file.isData()) {
                throw new IllegalArgumentException("File expected");
            }
            return PhpVisibilityQuery.forProject(PhpProject.this).isVisible(file);
        }

        public int traverseFolder(FileObject folder) {
            if (!folder.isFolder()) {
                throw new IllegalArgumentException("Folder expected");
            }
            if (PhpVisibilityQuery.forProject(PhpProject.this).isVisible(folder)) {
                return 1;
            }
            return 0;
        }
    }

    private static final class PhpSearchInfo
    implements SearchInfo.Files,
    PropertyChangeListener {
        private final PhpProject project;
        private SearchInfo.Files delegate = null;

        private PhpSearchInfo(PhpProject project) {
            this.project = project;
            this.delegate = this.createDelegate();
        }

        public static SearchInfo create(PhpProject project) {
            PhpSearchInfo phpSearchInfo = new PhpSearchInfo(project);
            project.getSourceRoots().addPropertyChangeListener(phpSearchInfo);
            project.getTestRoots().addPropertyChangeListener(phpSearchInfo);
            project.getSeleniumRoots().addPropertyChangeListener(phpSearchInfo);
            return phpSearchInfo;
        }

        private SearchInfo.Files createDelegate() {
            SearchInfo searchInfo = SearchInfoFactory.createSearchInfo((FileObject[])this.getSourceFileObjects(), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{this.project.getFileObjectFilter()});
            assert (searchInfo instanceof SearchInfo.Files) : "Unknown type: " + searchInfo.getClass().getName();
            return (SearchInfo.Files)searchInfo;
        }

        public boolean canSearch() {
            return true;
        }

        public synchronized Iterator<DataObject> objectsToSearch() {
            return this.delegate.objectsToSearch();
        }

        public Iterator<FileObject> filesToSearch() {
            return this.delegate.filesToSearch();
        }

        private FileObject[] getSourceFileObjects() {
            LinkedList<FileObject> roots = new LinkedList<FileObject>(Arrays.asList(this.project.getSourceRoots().getRoots()));
            roots.addAll(Arrays.asList(this.project.getTestRoots().getRoots()));
            roots.addAll(Arrays.asList(this.project.getSeleniumRoots().getRoots()));
            return roots.toArray(new FileObject[roots.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
                PhpSearchInfo phpSearchInfo = this;
                synchronized (phpSearchInfo) {
                    this.delegate = this.createDelegate();
                }
            }
        }
    }

    private final class ProjectWebRootProviderImpl
    implements ProjectWebRootProvider {
        private ProjectWebRootProviderImpl() {
        }

        public FileObject getWebRoot(FileObject file) {
            return ProjectPropertiesSupport.getWebRootDirectory(PhpProject.this);
        }
    }

    private final class PhpAntProjectListener
    implements AntProjectListener {
        private PhpAntProjectListener() {
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            PhpProject.this.name = null;
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }

    private final class FrameworksListener
    implements LookupListener {
        private FrameworksListener() {
        }

        public void resultChanged(LookupEvent ev) {
            LOGGER.fine("frameworks change, frameworks back to null");
            PhpProject.this.resetFrameworks();
        }
    }

    private final class SourceDirectoryFileChangeListener
    implements FileChangeListener {
        private SourceDirectoryFileChangeListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            this.processFileChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.processFileChange();
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.processFileChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.processFileChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        void processFileChange() {
            LOGGER.fine("file change, frameworks back to null");
            PhpProject.this.resetFrameworks();
        }
    }

    private final class ProjectPropertiesListener
    implements PropertyChangeListener {
        private ProjectPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("ignore.path".equals(propertyName)) {
                PhpProject.this.fireIgnoredFilesChange();
            } else if ("test.src.dir".equals(propertyName)) {
                PhpProject.this.testsDirectory = null;
            }
        }
    }

    private final class SeleniumProvider
    implements PhpSeleniumProvider {
        private SeleniumProvider() {
        }

        @Override
        public FileObject getTestDirectory(boolean showCustomizer) {
            return ProjectPropertiesSupport.getSeleniumDirectory(PhpProject.this, showCustomizer);
        }

        @Override
        public void runAllTests() {
            ConfigAction.get(ConfigAction.Type.SELENIUM, PhpProject.this).runProject();
        }
    }

    public final class PhpProjectXmlSavedHook
    extends ProjectXmlSavedHook {
        protected void projectXmlSaved() throws IOException {
            Info info = (Info)PhpProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final AntProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            super(ConfigPropertyProvider.computeDelegate(baseEval, prefix, helper));
            this.baseEval = baseEval;
            this.prefix = prefix;
            this.helper = helper;
            baseEval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("config".equals(ev.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            String config = baseEval.getProperty("config");
            if (config != null) {
                return helper.getPropertyProvider(prefix + "/" + config + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }

    private final class PhpOpenedHook
    extends ProjectOpenedHook {
        private PhpOpenedHook() {
        }

        protected void projectOpened() {
            PhpProject.this.sourcesDirectory = null;
            PhpProject.this.testsDirectory = null;
            PhpProject.this.seleniumDirectory = null;
            PhpProject.this.ignoredFolders = null;
            PhpProject.this.resetFrameworks();
            PhpProject.this.getSourcesDirectory();
            LOGGER.log(Level.FINE, "Adding frameworks listener for {0}", PhpProject.this.sourcesDirectory);
            PhpFrameworks.addFrameworksListener((LookupListener)PhpProject.this.frameworksListener);
            PhpProject.this.getIgnoredFiles();
            List<PhpFrameworkProvider> frameworkProviders = PhpProject.this.getFrameworks();
            PhpProject.this.getName();
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            ClassPath[] bootClassPaths = cpProvider.getProjectClassPaths("classpath/php-boot");
            GlobalPathRegistry.getDefault().register("classpath/php-boot", bootClassPaths);
            GlobalPathRegistry.getDefault().register("classpath/php-source", cpProvider.getProjectClassPaths("classpath/php-source"));
            for (ClassPath classPath : bootClassPaths) {
                IncludePathClassPathProvider.addProjectIncludePath(classPath);
            }
            PhpCoverageProvider coverageProvider = (PhpCoverageProvider)PhpProject.this.getLookup().lookup(PhpCoverageProvider.class);
            if (coverageProvider.isEnabled()) {
                PhpCoverageProvider.notifyProjectOpened(PhpProject.this);
            }
            PhpProject.this.getCopySupport().projectOpened();
            PhpUnit.validateVersion(CommandUtils.getPhpUnit(false));
            PhpModule phpModule = PhpProject.this.getPhpModule();
            assert (phpModule != null);
            for (PhpFrameworkProvider frameworkProvider : frameworkProviders) {
                frameworkProvider.phpModuleOpened(phpModule);
            }
            PhpProjectUtils.logUsage(PhpProject.class, "USG_PROJECT_OPEN_PHP", Arrays.asList(PhpProjectUtils.getFrameworksForUsage(frameworkProviders)));
        }

        protected void projectClosed() {
            assert (PhpProject.this.sourcesDirectory != null);
            PhpProject.this.sourcesDirectory.removeFileChangeListener(PhpProject.this.sourceDirectoryFileChangeListener);
            LOGGER.log(Level.FINE, "Removing frameworks listener for {0}", PhpProject.this.sourcesDirectory);
            PhpFrameworks.removeFrameworksListener((LookupListener)PhpProject.this.frameworksListener);
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().unregister("classpath/php-boot", cpProvider.getProjectClassPaths("classpath/php-boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/php-source", cpProvider.getProjectClassPaths("classpath/php-source"));
            PhpProject.this.getCopySupport().projectClosed();
            PhpModule phpModule = PhpProject.this.getPhpModule();
            assert (phpModule != null);
            for (PhpFrameworkProvider frameworkProvider : PhpProject.this.getFrameworks()) {
                frameworkProvider.phpModuleClosed(phpModule);
            }
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        private Info() {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public String getDisplayName() {
            return PhpProject.this.getName();
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public Project getProject() {
            return PhpProject.this;
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        void firePropertyChange(String prop) {
            this.propertyChangeSupport.firePropertyChange(prop, null, null);
        }
    }
}

