/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.Tree;
import javax.jws.WebParam;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class OnewayOperationParameterMode
extends Rule<ExecutableElement>
implements WebServiceAnnotations {
    @Override
    public ErrorDescription[] apply(ExecutableElement executableElement, ProblemContext problemContext) {
        AnnotationMirror annotationMirror = Utilities.findAnnotation(executableElement, "javax.jws.Oneway");
        Tree tree = problemContext.getCompilationInfo().getTrees().getTree(executableElement, annotationMirror);
        for (VariableElement variableElement : executableElement.getParameters()) {
            WebParam.Mode mode;
            AnnotationMirror annotationMirror2 = Utilities.findAnnotation(variableElement, "javax.jws.WebParam");
            if (annotationMirror2 == null) continue;
            AnnotationValue annotationValue = Utilities.getAnnotationAttrValue(annotationMirror2, "mode");
            WebParam.Mode mode2 = mode = annotationValue == null ? null : WebParam.Mode.valueOf((String)annotationValue.getValue().toString());
            if (WebParam.Mode.INOUT != mode && WebParam.Mode.OUT != mode) continue;
            String string = NbBundle.getMessage(OnewayOperationParameterMode.class, (String)"MSG_OnewayNotAllowed_HasOutParams");
            RemoveAnnotation removeAnnotation = new RemoveAnnotation(problemContext.getFileObject(), executableElement, annotationMirror);
            problemContext.setElementToAnnotate(tree);
            ErrorDescription errorDescription = OnewayOperationParameterMode.createProblem((Element)executableElement, problemContext, string, removeAnnotation);
            problemContext.setElementToAnnotate(null);
            return new ErrorDescription[]{errorDescription};
        }
        return null;
    }

    @Override
    protected final boolean isApplicable(ExecutableElement executableElement, ProblemContext problemContext) {
        return Utilities.hasAnnotation(executableElement, "javax.jws.Oneway");
    }
}

