/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.modules.debugger.jpda.projects.SourcesCurrentModel;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class SourcesRemoteModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private static Logger logger = Logger.getLogger(SourcesCurrentModel.class.getName());
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> disabledSourceRoots = new HashSet<String>();
    private List<String> additionalSourceRoots = new ArrayList<String>();
    private String[] unorderedOriginalSourceRoots;
    private String[] sortedOriginalSourceRoots;
    private int[] sourcePathPermutation;
    private Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private GlobalPathRegistryListener globalRegistryListener;
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            File file;
            if (SourcesRemoteModel.this.newSourceFileChooser == null) {
                SourcesRemoteModel.this.newSourceFileChooser = new JFileChooser();
                SourcesRemoteModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesRemoteModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                            return false;
                        }
                    }
                });
            }
            if ((file = SourcesCurrentModel.getCurrentSourceRoot()) != null) {
                SourcesRemoteModel.this.newSourceFileChooser.setSelectedFile(file);
            }
            if ((n = SourcesRemoteModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File file2 = SourcesRemoteModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!file2.isDirectory() && !FileUtil.isArchiveFile((URL)file2.toURI().toURL())) {
                        return;
                    }
                    String string = file2.getCanonicalPath();
                    SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
                    synchronized (sourcesRemoteModel) {
                        SourcesRemoteModel.this.additionalSourceRoots.add(string);
                        SourcesRemoteModel.access$202(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.unorderedOriginalSourceRoots, 1));
                        SourcesRemoteModel.access$402(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.sortedOriginalSourceRoots, 1));
                        SourcesRemoteModel.access$502(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.sourcePathPermutation, 1));
                        ((SourcesRemoteModel)SourcesRemoteModel.this).unorderedOriginalSourceRoots[((SourcesRemoteModel)SourcesRemoteModel.this).unorderedOriginalSourceRoots.length - 1] = string;
                        ((SourcesRemoteModel)SourcesRemoteModel.this).sortedOriginalSourceRoots[((SourcesRemoteModel)SourcesRemoteModel.this).sortedOriginalSourceRoots.length - 1] = string;
                        ((SourcesRemoteModel)SourcesRemoteModel.this).sourcePathPermutation[((SourcesRemoteModel)SourcesRemoteModel.this).sourcePathPermutation.length - 1] = SourcesRemoteModel.this.sourcePathPermutation.length - 1;
                        SourcePathProviderImpl.storeSourceRootsOrder(null, SourcesRemoteModel.this.unorderedOriginalSourceRoots, SourcesRemoteModel.this.sourcePathPermutation);
                    }
                    SourcesRemoteModel.this.saveAdditionalSourceRoots();
                    SourcesRemoteModel.this.fireTreeChanged();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesRemoteModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                String string = (String)objectArray[i];
                SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
                synchronized (sourcesRemoteModel) {
                    ArrayList<String> arrayList;
                    SourcesRemoteModel.this.additionalSourceRoots.remove(string);
                    SourcesRemoteModel.this.disabledSourceRoots.remove(string);
                    ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(SourcesRemoteModel.this.unorderedOriginalSourceRoots));
                    int n2 = arrayList2.indexOf(string);
                    if (n2 >= 0) {
                        int n3;
                        arrayList2.remove(n2);
                        SourcesRemoteModel.access$202(SourcesRemoteModel.this, arrayList2.toArray(new String[0]));
                        int n4 = SourcesRemoteModel.this.sourcePathPermutation[n2];
                        for (n3 = 0; n3 < SourcesRemoteModel.this.sourcePathPermutation.length; ++n3) {
                            if (SourcesRemoteModel.this.sourcePathPermutation[n3] <= n4) continue;
                            int[] nArray = SourcesRemoteModel.this.sourcePathPermutation;
                            int n5 = n3;
                            nArray[n5] = nArray[n5] - 1;
                        }
                        for (n3 = n2; n3 < SourcesRemoteModel.this.sourcePathPermutation.length - 1; ++n3) {
                            ((SourcesRemoteModel)SourcesRemoteModel.this).sourcePathPermutation[n3] = SourcesRemoteModel.this.sourcePathPermutation[n3 + 1];
                        }
                    }
                    if ((n2 = (arrayList = new ArrayList<String>(Arrays.asList(SourcesRemoteModel.this.sortedOriginalSourceRoots))).indexOf(string)) >= 0) {
                        arrayList.remove(n2);
                        SourcesRemoteModel.access$402(SourcesRemoteModel.this, arrayList.toArray(new String[0]));
                    }
                    continue;
                }
            }
            SourcesRemoteModel.access$502(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.sourcePathPermutation, -n));
            SourcesRemoteModel.this.saveAdditionalSourceRoots();
            SourcesRemoteModel.this.saveDisabledSourceRoots();
            SourcePathProviderImpl.storeSourceRootsOrder(null, SourcesRemoteModel.this.unorderedOriginalSourceRoots, SourcesRemoteModel.this.sourcePathPermutation);
            SourcesRemoteModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_UP_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesRemoteModel.class).getString("CTL_SourcesModel_MoveUpSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object object) {
            if ("Root".equals(object)) {
                return false;
            }
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                return SourcesRemoteModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesRemoteModel.this.sortedOriginalSourceRoots[0].equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                String[] stringArray = SourcesRemoteModel.this.sortedOriginalSourceRoots;
                int n2 = stringArray.length;
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    for (n3 = 0; n3 < n && !stringArray[i].equals(objectArray[n3]); ++n3) {
                    }
                    if (n3 < n) {
                        if (i <= 0) continue;
                        nArray[i] = nArray[i - 1];
                        nArray[i - 1] = i;
                        continue;
                    }
                    nArray[i] = i;
                }
                SourcesRemoteModel.this.reorderOriginalSourceRoots(nArray);
            }
            SourcesRemoteModel.this.fireTreeChanged();
            SourcesRemoteModel.this.fireSelectedNodes(objectArray);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_DOWN_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_MoveDownSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object object) {
            if ("Root".equals(object)) {
                return false;
            }
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                return SourcesRemoteModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesRemoteModel.this.sortedOriginalSourceRoots[SourcesRemoteModel.this.sortedOriginalSourceRoots.length - 1].equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                String[] stringArray = SourcesRemoteModel.this.sortedOriginalSourceRoots;
                int n2 = stringArray.length;
                int[] nArray = new int[n2];
                for (int i = n2 - 1; i >= 0; --i) {
                    int n3;
                    for (n3 = 0; n3 < n && !stringArray[i].equals(objectArray[n3]); ++n3) {
                    }
                    if (n3 < n) {
                        if (i >= n2 - 1) continue;
                        nArray[i] = nArray[i + 1];
                        nArray[i + 1] = i;
                        continue;
                    }
                    nArray[i] = i;
                }
                SourcesRemoteModel.this.reorderOriginalSourceRoots(nArray);
            }
            SourcesRemoteModel.this.fireTreeChanged();
            SourcesRemoteModel.this.fireSelectedNodes(objectArray);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action RESET_ORDER_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_ResetOrderSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            SourcesRemoteModel.this.reorderOriginalSourceRoots(null);
            SourcesRemoteModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesRemoteModel() {
        this.loadSourceRoots();
        this.updateCachedRoots();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.MOVE_UP_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.MOVE_DOWN_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.RESET_ORDER_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            if (this.globalRegistryListener == null) {
                this.globalRegistryListener = new GlobalPathRegistryListener(){

                    public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
                        SourcesRemoteModel.this.fireTreeChanged();
                    }

                    public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
                        SourcesRemoteModel.this.fireTreeChanged();
                    }
                };
                GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.globalRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            }
            TreeSet<FileObject> treeSet = new TreeSet<FileObject>(new SourcePathProviderImpl.FileObjectComparator());
            treeSet.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            int n3 = treeSet.size();
            ArrayList<String> arrayList = new ArrayList<String>(n3);
            Iterator iterator = treeSet.iterator();
            for (int i = 0; i < n3; ++i) {
                arrayList.add(SourcePathProviderImpl.getRoot((FileObject)iterator.next()));
            }
            String[] stringArray = this;
            synchronized (this) {
                if (this.additionalSourceRoots.size() > 0) {
                    for (String objectArray2 : this.additionalSourceRoots) {
                        if (arrayList.contains(objectArray2)) continue;
                        arrayList.add(objectArray2);
                    }
                }
                // ** MonitorExit[stringArray] (shouldn't be in output)
                stringArray = arrayList.toArray(new String[0]);
                Map<String, Integer> map = SourcePathProviderImpl.getRemoteSourceRootsOrder();
                Object[] objectArray = new String[stringArray.length];
                int[] nArray = SourcePathProviderImpl.createPermutation(stringArray, map, (String[])objectArray);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("getChildren(): orderIndexes = " + map + ", sourcePathPermutation = " + Arrays.toString(nArray));
                    logger.fine("    sorted roots = " + Arrays.toString(objectArray));
                    logger.fine("  sourcePathPermutation = " + Arrays.toString(nArray));
                }
                n2 = Math.min(objectArray.length, n2);
                n = Math.min(objectArray.length, n);
                Object[] objectArray2 = new Object[n2 - n];
                System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
                String[] stringArray2 = this;
                synchronized (this) {
                    this.unorderedOriginalSourceRoots = stringArray;
                    this.sortedOriginalSourceRoots = objectArray;
                    this.sourcePathPermutation = nArray;
                    // ** MonitorExit[var13_16] (shouldn't be in output)
                    return objectArray2;
                }
            }
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    private void fireSelectedNodes(Object[] objectArray) {
        ModelEvent.SelectionChanged selectionChanged = new ModelEvent.SelectionChanged((Object)this, objectArray);
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)selectionChanged);
        }
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            if (this.additionalSourceRoots.contains((String)object)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String string) {
        SourcesRemoteModel sourcesRemoteModel = this;
        synchronized (sourcesRemoteModel) {
            return !this.disabledSourceRoots.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String string, boolean bl) {
        SourcesRemoteModel sourcesRemoteModel = this;
        synchronized (sourcesRemoteModel) {
            if (bl) {
                this.disabledSourceRoots.remove(string);
            } else {
                this.disabledSourceRoots.add(string);
            }
            this.saveDisabledSourceRoots();
        }
    }

    private void loadSourceRoots() {
        this.disabledSourceRoots = new HashSet<String>(this.sourcesProperties.getProperties("source_roots").getCollection("remote_disabled", (Collection)Collections.EMPTY_SET));
        this.additionalSourceRoots = new ArrayList<String>(this.sourcesProperties.getProperties("additional_source_roots").getCollection("src_roots", (Collection)Collections.EMPTY_LIST));
    }

    private synchronized void saveDisabledSourceRoots() {
        this.sourcesProperties.getProperties("source_roots").setCollection("remote_disabled", this.disabledSourceRoots);
    }

    private synchronized void saveAdditionalSourceRoots() {
        this.sourcesProperties.getProperties("additional_source_roots").setCollection("src_roots", this.additionalSourceRoots);
    }

    private synchronized void updateCachedRoots() {
    }

    public boolean isCheckable(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return this.isEnabled((String)object);
        }
        throw new UnknownTypeException(object);
    }

    public void setSelected(NodeModel nodeModel, Object object, Boolean bl) throws UnknownTypeException {
        if (object instanceof String) {
            this.setEnabled((String)object, bl);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getDisplayName(object);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getShortDescription(object);
    }

    public synchronized void reorderOriginalSourceRoots(int[] nArray) {
        String[] stringArray = this.sortedOriginalSourceRoots;
        if (nArray == null) {
            for (int i = 0; i < this.sourcePathPermutation.length; ++i) {
                this.sourcePathPermutation[i] = i;
            }
            this.sortedOriginalSourceRoots = this.unorderedOriginalSourceRoots;
            stringArray = this.unorderedOriginalSourceRoots;
        } else {
            int n;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("reorderOriginalSourceRoots(" + Arrays.toString(nArray));
            }
            if (stringArray.length != nArray.length) {
                throw new IllegalArgumentException("Bad length of permutation: " + nArray.length + ", have " + stringArray.length + " source roots.");
            }
            int n2 = nArray.length;
            String[] stringArray2 = this.unorderedOriginalSourceRoots;
            Object[] objectArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.sourcePathPermutation[nArray[n]];
                objectArray[n] = stringArray2[nArray[n]];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
            }
            for (n = 0; n < n2; ++n) {
                this.sourcePathPermutation[n] = nArray[n];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  => sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
                logger.fine("  => sorted roots = " + Arrays.toString(objectArray));
            }
            this.sortedOriginalSourceRoots = objectArray;
            stringArray = stringArray2;
        }
        SourcePathProviderImpl.storeSourceRootsOrder(null, stringArray, this.sourcePathPermutation);
    }

    private static String[] resize(String[] stringArray, int n) {
        int n2 = stringArray.length + n;
        String[] stringArray2 = new String[n2];
        n2 = Math.min(n2, stringArray.length);
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    private static int[] resize(int[] nArray, int n) {
        int n2 = nArray.length + n;
        int[] nArray2 = new int[n2];
        n2 = Math.min(n2, nArray.length);
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    static /* synthetic */ String[] access$202(SourcesRemoteModel sourcesRemoteModel, String[] stringArray) {
        sourcesRemoteModel.unorderedOriginalSourceRoots = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$402(SourcesRemoteModel sourcesRemoteModel, String[] stringArray) {
        sourcesRemoteModel.sortedOriginalSourceRoots = stringArray;
        return stringArray;
    }

    static /* synthetic */ int[] access$502(SourcesRemoteModel sourcesRemoteModel, int[] nArray) {
        sourcesRemoteModel.sourcePathPermutation = nArray;
        return nArray;
    }
}

