/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.inheritance;

import javax.persistence.InheritanceType;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.TablePerClassPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class InheritanceMetadata
extends ORMetadata {
    private String m_strategy;

    public InheritanceMetadata() {
        super("<inheritance>");
    }

    public InheritanceMetadata(MetadataAnnotation inheritance, MetadataAccessibleObject accessibleObject) {
        super(inheritance, accessibleObject);
        if (inheritance != null) {
            this.m_strategy = (String)inheritance.getAttribute("strategy");
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof InheritanceMetadata) {
            return this.valuesMatch(this.m_strategy, ((InheritanceMetadata)objectToCompare).getStrategy());
        }
        return false;
    }

    public String getStrategy() {
        return this.m_strategy;
    }

    public void process(MetadataDescriptor descriptor) {
        EntityAccessor accessor = (EntityAccessor)descriptor.getClassAccessor();
        if (this.m_strategy != null && this.m_strategy.equals(InheritanceType.TABLE_PER_CLASS.name())) {
            this.setTablePerClassInheritancePolicy(descriptor);
        } else {
            this.setInheritancePolicy(descriptor);
        }
        if (descriptor.isInheritanceSubclass()) {
            MetadataDescriptor rootDescriptor = descriptor.getInheritanceRootDescriptor();
            EntityAccessor rootAccessor = (EntityAccessor)rootDescriptor.getClassAccessor();
            if (rootDescriptor.usesTablePerClassInheritanceStrategy()) {
                MetadataDescriptor parentDescriptor = descriptor.getInheritanceParentDescriptor();
                descriptor.getClassDescriptor().getTablePerClassPolicy().addParentDescriptor(parentDescriptor.getClassDescriptor());
                parentDescriptor.getClassDescriptor().getTablePerClassPolicy().addChildDescriptor(descriptor.getClassDescriptor());
            } else {
                descriptor.getClassDescriptor().getInheritancePolicy().setParentClassName(descriptor.getInheritanceParentDescriptor().getJavaClassName());
            }
            if (accessor.hasInheritance() && !this.equals(rootAccessor.getInheritance())) {
                if (rootDescriptor.usesTablePerClassInheritanceStrategy()) {
                    this.addTablePerClassParentMappings(descriptor, descriptor);
                } else {
                    if (!this.usesTablePerClassStrategy()) {
                        this.addClassIndicatorField(descriptor, accessor);
                        this.addClassIndicator(rootDescriptor, accessor);
                    }
                    accessor.processInheritancePrimaryKeyJoinColumns();
                }
            } else if (this.usesTablePerClassStrategy()) {
                this.addTablePerClassParentMappings(descriptor, descriptor);
            } else {
                this.addClassIndicator(rootDescriptor, accessor);
                if (rootAccessor.getInheritance().usesJoinedStrategy()) {
                    accessor.processInheritancePrimaryKeyJoinColumns();
                }
            }
            if (descriptor.getInheritanceRootDescriptor().hasCompositePrimaryKey()) {
                descriptor.setPKClass(descriptor.getInheritanceRootDescriptor().getPKClass());
            }
        } else if (!this.usesTablePerClassStrategy()) {
            this.addClassIndicatorField(descriptor, accessor);
            this.addClassIndicator(descriptor, accessor);
        }
    }

    private void addClassIndicator(MetadataDescriptor rootDescriptor, EntityAccessor accessor) {
        if (rootDescriptor.isInheritanceSubclass()) {
            this.addClassIndicator(rootDescriptor.getInheritanceRootDescriptor(), accessor);
        } else {
            String discriminatorValue = accessor.getDiscriminatorValueOrNull();
            if (discriminatorValue != null) {
                if (rootDescriptor.getClassDescriptor().getInheritancePolicy().getClassIndicatorField().getType() == Integer.class) {
                    try {
                        Integer integerDiscriminator = new Integer(discriminatorValue);
                        rootDescriptor.getClassDescriptor().getInheritancePolicy().addClassNameIndicator(accessor.getJavaClassName(), integerDiscriminator);
                        return;
                    }
                    catch (NumberFormatException exc) {
                        accessor.getLogger().logWarningMessage("metadata_warning_integer_discriminator_could_not_be_built", accessor.getJavaClassName(), discriminatorValue);
                    }
                }
                rootDescriptor.getClassDescriptor().getInheritancePolicy().addClassNameIndicator(accessor.getJavaClassName(), discriminatorValue);
            }
        }
    }

    private void addClassIndicatorField(MetadataDescriptor descriptor, EntityAccessor accessor) {
        descriptor.getClassDescriptor().getInheritancePolicy().setClassIndicatorField(accessor.processDiscriminatorColumn());
    }

    public void addTablePerClassParentMappings(MetadataDescriptor startingDescriptor, MetadataDescriptor realDescriptor) {
        EntityAccessor reloadedParentEntity = null;
        MetadataDescriptor realParentDescriptor = null;
        if (realDescriptor.isInheritanceSubclass() && realDescriptor.getInheritanceRootDescriptor().usesTablePerClassInheritanceStrategy()) {
            realParentDescriptor = realDescriptor.getInheritanceParentDescriptor();
            reloadedParentEntity = this.reloadEntity((EntityAccessor)realParentDescriptor.getClassAccessor(), startingDescriptor);
            this.addTablePerClassParentMappings(startingDescriptor, realParentDescriptor);
        }
        if (reloadedParentEntity != null) {
            EntityAccessor realParentEntityAccessor = (EntityAccessor)realParentDescriptor.getClassAccessor();
            for (MappedSuperclassAccessor mappedSuperclass : realParentEntityAccessor.getMappedSuperclasses()) {
                this.reloadMappedSuperclass(mappedSuperclass, startingDescriptor).addAccessors();
            }
            reloadedParentEntity.addAccessors();
        }
    }

    private void setInheritancePolicy(MetadataDescriptor descriptor) {
        if (this.m_strategy != null || !descriptor.isInheritanceSubclass()) {
            // empty if block
        }
        descriptor.getClassDescriptor().setInheritancePolicy(new InheritancePolicy(descriptor.getClassDescriptor()));
    }

    public void setStrategy(String strategy) {
        this.m_strategy = strategy;
    }

    private void setTablePerClassInheritancePolicy(MetadataDescriptor descriptor) {
        descriptor.getClassDescriptor().setTablePerClassPolicy(new TablePerClassPolicy(descriptor.getClassDescriptor()));
    }

    public boolean usesJoinedStrategy() {
        return this.m_strategy != null && this.m_strategy.equals(InheritanceType.JOINED.name());
    }

    public boolean usesSingleTableStrategy() {
        return this.m_strategy == null || this.m_strategy.equals(InheritanceType.SINGLE_TABLE.name());
    }

    public boolean usesTablePerClassStrategy() {
        return this.m_strategy != null && this.m_strategy.equals(InheritanceType.TABLE_PER_CLASS.name());
    }
}

