/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantClassRef;
import com.sun.javacard.exportfile.EfConstantInteger;
import com.sun.javacard.exportfile.EfConstantPackage;
import com.sun.javacard.exportfile.EfConstantUtf8;
import com.sun.javacard.exportfile.ExportFileFormatError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class EfConstantPool {
    Vector<EfConstant> constants;

    public EfConstantPool() {
        this.constants = new Vector(50);
    }

    public EfConstantPool(int n) {
        this.constants = new Vector(n);
    }

    public int getSize() {
        return this.constants.size();
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            EfConstant efConstant;
            byte by = dataInputStream.readByte();
            switch (by) {
                case 13: {
                    efConstant = new EfConstantPackage(this);
                    break;
                }
                case 7: {
                    efConstant = new EfConstantClassRef(this);
                    break;
                }
                case 3: {
                    efConstant = new EfConstantInteger(this);
                    break;
                }
                case 1: {
                    efConstant = new EfConstantUtf8(this);
                    break;
                }
                default: {
                    return;
                }
            }
            efConstant.parse(dataInputStream);
            this.constants.addElement(efConstant);
        }
    }

    public EfConstant[] getConstants() {
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        return objectArray;
    }

    public EfConstant getAt(int n) {
        try {
            return this.constants.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ExportFileFormatError();
        }
    }

    public EfConstantPackage getConstantPackage(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantPackage)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantPackage)efConstant;
    }

    public EfConstantClassRef getConstantClassRef(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantClassRef)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantClassRef)efConstant;
    }

    public EfConstantInteger getConstantInteger(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantInteger)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantInteger)efConstant;
    }

    public EfConstantUtf8 getConstantUtf8(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantUtf8)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantUtf8)efConstant;
    }

    public void resolve() {
        Enumeration<EfConstant> enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            EfConstant efConstant = enumeration.nextElement();
            efConstant.resolve();
        }
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constants.size());
        Enumeration<EfConstant> enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            EfConstant efConstant = enumeration.nextElement();
            efConstant.toBinary(dataOutputStream);
        }
    }

    public int addConstantPackage(PackageDefinition packageDefinition, byte by) {
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof EfConstantPackage)) continue;
            EfConstantPackage efConstantPackage = (EfConstantPackage)objectArray[i];
            if (efConstantPackage.getPackageName().equals(packageDefinition.getPackageName())) {
                return i;
            }
            throw new ConverterInternalError();
        }
        EfConstantPackage efConstantPackage = new EfConstantPackage(this, packageDefinition, by);
        this.constants.addElement(efConstantPackage);
        return this.constants.size() - 1;
    }

    public int addConstantClassRef(String string) {
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            EfConstantClassRef efConstantClassRef;
            if (!(objectArray[i] instanceof EfConstantClassRef) || !(efConstantClassRef = (EfConstantClassRef)objectArray[i]).getClassName().equals(string)) continue;
            return i;
        }
        EfConstantClassRef efConstantClassRef = new EfConstantClassRef(this, string);
        this.constants.addElement(efConstantClassRef);
        return this.constants.size() - 1;
    }

    public int addConstantInteger(int n) {
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            EfConstantInteger efConstantInteger;
            if (!(objectArray[i] instanceof EfConstantInteger) || (efConstantInteger = (EfConstantInteger)objectArray[i]).getIntValue() != n) continue;
            return i;
        }
        EfConstantInteger efConstantInteger = new EfConstantInteger(this, n);
        this.constants.addElement(efConstantInteger);
        return this.constants.size() - 1;
    }

    public int addConstantUtf8(String string) {
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            EfConstantUtf8 efConstantUtf8;
            if (!(objectArray[i] instanceof EfConstantUtf8) || !(efConstantUtf8 = (EfConstantUtf8)objectArray[i]).getUtf8String().equals(string)) continue;
            return i;
        }
        EfConstantUtf8 efConstantUtf8 = new EfConstantUtf8(this, string);
        this.constants.addElement(efConstantUtf8);
        return this.constants.size() - 1;
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        Enumeration<EfConstant> enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            EfConstant efConstant = enumeration.nextElement();
            efConstant.toText(printWriter, n);
        }
    }
}

