/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcfile.JcField;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class FieldDebugInfo
extends FieldDefinition {
    private int name_index;
    private int descriptor_index;
    private int location;

    public FieldDebugInfo(JcField jcField, DebugComponent debugComponent) {
        super(jcField);
        this.build(jcField, debugComponent);
    }

    private void build(JcField jcField, DebugComponent debugComponent) {
        this.name_index = debugComponent.addString(this.field_name);
        this.descriptor_index = debugComponent.addString(this.descriptor);
    }

    public int getSize() {
        return 10;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        stringBuffer2.append(string + "field_debug_info { ");
        stringBuffer2.append(string + "\tname_index " + this.name_index + "\t\t//" + this.field_name);
        stringBuffer2.append(string + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        stringBuffer2.append(string + "\taccess_flags " + Modifier.toString(this.access_flags));
        if (Modifier.isStatic(this.access_flags)) {
            if (Modifier.isFinal(this.access_flags) && DataType.isPrimitiveType(this.descriptor)) {
                stringBuffer2.append(string + "\tvalue " + this.value[0]);
            } else {
                stringBuffer2.append(string + "\tlocation " + this.location);
            }
        } else {
            stringBuffer2.append(string + "\ttoken " + this.token);
        }
        stringBuffer2.append(string + "}");
        return stringBuffer2.toString();
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.descriptor_index);
        dataOutputStream.writeShort(this.access_flags);
        if (Modifier.isStatic(this.access_flags)) {
            if (Modifier.isFinal(this.access_flags) && DataType.isPrimitiveType(this.descriptor)) {
                dataOutputStream.writeInt(this.value[0]);
            } else {
                dataOutputStream.writeInt(this.location);
            }
        } else {
            dataOutputStream.writeInt(this.token);
        }
        dataOutputStream.flush();
    }
}

