/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.wsitconf.projects.MavenWsitProvider;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class MavenWSITModelSupport {
    private static final Logger logger = Logger.getLogger(MavenWSITModelSupport.class.getName());

    public static WSDLModel getModel(Node node, Project project, JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService, UndoManagerHolder undoManagerHolder, boolean bl, Collection<FileObject> collection) throws MalformedURLException, Exception {
        Object object;
        boolean bl2;
        WSDLModel wSDLModel = null;
        boolean bl3 = bl2 = !jaxWsService.isServiceProvider();
        if (bl2) {
            wSDLModel = MavenWSITModelSupport.getModelForClient(project, jAXWSLightSupport, jaxWsService, bl, collection);
        } else {
            object = (FileObject)node.getLookup().lookup(FileObject.class);
            try {
                String string = jaxWsService.getLocalWsdl();
                if (string == null) {
                    if (object == null || !object.isValid() || object.isVirtual()) {
                        logger.log(Level.INFO, "Implementation class is null or not valid, or just virtual: " + object + ", service: " + jaxWsService);
                        return null;
                    }
                    return WSITModelSupport.getModelForServiceFromJava(object, project, bl, collection);
                }
                if (project == null) {
                    return null;
                }
                return MavenWSITModelSupport.getModelForServiceFromWsdl(jAXWSLightSupport, jaxWsService);
            }
            catch (Exception exception) {
                logger.log(Level.INFO, null, exception);
            }
        }
        if (wSDLModel != null && undoManagerHolder != null && undoManagerHolder.getUndoManager() == null) {
            object = new UndoManager();
            wSDLModel.addUndoableEditListener((UndoableEditListener)object);
            undoManagerHolder.setUndoManager((UndoManager)object);
        }
        return wSDLModel;
    }

    public static WSDLModel getModelForClient(Project project, JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService, boolean bl, Collection<FileObject> collection) throws IOException {
        URI uRI = null;
        try {
            uRI = jAXWSLightSupport.getWsdlFolder(false).getFileObject(jaxWsService.getLocalWsdl()).getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        if (uRI == null) {
            return null;
        }
        return WSITModelSupport.getModelForClient(project, uRI, bl, collection);
    }

    public static WSDLModel getServiceModelForClient(JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService) throws IOException, Exception {
        FileObject fileObject = jAXWSLightSupport.getWsdlFolder(false);
        FileObject fileObject2 = fileObject.getFileObject(jaxWsService.getLocalWsdl());
        if (fileObject2 != null && fileObject2.isValid()) {
            return WSITModelSupport.getModelFromFO(fileObject2, true);
        }
        return null;
    }

    private static WSDLModel getModelForServiceFromWsdl(JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService) throws IOException, Exception {
        String string = jaxWsService.getLocalWsdl();
        FileObject fileObject = jAXWSLightSupport.getWsdlFolder(false).getFileObject(string);
        return WSITModelSupport.getModelFromFO(fileObject, true);
    }

    public static boolean isMavenProject(Project project) {
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        return wsitProvider instanceof MavenWsitProvider;
    }
}

