/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.disassembly;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisProgressPanel;
import org.netbeans.modules.cnd.debugger.common.disassembly.RegisterValue;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;

public class Disassembly
implements PropertyChangeListener,
DocumentListener {
    private final GdbDebugger debugger;
    private final List<Line> lines = new ArrayList<Line>();
    private static String functionName = "";
    private static String intFileName = "";
    private static String resolvedFileName = "";
    private String address = "";
    private boolean withSource = true;
    private boolean opened = false;
    private boolean opening = false;
    private int disLength = 0;
    private final Map<Integer, String> regNames = new HashMap<Integer, String>();
    private final Map<Integer, String> regValues = new HashMap<Integer, String>();
    private final Set<Integer> regModified = new HashSet<Integer>();
    private static final String ADDRESS_HEADER = "address";
    private static final String FUNCTION_HEADER = "func-name";
    private static final String OFFSET_HEADER = "offset";
    private static final String INSTR_HEADER = "inst";
    private static final String LINE_HEADER = "line";
    private static final String FILE_HEADER = "file";
    private static final String NUMBER_HEADER = "number";
    private static final String VALUE_HEADER = "value";
    public static final String REGISTER_NAMES_HEADER = "^done,register-names=";
    public static final String REGISTER_VALUES_HEADER = "^done,register-values=";
    public static final String REGISTER_MODIFIED_HEADER = "^done,changed-registers=";
    public static final String RESPONSE_HEADER = "^done,asm_insns=";
    private static final String COMBINED_HEADER = "src_and_asm_line={";
    private static final String COMMENT_PREFIX = "!";
    private static FileObject fo = null;
    private static final Logger log = Logger.getLogger("gdb.logger");
    private boolean cancelled = false;
    private RequestMode requestMode = RequestMode.FILE;

    public Disassembly(GdbDebugger debugger) {
        this.debugger = debugger;
        debugger.addPropertyChangeListener("currentCallStackFrame", this);
    }

    protected void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String msg) {
        assert (msg.startsWith(RESPONSE_HEADER)) : "Invalid asm response message";
        this.cancelled = false;
        Dialog dialog = null;
        GdbCallStackFrame frame = this.debugger.getCurrentCallStackFrame();
        if (frame == null) {
            return;
        }
        String currentAddr = this.debugger.getCurrentCallStackFrame().getAddr();
        List<Line> list = this.lines;
        synchronized (list) {
            DataObject dobj;
            this.lines.clear();
            this.disLength = 0;
            try {
                dobj = DataObject.find((FileObject)Disassembly.getFileObject());
            }
            catch (DataObjectNotFoundException doe) {
                doe.printStackTrace();
                return;
            }
            StyledDocument doc = ((DataEditorSupport)dobj.getCookie(OpenCookie.class)).getDocument();
            if (doc != null) {
                doc.removeDocumentListener(this);
                doc.addDocumentListener(this);
            }
            DisText text = new DisText();
            int pos = RESPONSE_HEADER.length();
            boolean nameSet = false;
            File srcFile = null;
            if (resolvedFileName != null) {
                srcFile = new File(resolvedFileName);
            }
            long start = System.currentTimeMillis();
            boolean dialogOpened = false;
            DisProgressPanel panel = null;
            while (!this.cancelled) {
                int combinedPos = msg.indexOf(COMBINED_HEADER, pos);
                int addressPos = msg.indexOf(ADDRESS_HEADER, pos);
                try {
                    if (panel != null) {
                        panel.setProgress(pos * 100 / msg.length());
                    }
                    if (!this.cancelled && !dialogOpened && System.currentTimeMillis() - start > 2000L) {
                        dialogOpened = true;
                        panel = new DisProgressPanel();
                        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(Disassembly.class, (String)"DIS_PROGRESS_TITLE"));
                        dd.setOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
                        final Dialog dlg = dialog = DialogDisplayer.getDefault().createDialog(dd);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dlg.setVisible(true);
                                if (dd.getValue() == DialogDescriptor.CANCEL_OPTION) {
                                    Disassembly.this.cancel();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (addressPos == -1) break;
                if (combinedPos != -1 && combinedPos < addressPos) {
                    int lineIdx = Integer.valueOf(Disassembly.readValue(LINE_HEADER, msg, combinedPos));
                    if (lineIdx > 0) {
                        String fileStr = Disassembly.readValue(FILE_HEADER, msg, combinedPos);
                        if (srcFile != null && srcFile.getName().equals(fileStr)) {
                            FileObject src_fo = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)srcFile));
                            if (src_fo != null) {
                                try {
                                    String lineText = ((LineCookie)DataObject.find((FileObject)src_fo).getCookie(LineCookie.class)).getLineSet().getCurrent(lineIdx - 1).getText();
                                    if (lineText != null && lineText.length() > 0) {
                                        text.addLine(COMMENT_PREFIX + lineText);
                                    }
                                }
                                catch (Exception ex) {}
                            } else {
                                text.addLine(COMMENT_PREFIX + NbBundle.getMessage(Disassembly.class, (String)"MSG_Source_Not_Found", (Object)fileStr, (Object)lineIdx));
                            }
                        }
                    }
                    pos = combinedPos + 1;
                    continue;
                }
                int idx = text.getLineNo();
                Line line = new Line(msg, addressPos, nameSet ? idx : idx + 1);
                if (!nameSet && currentAddr.equals(line.address)) {
                    functionName = line.function;
                    dobj.getNodeDelegate().setDisplayName(Disassembly.getHeader());
                    text.addLine(functionName + "()\n");
                    nameSet = true;
                }
                if (!nameSet || functionName.equals(line.function)) {
                    this.lines.add(line);
                    text.addLine(line + "\n");
                }
                pos = addressPos + 1;
            }
            if (!this.cancelled) {
                this.disLength = text.getLength();
                try {
                    text.save(Disassembly.getFileObject().getOutputStream());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if (dialog != null) {
            final Dialog dlg = dialog;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dlg.setVisible(false);
                    dlg.dispose();
                }
            });
        }
        if (this.cancelled) {
            Disassembly.close();
            return;
        }
        if (this.lines.isEmpty() && this.withSource) {
            this.reloadDis(false, true);
        }
    }

    public void updateRegNames(String msg) {
        int end;
        assert (msg.startsWith(REGISTER_NAMES_HEADER)) : "Invalid asm response message";
        this.regNames.clear();
        int idx = 0;
        int pos = msg.indexOf("\"", REGISTER_NAMES_HEADER.length());
        while (pos != -1 && (end = msg.indexOf("\"", pos + 1)) != -1) {
            String value = msg.substring(pos + 1, end);
            this.regNames.put(idx++, value);
            pos = msg.indexOf("\"", end + 1);
        }
    }

    public void updateRegModified(String msg) {
        int end;
        assert (msg.startsWith(REGISTER_MODIFIED_HEADER)) : "Invalid asm response message";
        this.regModified.clear();
        int pos = msg.indexOf("\"", REGISTER_MODIFIED_HEADER.length());
        while (pos != -1 && (end = msg.indexOf("\"", pos + 1)) != -1) {
            String index = msg.substring(pos + 1, end);
            try {
                this.regModified.add(Integer.valueOf(index));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            pos = msg.indexOf("\"", end + 1);
        }
    }

    public void updateRegValues(String msg) {
        assert (msg.startsWith(REGISTER_VALUES_HEADER)) : "Invalid asm response message";
        this.regValues.clear();
        int pos = msg.indexOf(NUMBER_HEADER);
        while (pos != -1) {
            String idx = Disassembly.readValue(NUMBER_HEADER, msg, pos);
            String value = Disassembly.readValue(VALUE_HEADER, msg, pos);
            try {
                this.regValues.put(Integer.valueOf(idx), value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            pos = msg.indexOf(NUMBER_HEADER, pos + 1);
        }
    }

    public List<RegisterValue> getRegisterValues() {
        ArrayList<RegisterValue> res = new ArrayList<RegisterValue>();
        for (Integer idx : this.regValues.keySet()) {
            String name = this.regNames.get(idx);
            if (name == null) {
                log.severe("Unknown register: " + idx);
                name = String.valueOf(idx);
            }
            res.add(new RegisterValue(name, this.regValues.get(idx), this.regModified.contains(idx)));
        }
        return res;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (e.getOffset() + e.getLength() >= this.disLength) {
            final boolean dis = this.opening;
            this.opening = false;
            if (this.opened) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Disassembly.this.updateAnnotations(dis);
                    }
                });
            }
        }
    }

    private void updateAnnotations(boolean open) {
        this.debugger.fireDisUpdate(open);
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        Breakpoint[] bs = dm.getBreakpoints();
        for (int i = 0; i < bs.length; ++i) {
            if (!(bs[i] instanceof AddressBreakpoint)) continue;
            ((AddressBreakpoint)bs[i]).refresh();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentCallStackFrame".equals(evt.getPropertyName())) {
            this.reloadDis(true, false);
        }
    }

    private void reloadDis(boolean withSource, boolean force) {
        this.withSource = withSource;
        if (!this.opened) {
            return;
        }
        GdbCallStackFrame frame = this.debugger.getCurrentCallStackFrame();
        if (frame == null) {
            return;
        }
        String curAddress = frame.getAddr();
        if (curAddress == null || curAddress.length() == 0) {
            return;
        }
        if (!curAddress.equals(this.address)) {
            this.requestMode = RequestMode.FILE;
        }
        if (this.requestMode == RequestMode.NONE) {
            return;
        }
        if (force || this.getAddressLine(curAddress) == -1) {
            intFileName = frame.getOriginalFullName();
            resolvedFileName = frame.getFullname();
            if ((intFileName == null || intFileName.length() == 0) && this.requestMode == RequestMode.FILE) {
                this.requestMode = RequestMode.ADDRESS;
            }
            switch (this.requestMode) {
                case FILE: {
                    this.debugger.getGdbProxy().data_disassemble(intFileName, frame.getLineNumber(), withSource);
                    this.requestMode = RequestMode.ADDRESS;
                    break;
                }
                case ADDRESS: {
                    this.debugger.getGdbProxy().data_disassemble(1000, withSource);
                    this.requestMode = RequestMode.NONE;
                }
            }
        }
        this.address = curAddress;
    }

    public static FileObject getFileObject() {
        if (fo == null) {
            try {
                fo = FileUtil.createMemoryFileSystem().getRoot().createData("disasm", "s");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineAddress(int idx) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                if (line.idx != idx) continue;
                return line.address;
            }
            return "";
        }
    }

    public static Disassembly getCurrent() {
        GdbDebugger debugger = GdbDebugger.getGdbDebugger();
        if (debugger == null) {
            return null;
        }
        return debugger.getDisassembly();
    }

    public static String getLineAddress(Disassembly dis, int idx) {
        if (dis != null) {
            return dis.getLineAddress(idx);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAddressLine(String address) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                if (!line.address.equals(address)) continue;
                return line.idx;
            }
            return -1;
        }
    }

    public static int getAddressLine(Disassembly dis, String address) {
        if (dis != null) {
            return dis.getAddressLine(address);
        }
        return -1;
    }

    private static String readValue(String name, String msg, int pos) {
        int end;
        String paramHeader = name + "=\"";
        int start = msg.indexOf(paramHeader, pos);
        if (start != -1 && (end = msg.indexOf("\"", (start += paramHeader.length()) + 1)) != -1) {
            return msg.substring(start, end);
        }
        return "";
    }

    public static boolean isInDisasm() {
        DataObject dobj = EditorContextBridge.getContext().getCurrentDataObject();
        if (dobj == null) {
            dobj = EditorContextBridge.getContext().getMostRecentDataObject();
        }
        if (dobj == null) {
            return false;
        }
        try {
            return dobj.equals(DataObject.find((FileObject)Disassembly.getFileObject()));
        }
        catch (DataObjectNotFoundException doe) {
            doe.printStackTrace();
            return false;
        }
    }

    public static boolean isDisasm(String url) {
        try {
            return Disassembly.getFileObject().getURL().toString().equals(url);
        }
        catch (FileStateInvalidException fsi) {
            fsi.printStackTrace();
            return false;
        }
    }

    public static void open() {
        try {
            DataObject dobj = DataObject.find((FileObject)Disassembly.getFileObject());
            ReadOnlySupport ro = (ReadOnlySupport)dobj.getLookup().lookup(ReadOnlySupport.class);
            if (ro != null) {
                ro.setReadOnly(true);
            }
            dobj.getNodeDelegate().setDisplayName(NbBundle.getMessage(Disassembly.class, (String)"LBL_Disassembly_Window"));
            final EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (editorCookie instanceof EditorCookie.Observable) {
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("openedPanes".equals(evt.getPropertyName()) && editorCookie.getOpenedPanes() == null) {
                            Disassembly dis = Disassembly.getCurrent();
                            if (dis != null) {
                                dis.opened = false;
                            }
                            ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    }
                });
            }
            ((OpenCookie)dobj.getCookie(OpenCookie.class)).open();
            Disassembly dis = Disassembly.getCurrent();
            if (dis != null) {
                dis.opening = true;
                dis.opened = true;
                dis.reloadDis(true, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getHeader() {
        String res = NbBundle.getMessage(Disassembly.class, (String)"LBL_Disassembly_Window");
        if (functionName.length() > 0) {
            res = res + "(" + functionName + ")";
        }
        return res;
    }

    public static void close() {
        try {
            DataObject dobj = DataObject.find((FileObject)Disassembly.getFileObject());
            ((CloseCookie)dobj.getCookie(CloseCookie.class)).close();
            Disassembly dis = Disassembly.getCurrent();
            if (dis != null) {
                dis.opened = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class DisText {
        private int lineNo = 1;
        private int length = 0;
        private final StringBuilder data = new StringBuilder();

        private DisText() {
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getLength() {
            return this.length;
        }

        public void addLine(String line) {
            this.data.append(line);
            ++this.lineNo;
            this.length += line.length();
        }

        public void save(OutputStream out) throws IOException {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(this.data.toString());
            ((Writer)writer).close();
        }
    }

    private static class Line {
        private final String address;
        private final String function;
        private final int offset;
        private final String instruction;
        private final int idx;

        public Line(String msg, int pos, int idx) {
            this.address = Disassembly.readValue(Disassembly.ADDRESS_HEADER, msg, pos);
            this.function = Disassembly.readValue(Disassembly.FUNCTION_HEADER, msg, pos);
            int tmpoffset = 0;
            try {
                tmpoffset = Integer.valueOf(Disassembly.readValue(Disassembly.OFFSET_HEADER, msg, pos));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.offset = tmpoffset;
            this.instruction = Disassembly.readValue(Disassembly.INSTR_HEADER, msg, pos);
            this.idx = idx;
        }

        public String toString() {
            return this.function + "+" + this.offset + ": " + this.instruction;
        }
    }

    private static enum RequestMode {
        FILE,
        ADDRESS,
        NONE;

    }
}

