/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.dom;

import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.text.dom.XMLSyntaxSupport;

public abstract class SyntaxElement {
    protected XMLSyntaxSupport support;
    private WeakReference<Token> first;
    private WeakReference<SyntaxElement> previous;
    private WeakReference<SyntaxElement> next;
    protected int offset;
    protected int length;

    SyntaxElement(XMLSyntaxSupport support, Token<XMLTokenId> token, int start, int end) {
        this.support = support;
        this.offset = start;
        this.length = end - start;
        this.first = new WeakReference<Token<XMLTokenId>>(token);
    }

    protected Token first() {
        Token cached_first = (Token)this.first.get();
        if (cached_first != null) {
            return cached_first;
        }
        try {
            Token new_first = this.support.getNextToken(this.offset);
            this.first = new WeakReference<Token>(new_first);
            return new_first;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    void setNext(SyntaxElement se) {
        this.next = new WeakReference<SyntaxElement>(se);
    }

    void setPrevious(SyntaxElement se) {
        this.previous = new WeakReference<SyntaxElement>(se);
    }

    public SyntaxElement getPrevious() {
        SyntaxElement cached_previous;
        SyntaxElement syntaxElement = cached_previous = this.previous == null ? null : (SyntaxElement)this.previous.get();
        if (cached_previous != null) {
            return cached_previous;
        }
        try {
            if (this.offset == 0) {
                return null;
            }
            SyntaxElement new_previous = this.support.getElementChain(this.getElementOffset() - 1);
            if (new_previous != null) {
                this.setPrevious(new_previous);
                new_previous.setNext(this);
                if (new_previous.offset == this.offset) {
                    return null;
                }
            }
            return new_previous;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public SyntaxElement getNext() {
        SyntaxElement cached_next;
        SyntaxElement syntaxElement = cached_next = this.next == null ? null : (SyntaxElement)this.next.get();
        if (cached_next != null) {
            return cached_next;
        }
        try {
            SyntaxElement new_next = this.support.getElementChain(this.offset + this.length);
            if (new_next != null) {
                this.setNext(new_next);
                new_next.setPrevious(this);
                if (new_next.offset == this.offset) {
                    return null;
                }
            }
            return new_next;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public String toString() {
        String content = "?";
        return "SyntaxElement [offset=" + this.offset + "; length=" + this.length + " ;type = " + this.getClass().getName() + "; content:" + content + "]";
    }

    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.length;
    }

    public boolean equals(Object obj) {
        return obj instanceof SyntaxElement && ((SyntaxElement)obj).offset == this.offset;
    }

    public static class Error
    extends SyntaxElement {
        public Error(XMLSyntaxSupport support, Token first, int start, int end) {
            super(support, (Token<XMLTokenId>)first, start, end);
        }

        @Override
        public String toString() {
            return "Error" + super.toString();
        }
    }
}

