/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadT0Client;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.TLP224Exception;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientT0Protocol
extends ClientProtocol {
    private Apdu getResponseApdu;
    private static final int MAX_APDU_SIZE = 224;
    private static final int maxOutputExt = Short.MAX_VALUE;
    private static final int maxOutput = 256;
    private static final byte ENVELOPE_INS = -62;
    private byte[] dataOut = new byte[Short.MAX_VALUE];
    protected boolean auto61xx;

    public ClientT0Protocol(CadT0Client cad) {
        this.cad = cad;
        this.getResponseApdu = new Apdu();
        this.auto61xx = true;
    }

    public void setAuto61xx(boolean state) {
        this.auto61xx = state;
    }

    public boolean getAuto61xx() {
        return this.auto61xx;
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException, TLP224Exception {
        int[] lengths = new int[2];
        CadT0Client cadt0 = (CadT0Client)this.cad;
        byte originalCLAByte = apdu.getChannelInfo();
        block0 : switch (apdu.getCase()) {
            case 1: 
            case 2: {
                apdu.dataOut = new byte[Short.MAX_VALUE];
                lengths[0] = apdu.Le;
                int statusCode = cadt0.isoOut(apdu.command, apdu.dataOut, lengths, apdu.sw1sw2);
                if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                    throw new TLP224Exception(statusCode);
                }
                apdu.Le = lengths[1];
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= 256) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(originalCLAByte);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int Le = apdu.sw1sw2[1] & 0xFF;
                    if (Le == 0) {
                        Le = 256;
                    }
                    lengths[0] = Le;
                    statusCode = cadt0.isoOut(this.getResponseApdu.command, this.dataOut, lengths, apdu.sw1sw2);
                    if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lengths[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, lengths[1]);
                    apdu.Le += lengths[1];
                }
                break;
            }
            case 3: {
                int statusCode = cadt0.isoIn(apdu.command, apdu.dataIn, apdu.Lc, apdu.sw1sw2);
                if (statusCode == 0 || statusCode == 231 || statusCode == 229) break;
                throw new TLP224Exception(statusCode);
            }
            case 4: {
                int statusCode = cadt0.isoIn(apdu.command, apdu.dataIn, apdu.Lc, apdu.sw1sw2);
                if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                    throw new TLP224Exception(statusCode);
                }
                apdu.dataOut = new byte[Short.MAX_VALUE];
                apdu.Le = 0;
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= 256) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(originalCLAByte);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int Le = apdu.sw1sw2[1] & 0xFF;
                    if (Le == 0) {
                        Le = 256;
                    }
                    lengths[0] = Le;
                    statusCode = cadt0.isoOut(this.getResponseApdu.command, this.dataOut, lengths, apdu.sw1sw2);
                    if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lengths[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, lengths[1]);
                    apdu.Le += lengths[1];
                }
                break;
            }
            case 5: {
                if (apdu.Le > Short.MAX_VALUE || apdu.Le < 0) {
                    throw new IllegalArgumentException();
                }
                apdu.dataOut = new byte[Short.MAX_VALUE];
                lengths[0] = 0;
                int statusCode = cadt0.isoOut(apdu.command, apdu.dataOut, lengths, apdu.sw1sw2);
                if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                    throw new TLP224Exception(statusCode);
                }
                apdu.Le = lengths[1];
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= Short.MAX_VALUE) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(originalCLAByte);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int Le = apdu.sw1sw2[1] & 0xFF;
                    if (Le == 0) {
                        Le = 256;
                    }
                    lengths[0] = Le;
                    statusCode = cadt0.isoOut(this.getResponseApdu.command, this.dataOut, lengths, apdu.sw1sw2);
                    if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lengths[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, lengths[1]);
                    apdu.Le += lengths[1];
                }
                break;
            }
            case 6: {
                Vector<Apdu> apduSet = this.envelopeAPDU(apdu);
                Enumeration<Apdu> enumAPDU = apduSet.elements();
                while (enumAPDU.hasMoreElements()) {
                    int statusCode;
                    Apdu nextApdu = enumAPDU.nextElement();
                    boolean lastCmd = false;
                    if (!enumAPDU.hasMoreElements()) {
                        lastCmd = true;
                    }
                    if ((statusCode = cadt0.isoIn(nextApdu.command, nextApdu.dataIn, nextApdu.Lc, nextApdu.sw1sw2)) != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lastCmd) {
                        apdu.sw1sw2[0] = nextApdu.sw1sw2[0];
                        apdu.sw1sw2[1] = nextApdu.sw1sw2[1];
                        continue;
                    }
                    if (nextApdu.sw1sw2[0] == -112 && nextApdu.sw1sw2[1] == 0) continue;
                    apdu.sw1sw2[0] = nextApdu.sw1sw2[0];
                    apdu.sw1sw2[1] = nextApdu.sw1sw2[1];
                    break block0;
                }
                break;
            }
            case 7: {
                int statusCode;
                if (apdu.Le > Short.MAX_VALUE || apdu.Lc > Short.MAX_VALUE || apdu.Le < 0 || apdu.Lc < 0) {
                    throw new IllegalArgumentException();
                }
                apdu.dataOut = new byte[Short.MAX_VALUE];
                Vector<Apdu> apduSet = this.envelopeAPDU(apdu);
                Enumeration<Apdu> enumAPDU = apduSet.elements();
                while (enumAPDU.hasMoreElements()) {
                    Apdu nextApdu = enumAPDU.nextElement();
                    boolean lastCmd = false;
                    if (!enumAPDU.hasMoreElements()) {
                        lastCmd = true;
                    }
                    if ((statusCode = cadt0.isoIn(nextApdu.command, nextApdu.dataIn, nextApdu.Lc, nextApdu.sw1sw2)) != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lastCmd) {
                        apdu.sw1sw2[0] = nextApdu.sw1sw2[0];
                        apdu.sw1sw2[1] = nextApdu.sw1sw2[1];
                        continue;
                    }
                    if (nextApdu.sw1sw2[0] == -112 && nextApdu.sw1sw2[1] == 0) continue;
                    apdu.sw1sw2[0] = nextApdu.sw1sw2[0];
                    apdu.sw1sw2[1] = nextApdu.sw1sw2[1];
                    break;
                }
                apdu.Le = lengths[1];
                while (this.auto61xx && apdu.sw1sw2[0] == 97 && apdu.Le + (apdu.sw1sw2[1] & 0xFF) <= Short.MAX_VALUE) {
                    this.getResponseApdu.command[0] = apdu.makeISOInterIndustryCLA(originalCLAByte);
                    this.getResponseApdu.command[1] = -64;
                    this.getResponseApdu.command[2] = 0;
                    this.getResponseApdu.command[3] = 0;
                    this.getResponseApdu.command[4] = apdu.sw1sw2[1];
                    int Le = apdu.sw1sw2[1] & 0xFF;
                    if (Le == 0) {
                        Le = 256;
                    }
                    lengths[0] = Le;
                    statusCode = cadt0.isoOut(this.getResponseApdu.command, this.dataOut, lengths, apdu.sw1sw2);
                    if (statusCode != 0 && statusCode != 231 && statusCode != 229) {
                        throw new TLP224Exception(statusCode);
                    }
                    if (lengths[1] == 0) break block0;
                    System.arraycopy(this.dataOut, 0, apdu.dataOut, apdu.Le, lengths[1]);
                    apdu.Le += lengths[1];
                }
                break;
            }
            default: {
                throw new TLP224Exception(23);
            }
        }
    }

    private Vector<Apdu> envelopeAPDU(Apdu apdu) {
        byte originalCLAByte = apdu.getChannelInfo();
        Vector<Apdu> envelopeAPDUs = new Vector<Apdu>();
        int dataOverhead = apdu.Le > 0 ? 9 : 7;
        int numBytes = apdu.Lc + dataOverhead;
        int numCmds = numBytes / 219;
        if (numCmds * 224 < numBytes) {
            ++numCmds;
        }
        boolean firstCmd = true;
        int bytesRemaining = numBytes;
        while (bytesRemaining > 0) {
            int cmdSize;
            int bufferCtr = 0;
            boolean lastCmd = false;
            if (bytesRemaining > 219) {
                cmdSize = 219;
            } else {
                cmdSize = bytesRemaining;
                lastCmd = true;
            }
            Apdu partApdu = new Apdu();
            partApdu.command[0] = apdu.makeISOInterIndustryCLA(originalCLAByte);
            partApdu.command[1] = -62;
            partApdu.command[2] = 0;
            partApdu.command[3] = 0;
            partApdu.command[4] = (byte)cmdSize;
            partApdu.Lc = cmdSize;
            partApdu.Le = 0;
            partApdu.dataIn = new byte[cmdSize];
            if (firstCmd) {
                firstCmd = false;
                System.arraycopy(apdu.command, 0, partApdu.dataIn, 0, 4);
                partApdu.dataIn[4] = 0;
                int lch = apdu.Lc >> 8 & 0xFF;
                int lcl = apdu.Lc & 0xFF;
                partApdu.dataIn[5] = (byte)lch;
                partApdu.dataIn[6] = (byte)lcl;
                bytesRemaining -= 7;
                bufferCtr = 7;
            }
            int dataCtr = numBytes - 7 - bytesRemaining;
            int copySize = lastCmd && apdu.Le > 0 ? cmdSize - 2 - bufferCtr : cmdSize - bufferCtr;
            if (copySize < 0) {
                copySize = 0;
            }
            if (apdu.Lc - dataCtr < copySize) {
                copySize = apdu.Lc - dataCtr;
            }
            System.arraycopy(apdu.dataIn, dataCtr, partApdu.dataIn, bufferCtr, copySize);
            dataCtr += copySize;
            bytesRemaining -= copySize;
            if ((bufferCtr += copySize) != 219 && apdu.Le > 0) {
                if (bytesRemaining == 1 && lastCmd) {
                    if (apdu.Le > 0) {
                        partApdu.dataIn[bufferCtr++] = (byte)(apdu.Le & 0xFF);
                        --bytesRemaining;
                    }
                } else if (bytesRemaining == 2 && !lastCmd) {
                    partApdu.dataIn[bufferCtr++] = (byte)(apdu.Le >> 8 & 0xFF);
                    --bytesRemaining;
                } else if (lastCmd) {
                    partApdu.dataIn[bufferCtr++] = (byte)(apdu.Le >> 8 & 0xFF);
                    partApdu.dataIn[bufferCtr++] = (byte)(apdu.Le & 0xFF);
                    bytesRemaining -= 2;
                }
            }
            envelopeAPDUs.add(partApdu);
        }
        return envelopeAPDUs;
    }
}

