/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.MatcherUtilities;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class ConvertToStringSwitch {
    private static final String[] PATTERNS = new String[]{"$var == $constant", "$constant == $var", "$var.equals($constant)", "$constant.equals($var)", "$var.contentEquals($constant)", "$constant.contentEquals($var)"};

    public static List<ErrorDescription> hint(HintContext hintContext) {
        TreePath treePath;
        IfTree ifTree;
        TreePath treePath2;
        TreePathHandle treePathHandle;
        LinkedHashMap<TreePathHandle, TreePathHandle> linkedHashMap;
        block9: {
            if (hintContext.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.IF || hintContext.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0) {
                return null;
            }
            linkedHashMap = new LinkedHashMap<TreePathHandle, TreePathHandle>();
            treePathHandle = null;
            TreePath treePath3 = hintContext.getVariables().get("$c1");
            TreePath treePath4 = hintContext.getVariables().get("$c2");
            TreePath treePath5 = hintContext.getVariables().get("$body");
            if (Utilities.isConstantString(hintContext.getInfo(), treePath3)) {
                linkedHashMap.put(TreePathHandle.create((TreePath)treePath3, (CompilationInfo)hintContext.getInfo()), TreePathHandle.create((TreePath)treePath5, (CompilationInfo)hintContext.getInfo()));
                treePath2 = treePath4;
            } else if (Utilities.isConstantString(hintContext.getInfo(), treePath4)) {
                linkedHashMap.put(TreePathHandle.create((TreePath)treePath4, (CompilationInfo)hintContext.getInfo()), TreePathHandle.create((TreePath)treePath5, (CompilationInfo)hintContext.getInfo()));
                treePath2 = treePath3;
            } else {
                return null;
            }
            hintContext.getVariables().put("$var", treePath2);
            TreePath treePath6 = hintContext.getVariables().get("$else");
            while (treePath6.getLeaf().getKind() == Tree.Kind.IF) {
                ifTree = (IfTree)treePath6.getLeaf();
                treePath = ConvertToStringSwitch.isStringComparison(hintContext, new TreePath(treePath6, ifTree.getCondition()));
                if (treePath == null) {
                    return null;
                }
                linkedHashMap.put(TreePathHandle.create((TreePath)treePath, (CompilationInfo)hintContext.getInfo()), TreePathHandle.create((TreePath)new TreePath(treePath6, ifTree.getThenStatement()), (CompilationInfo)hintContext.getInfo()));
                if (ifTree.getElseStatement() != null) {
                    treePath6 = new TreePath(treePath6, ifTree.getElseStatement());
                    continue;
                }
                break block9;
            }
            treePathHandle = TreePathHandle.create((TreePath)treePath6, (CompilationInfo)hintContext.getInfo());
        }
        if (linkedHashMap.size() <= 1) {
            return null;
        }
        ifTree = JavaFix.toEditorFix(new ConvertToSwitch(hintContext.getInfo(), hintContext.getPath(), TreePathHandle.create((TreePath)treePath2, (CompilationInfo)hintContext.getInfo()), linkedHashMap, treePathHandle));
        treePath = ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), "Convert to switch", new Fix[]{ifTree});
        return Collections.singletonList(treePath);
    }

    private static TreePath isStringComparison(HintContext hintContext, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        while (tree.getKind() == Tree.Kind.PARENTHESIZED) {
            treePath = new TreePath(treePath, ((ParenthesizedTree)tree).getExpression());
            tree = treePath.getLeaf();
        }
        for (String string : PATTERNS) {
            hintContext.getVariables().remove("$constant");
            if (!MatcherUtilities.matches(hintContext, treePath, string, true)) continue;
            return hintContext.getVariables().get("$constant");
        }
        return null;
    }

    private static final class ConvertToSwitch
    extends JavaFix {
        private final TreePathHandle value;
        private final Map<TreePathHandle, TreePathHandle> literal2Statement;
        private final TreePathHandle defaultStatement;

        public ConvertToSwitch(CompilationInfo compilationInfo, TreePath treePath, TreePathHandle treePathHandle, Map<TreePathHandle, TreePathHandle> map, TreePathHandle treePathHandle2) {
            super(compilationInfo, treePath);
            this.value = treePathHandle;
            this.literal2Statement = map;
            this.defaultStatement = treePathHandle2;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(ConvertToStringSwitch.class, (String)"FIX_ConvertToStringSwitch");
        }

        @Override
        protected void performRewrite(WorkingCopy workingCopy, TreePath treePath, JavaFix.UpgradeUICallback upgradeUICallback) {
            Object object;
            Object object2;
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            LinkedList<CaseTree> linkedList = new LinkedList<CaseTree>();
            for (Map.Entry<TreePathHandle, TreePathHandle> object32 : this.literal2Statement.entrySet()) {
                object2 = object32.getKey().resolve((CompilationInfo)workingCopy);
                TreePath treePath2 = object32.getValue().resolve((CompilationInfo)workingCopy);
                if (object2 == null || treePath2 == null) {
                    return;
                }
                LinkedList<? extends StatementTree> linkedList2 = new LinkedList<StatementTree>();
                Tree tree = treePath2.getLeaf();
                if (tree.getKind() == Tree.Kind.BLOCK) {
                    linkedList2.addAll(((BlockTree)tree).getStatements());
                } else {
                    linkedList2.add((StatementTree)tree);
                }
                linkedList2.add(treeMaker.Break(null));
                linkedList.add(treeMaker.Case((ExpressionTree)((TreePath)object2).getLeaf(), linkedList2));
            }
            if (this.defaultStatement != null) {
                object = this.defaultStatement.resolve((CompilationInfo)workingCopy);
                if (object == null) {
                    return;
                }
                LinkedList<? extends StatementTree> linkedList3 = new LinkedList<StatementTree>();
                object2 = ((TreePath)object).getLeaf();
                if (object2.getKind() == Tree.Kind.BLOCK) {
                    linkedList3.addAll(((BlockTree)object2).getStatements());
                } else {
                    linkedList3.add((StatementTree)object2);
                }
                linkedList3.add(treeMaker.Break(null));
                linkedList.add(treeMaker.Case(null, linkedList3));
            }
            object = this.value.resolve((CompilationInfo)workingCopy);
            SwitchTree switchTree = treeMaker.Switch((ExpressionTree)((TreePath)object).getLeaf(), linkedList);
            workingCopy.rewrite(treePath.getLeaf(), (Tree)switchTree);
        }
    }
}

