/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.hints.ConvertAnonymousToInner;
import org.netbeans.modules.java.hints.infrastructure.HintAction;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConvertAnonymousToInnerAction
extends HintAction {
    public ConvertAnonymousToInnerAction() {
        this.putValue("Name", NbBundle.getMessage(ConvertAnonymousToInnerAction.class, (String)"CTL_ConvertAnonymousToInner"));
    }

    @Override
    protected void perform(JavaSource javaSource, final int[] nArray) {
        final Fix[] fixArray = new Fix[1];
        String string = null;
        if (nArray[0] == nArray[1]) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        TreePath treePath;
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        for (treePath = compilationController.getTreeUtilities().pathFor(nArray[0]); treePath != null && treePath.getLeaf().getKind() != Tree.Kind.NEW_CLASS; treePath = treePath.getParentPath()) {
                        }
                        if (treePath == null) {
                            return;
                        }
                        fixArray[0] = ConvertAnonymousToInner.computeFix((CompilationInfo)compilationController, treePath, -1);
                    }
                }, true);
                if (fixArray[0] == null) {
                    string = "ERR_CaretNotInAnonymousInnerclass";
                }
            }
            catch (IOException iOException) {
                string = "ERR_SelectionNotSupported";
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            string = "ERR_SelectionNotSupported";
        }
        if (fixArray[0] != null) {
            try {
                fixArray[0].implement();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            return;
        }
        if (string != null) {
            String string2 = NbBundle.getMessage(ConvertAnonymousToInnerAction.class, (String)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }

    @Override
    protected boolean requiresSelection() {
        return false;
    }
}

